/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.stats;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opencensus.internal.Provider;
import net.snowflake.client.jdbc.internal.opencensus.stats.NoopStats;
import net.snowflake.client.jdbc.internal.opencensus.stats.StatsCollectionState;
import net.snowflake.client.jdbc.internal.opencensus.stats.StatsComponent;
import net.snowflake.client.jdbc.internal.opencensus.stats.StatsRecorder;
import net.snowflake.client.jdbc.internal.opencensus.stats.ViewManager;

public final class Stats {
    private static final Logger logger = Logger.getLogger(Stats.class.getName());
    private static final StatsComponent statsComponent = Stats.loadStatsComponent(StatsComponent.class.getClassLoader());

    public static StatsRecorder getStatsRecorder() {
        return statsComponent.getStatsRecorder();
    }

    public static ViewManager getViewManager() {
        return statsComponent.getViewManager();
    }

    public static StatsCollectionState getState() {
        return statsComponent.getState();
    }

    @Deprecated
    public static void setState(StatsCollectionState state) {
        statsComponent.setState(state);
    }

    static StatsComponent loadStatsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("net.snowflake.client.jdbc.internal.opencensus.impl.stats.StatsComponentImpl", true, classLoader), StatsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for StatsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("net.snowflake.client.jdbc.internal.opencensus.impllite.stats.StatsComponentImplLite", true, classLoader), StatsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for StatsComponent, now using default implementation for StatsComponent.", e2);
                return NoopStats.newNoopStatsComponent();
            }
        }
    }

    private Stats() {
    }
}

