/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="removePipeline", name="Remove a pipeline")
public class RemovePipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = RemovePipelineServlet.class;
    private static final long serialVersionUID = 6618979989596401783L;
    public static final String CONTEXT_PATH = "/hop/removePipeline";

    public RemovePipelineServlet() {
    }

    public RemovePipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IPipelineEngine<PipelineMeta> pipeline;
        HopServerObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.RemovePipelineRequested", (String[])new String[0]));
        }
        String pipelineName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
            if (entry == null) {
                pipeline = null;
            } else {
                id = entry.getId();
                pipeline = this.getPipelineMap().getPipeline(entry);
            }
        } else {
            entry = new HopServerObjectEntry(pipelineName, id);
            pipeline = this.getPipelineMap().getPipeline(entry);
        }
        if (pipeline != null) {
            HopLogStore.discardLines((String)pipeline.getLogChannelId(), (boolean)true);
            this.getPipelineMap().removePipeline(entry);
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
                out.print(WebResult.OK.getXml());
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"RemovePipelineServlet.PipelineRemoved", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
                out.println("<H3>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"RemovePipelineServlet.ThePipelineWasRemoved", (String[])new String[]{pipelineName, id})) + "</H3>");
                out.print("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><br>");
                out.println("<p>");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindSpecPipeline", (String[])new String[]{pipelineName})));
        } else {
            out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"RemovePipelineServlet.PipelineRemoved.Log.CoundNotFindPipeline", (String[])new String[]{pipelineName, id})) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            response.setStatus(400);
        }
    }

    public String toString() {
        return "Remove pipeline servlet";
    }

    @Override
    public String getService() {
        return "/hop/removePipeline (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

