/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration.tabs;

import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.i18n.GlobalMessages;
import org.apache.hop.i18n.LanguageChoice;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ConfigGuiOptionsTab {
    private static final Class<?> PKG = BaseDialog.class;
    private FontData defaultFontData;
    private Font defaultFont;
    private FontData fixedFontData;
    private Font fixedFont;
    private FontData graphFontData;
    private Font graphFont;
    private FontData noteFontData;
    private Font noteFont;
    private Canvas wDefaultCanvas;
    private Canvas wFixedCanvas;
    private Canvas wGraphCanvas;
    private Canvas wNoteCanvas;
    private Text wIconSize;
    private Text wLineWidth;
    private Text wMiddlePct;
    private Combo wGlobalZoom;
    private Text wGridSize;
    private Button wDarkMode;
    private Button wShowCanvasGrid;
    private Button wHideViewport;
    private Button wHideMenuBar;
    private Button wShowTableViewToolbar;
    private Combo wDefaultLocale;

    @GuiTab(id="10100-config-perspective-gui-options-tab", parentId="ConfigurationPerspective.Tabs.ID", description="GUI options tab")
    public void addGuiOptionsTab(CTabFolder wTabFolder) {
        Shell shell = wTabFolder.getShell();
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        int middle = props.getMiddlePct();
        int h = (int)(40.0 * props.getZoomFactor());
        CTabItem wLookTab = new CTabItem(wTabFolder, 0);
        wLookTab.setFont(GuiResource.getInstance().getFontDefault());
        wLookTab.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.LookAndFeel.Label", (String[])new String[0]));
        wLookTab.setImage(GuiResource.getInstance().getImageHopUi());
        ScrolledComposite sLookComp = new ScrolledComposite((Composite)wTabFolder, 768);
        sLookComp.setLayout((Layout)new FillLayout());
        Composite wLookComp = new Composite((Composite)sLookComp, 0);
        PropsUi.setLook((Widget)wLookComp);
        FormLayout lookLayout = new FormLayout();
        lookLayout.marginWidth = PropsUi.getFormMargin();
        lookLayout.marginHeight = PropsUi.getFormMargin();
        wLookComp.setLayout((Layout)lookLayout);
        this.defaultFontData = props.getDefaultFont();
        this.defaultFont = new Font((Device)shell.getDisplay(), this.defaultFontData);
        this.fixedFontData = props.getFixedFont();
        this.fixedFont = new Font((Device)shell.getDisplay(), this.fixedFontData);
        this.graphFontData = props.getGraphFont();
        this.graphFont = new Font((Device)shell.getDisplay(), this.graphFontData);
        this.noteFontData = props.getNoteFont();
        this.noteFont = new Font((Device)shell.getDisplay(), this.noteFontData);
        int nr = 0;
        Label wlDFont = new Label(wLookComp, 131072);
        wlDFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DefaultFont.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDFont);
        FormData fdlDFont = new FormData();
        fdlDFont.left = new FormAttachment(0, 0);
        fdlDFont.right = new FormAttachment(middle, -margin);
        fdlDFont.top = new FormAttachment(0, margin + 10);
        wlDFont.setLayoutData((Object)fdlDFont);
        Button wdDFont = new Button(wLookComp, 0x1000008);
        PropsUi.setLook((Widget)wdDFont);
        FormData fddDFont = this.layoutResetOptionButton(wdDFont);
        fddDFont.right = new FormAttachment(100, 0);
        fddDFont.top = new FormAttachment(0, margin);
        fddDFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wdDFont.setLayoutData((Object)fddDFont);
        wdDFont.addListener(13, e -> this.resetDefaultFont(shell));
        Button wbDFont = new Button(wLookComp, 8);
        PropsUi.setLook((Widget)wbDFont);
        FormData fdbDFont = this.layoutEditOptionButton(wbDFont);
        fdbDFont.right = new FormAttachment((Control)wdDFont, -margin);
        fdbDFont.top = new FormAttachment(0, nr * h + margin);
        fdbDFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wbDFont.setLayoutData((Object)fdbDFont);
        wbDFont.addListener(13, e -> this.editDefaultFont(shell));
        this.wDefaultCanvas = new Canvas(wLookComp, 2048);
        PropsUi.setLook((Widget)this.wDefaultCanvas);
        FormData fdDFont = new FormData();
        fdDFont.left = new FormAttachment(middle, 0);
        fdDFont.right = new FormAttachment((Control)wbDFont, -margin);
        fdDFont.top = new FormAttachment(0, margin);
        fdDFont.bottom = new FormAttachment(0, h);
        this.wDefaultCanvas.setLayoutData((Object)fdDFont);
        this.wDefaultCanvas.addPaintListener(this::paintDefaultFont);
        this.wDefaultCanvas.addListener(3, e -> this.editDefaultFont(shell));
        ++nr;
        Label wlFFont = new Label(wLookComp, 131072);
        wlFFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.FixedWidthFont.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFFont);
        FormData fdlFFont = new FormData();
        fdlFFont.left = new FormAttachment(0, 0);
        fdlFFont.right = new FormAttachment(middle, -margin);
        fdlFFont.top = new FormAttachment(0, nr * h + margin + 10);
        wlFFont.setLayoutData((Object)fdlFFont);
        Button wdFFont = new Button(wLookComp, 0x1000008);
        PropsUi.setLook((Widget)wdFFont);
        FormData fddFFont = this.layoutResetOptionButton(wdFFont);
        fddFFont.right = new FormAttachment(100, 0);
        fddFFont.top = new FormAttachment(0, nr * h + margin);
        fddFFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wdFFont.setLayoutData((Object)fddFFont);
        wdFFont.addListener(13, e -> this.resetFixedFont(shell));
        Button wbFFont = new Button(wLookComp, 8);
        PropsUi.setLook((Widget)wbFFont);
        FormData fdbFFont = this.layoutEditOptionButton(wbFFont);
        fdbFFont.right = new FormAttachment((Control)wdFFont, -margin);
        fdbFFont.top = new FormAttachment(0, nr * h + margin);
        fdbFFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wbFFont.setLayoutData((Object)fdbFFont);
        wbFFont.addListener(13, e -> this.editFixedFont(shell));
        this.wFixedCanvas = new Canvas(wLookComp, 2048);
        PropsUi.setLook((Widget)this.wFixedCanvas);
        FormData fdFFont = new FormData();
        fdFFont.left = new FormAttachment(middle, 0);
        fdFFont.right = new FormAttachment((Control)wbFFont, -margin);
        fdFFont.top = new FormAttachment(0, nr * h + margin);
        fdFFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        this.wFixedCanvas.setLayoutData((Object)fdFFont);
        this.wFixedCanvas.addPaintListener(this::paintFixedFont);
        this.wFixedCanvas.addListener(3, e -> this.editFixedFont(shell));
        ++nr;
        Label wlGFont = new Label(wLookComp, 131072);
        wlGFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GraphFont.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGFont);
        FormData fdlGFont = new FormData();
        fdlGFont.left = new FormAttachment(0, 0);
        fdlGFont.right = new FormAttachment(middle, -margin);
        fdlGFont.top = new FormAttachment(0, nr * h + margin + 10);
        wlGFont.setLayoutData((Object)fdlGFont);
        Button wdGFont = new Button(wLookComp, 8);
        PropsUi.setLook((Widget)wdGFont);
        FormData fddGFont = this.layoutResetOptionButton(wdGFont);
        fddGFont.right = new FormAttachment(100, 0);
        fddGFont.top = new FormAttachment(0, nr * h + margin);
        fddGFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wdGFont.setLayoutData((Object)fddGFont);
        wdGFont.addListener(13, e -> this.resetGraphFont(shell, props));
        Button wbGFont = new Button(wLookComp, 8);
        PropsUi.setLook((Widget)wbGFont);
        FormData fdbGFont = this.layoutEditOptionButton(wbGFont);
        fdbGFont.right = new FormAttachment((Control)wdGFont, -margin);
        fdbGFont.top = new FormAttachment(0, nr * h + margin);
        fdbGFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wbGFont.setLayoutData((Object)fdbGFont);
        wbGFont.addListener(13, e -> this.editGraphFont(shell));
        this.wGraphCanvas = new Canvas(wLookComp, 2048);
        PropsUi.setLook((Widget)this.wGraphCanvas);
        FormData fdGFont = new FormData();
        fdGFont.left = new FormAttachment(middle, 0);
        fdGFont.right = new FormAttachment((Control)wbGFont, -margin);
        fdGFont.top = new FormAttachment(0, nr * h + margin);
        fdGFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        this.wGraphCanvas.setLayoutData((Object)fdGFont);
        this.wGraphCanvas.addPaintListener(this::drawGraphFont);
        this.wGraphCanvas.addListener(3, e -> this.editGraphFont(shell));
        ++nr;
        Label wlNFont = new Label(wLookComp, 131072);
        wlNFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.NoteFont.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNFont);
        FormData fdlNFont = new FormData();
        fdlNFont.left = new FormAttachment(0, 0);
        fdlNFont.right = new FormAttachment(middle, -margin);
        fdlNFont.top = new FormAttachment(0, nr * h + margin + 10);
        wlNFont.setLayoutData((Object)fdlNFont);
        Button wdNFont = new Button(wLookComp, 8);
        PropsUi.setLook((Widget)wdNFont);
        FormData fddNFont = this.layoutResetOptionButton(wdNFont);
        fddNFont.right = new FormAttachment(100, 0);
        fddNFont.top = new FormAttachment(0, nr * h + margin);
        fddNFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wdNFont.setLayoutData((Object)fddNFont);
        wdNFont.addListener(13, e -> this.resetNoteFont(e, props, shell.getDisplay()));
        Button wbNFont = new Button(wLookComp, 8);
        PropsUi.setLook((Widget)wbNFont);
        FormData fdbNFont = this.layoutEditOptionButton(wbNFont);
        fdbNFont.right = new FormAttachment((Control)wdNFont, -margin);
        fdbNFont.top = new FormAttachment(0, nr * h + margin);
        fdbNFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        wbNFont.setLayoutData((Object)fdbNFont);
        wbNFont.addListener(13, e -> this.editNoteFont(shell));
        this.wNoteCanvas = new Canvas(wLookComp, 2048);
        PropsUi.setLook((Widget)this.wNoteCanvas);
        FormData fdNFont = new FormData();
        fdNFont.left = new FormAttachment(middle, 0);
        fdNFont.right = new FormAttachment((Control)wbNFont, -margin);
        fdNFont.top = new FormAttachment(0, nr * h + margin);
        fdNFont.bottom = new FormAttachment(0, (nr + 1) * h + margin);
        this.wNoteCanvas.setLayoutData((Object)fdNFont);
        this.wNoteCanvas.addPaintListener(this::paintNoteFont);
        this.wNoteCanvas.addListener(3, e -> this.editNoteFont(shell));
        Label wlIconSize = new Label(wLookComp, 131072);
        wlIconSize.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.IconSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIconSize);
        FormData fdlIconSize = new FormData();
        fdlIconSize.left = new FormAttachment(0, 0);
        fdlIconSize.right = new FormAttachment(middle, -margin);
        fdlIconSize.top = new FormAttachment((Control)this.wNoteCanvas, margin);
        wlIconSize.setLayoutData((Object)fdlIconSize);
        this.wIconSize = new Text(wLookComp, 18436);
        this.wIconSize.setText(Integer.toString(props.getIconSize()));
        PropsUi.setLook((Widget)this.wIconSize);
        FormData fdIconSize = new FormData();
        fdIconSize.left = new FormAttachment(middle, 0);
        fdIconSize.right = new FormAttachment(100, -margin);
        fdIconSize.top = new FormAttachment((Control)wlIconSize, 0, 0x1000000);
        this.wIconSize.setLayoutData((Object)fdIconSize);
        this.wIconSize.addListener(24, e -> this.saveValues());
        Label wlLineWidth = new Label(wLookComp, 131072);
        wlLineWidth.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.LineWidth.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLineWidth);
        FormData fdlLineWidth = new FormData();
        fdlLineWidth.left = new FormAttachment(0, 0);
        fdlLineWidth.right = new FormAttachment(middle, -margin);
        fdlLineWidth.top = new FormAttachment((Control)this.wIconSize, margin);
        wlLineWidth.setLayoutData((Object)fdlLineWidth);
        this.wLineWidth = new Text(wLookComp, 18436);
        this.wLineWidth.setText(Integer.toString(props.getLineWidth()));
        PropsUi.setLook((Widget)this.wLineWidth);
        FormData fdLineWidth = new FormData();
        fdLineWidth.left = new FormAttachment(middle, 0);
        fdLineWidth.right = new FormAttachment(100, -margin);
        fdLineWidth.top = new FormAttachment((Control)wlLineWidth, 0, 0x1000000);
        this.wLineWidth.setLayoutData((Object)fdLineWidth);
        this.wLineWidth.addListener(24, e -> this.saveValues());
        Label wlMiddlePct = new Label(wLookComp, 131072);
        wlMiddlePct.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DialogMiddlePercentage.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMiddlePct);
        FormData fdlMiddlePct = new FormData();
        fdlMiddlePct.left = new FormAttachment(0, 0);
        fdlMiddlePct.right = new FormAttachment(middle, -margin);
        fdlMiddlePct.top = new FormAttachment((Control)this.wLineWidth, margin);
        wlMiddlePct.setLayoutData((Object)fdlMiddlePct);
        this.wMiddlePct = new Text(wLookComp, 18436);
        this.wMiddlePct.setText(Integer.toString(props.getMiddlePct()));
        PropsUi.setLook((Widget)this.wMiddlePct);
        FormData fdMiddlePct = new FormData();
        fdMiddlePct.left = new FormAttachment(middle, 0);
        fdMiddlePct.right = new FormAttachment(100, -margin);
        fdMiddlePct.top = new FormAttachment((Control)wlMiddlePct, 0, 0x1000000);
        this.wMiddlePct.setLayoutData((Object)fdMiddlePct);
        this.wMiddlePct.addListener(24, e -> this.saveValues());
        Label wlGlobalZoom = new Label(wLookComp, 131072);
        wlGlobalZoom.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GlobalZoom.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGlobalZoom);
        FormData fdlGlobalZoom = new FormData();
        fdlGlobalZoom.left = new FormAttachment(0, 0);
        fdlGlobalZoom.right = new FormAttachment(middle, -margin);
        fdlGlobalZoom.top = new FormAttachment((Control)this.wMiddlePct, margin);
        wlGlobalZoom.setLayoutData((Object)fdlGlobalZoom);
        this.wGlobalZoom = new Combo(wLookComp, 18444);
        this.wGlobalZoom.setItems(PropsUi.getGlobalZoomFactorLevels());
        PropsUi.setLook((Widget)this.wGlobalZoom);
        FormData fdGlobalZoom = new FormData();
        fdGlobalZoom.left = new FormAttachment(middle, 0);
        fdGlobalZoom.right = new FormAttachment(100, -margin);
        fdGlobalZoom.top = new FormAttachment((Control)wlGlobalZoom, 0, 0x1000000);
        this.wGlobalZoom.setLayoutData((Object)fdGlobalZoom);
        String globalZoomFactor = Integer.toString((int)(props.getGlobalZoomFactor() * 100.0)) + "%";
        this.wGlobalZoom.setText(globalZoomFactor);
        this.wGlobalZoom.addListener(24, e -> this.saveValues());
        Label wlGridSize = new Label(wLookComp, 131072);
        wlGridSize.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GridSize.Label", (String[])new String[0]));
        wlGridSize.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GridSize.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGridSize);
        FormData fdlGridSize = new FormData();
        fdlGridSize.left = new FormAttachment(0, 0);
        fdlGridSize.right = new FormAttachment(middle, -margin);
        fdlGridSize.top = new FormAttachment((Control)this.wGlobalZoom, margin);
        wlGridSize.setLayoutData((Object)fdlGridSize);
        this.wGridSize = new Text(wLookComp, 18436);
        this.wGridSize.setText(Integer.toString(props.getCanvasGridSize()));
        this.wGridSize.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GridSize.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wGridSize);
        FormData fdGridSize = new FormData();
        fdGridSize.left = new FormAttachment(middle, 0);
        fdGridSize.right = new FormAttachment(100, -margin);
        fdGridSize.top = new FormAttachment((Control)wlGridSize, 0, 0x1000000);
        this.wGridSize.setLayoutData((Object)fdGridSize);
        this.wGridSize.addListener(24, e -> this.saveValues());
        Label wlShowCanvasGrid = new Label(wLookComp, 131072);
        wlShowCanvasGrid.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowCanvasGrid.Label", (String[])new String[0]));
        wlShowCanvasGrid.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowCanvasGrid.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShowCanvasGrid);
        FormData fdlShowCanvasGrid = new FormData();
        fdlShowCanvasGrid.left = new FormAttachment(0, 0);
        fdlShowCanvasGrid.right = new FormAttachment(middle, -margin);
        fdlShowCanvasGrid.top = new FormAttachment((Control)this.wGridSize, margin);
        wlShowCanvasGrid.setLayoutData((Object)fdlShowCanvasGrid);
        this.wShowCanvasGrid = new Button(wLookComp, 32);
        PropsUi.setLook((Widget)this.wShowCanvasGrid);
        this.wShowCanvasGrid.setSelection(props.isShowCanvasGridEnabled());
        FormData fdShowCanvasGrid = new FormData();
        fdShowCanvasGrid.left = new FormAttachment(middle, 0);
        fdShowCanvasGrid.right = new FormAttachment(100, -margin);
        fdShowCanvasGrid.top = new FormAttachment((Control)wlShowCanvasGrid, 0, 0x1000000);
        this.wShowCanvasGrid.setLayoutData((Object)fdShowCanvasGrid);
        this.wShowCanvasGrid.addListener(13, e -> this.saveValues());
        Label wlHideViewport = new Label(wLookComp, 131072);
        wlHideViewport.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowViewport.Label", (String[])new String[0]));
        wlHideViewport.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowViewport.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHideViewport);
        FormData fdlHideViewport = new FormData();
        fdlHideViewport.left = new FormAttachment(0, 0);
        fdlHideViewport.right = new FormAttachment(middle, -margin);
        fdlHideViewport.top = new FormAttachment((Control)this.wShowCanvasGrid, margin);
        wlHideViewport.setLayoutData((Object)fdlHideViewport);
        this.wHideViewport = new Button(wLookComp, 32);
        PropsUi.setLook((Widget)this.wHideViewport);
        this.wHideViewport.setSelection(props.isHideViewportEnabled());
        FormData fdHideViewport = new FormData();
        fdHideViewport.left = new FormAttachment(middle, 0);
        fdHideViewport.right = new FormAttachment(100, -margin);
        fdHideViewport.top = new FormAttachment((Control)wlHideViewport, 0, 0x1000000);
        this.wHideViewport.setLayoutData((Object)fdHideViewport);
        this.wHideViewport.addListener(13, e -> this.saveValues());
        Label wlHideMenuBar = new Label(wLookComp, 131072);
        wlHideMenuBar.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.HideMenuBar.Label", (String[])new String[0]));
        wlHideMenuBar.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.HideMenuBar.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHideMenuBar);
        FormData fdlHideMenuBar = new FormData();
        fdlHideMenuBar.left = new FormAttachment(0, 0);
        fdlHideMenuBar.right = new FormAttachment(middle, -margin);
        fdlHideMenuBar.top = new FormAttachment((Control)this.wHideViewport, 2 * margin);
        wlHideMenuBar.setLayoutData((Object)fdlHideMenuBar);
        this.wHideMenuBar = new Button(wLookComp, 32);
        PropsUi.setLook((Widget)this.wHideMenuBar);
        this.wHideMenuBar.setSelection(props.isHidingMenuBar());
        FormData fdHideMenuBar = new FormData();
        fdHideMenuBar.left = new FormAttachment(middle, 0);
        fdHideMenuBar.right = new FormAttachment(100, -margin);
        fdHideMenuBar.top = new FormAttachment((Control)wlHideMenuBar, 0, 0x1000000);
        this.wHideMenuBar.setLayoutData((Object)fdHideMenuBar);
        this.wHideMenuBar.addListener(13, e -> this.saveValues());
        Label wlShowTableViewToolbar = new Label(wLookComp, 131072);
        wlShowTableViewToolbar.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowTableViewToolbar.Label", (String[])new String[0]));
        wlShowTableViewToolbar.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowTableViewToolbar.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShowTableViewToolbar);
        FormData fdlShowTableViewToolbar = new FormData();
        fdlShowTableViewToolbar.left = new FormAttachment(0, 0);
        fdlShowTableViewToolbar.right = new FormAttachment(middle, -margin);
        fdlShowTableViewToolbar.top = new FormAttachment((Control)this.wHideMenuBar, 2 * margin);
        wlShowTableViewToolbar.setLayoutData((Object)fdlShowTableViewToolbar);
        this.wShowTableViewToolbar = new Button(wLookComp, 32);
        PropsUi.setLook((Widget)this.wShowTableViewToolbar);
        this.wShowTableViewToolbar.setSelection(props.isShowTableViewToolbar());
        FormData fdShowTableViewToolbar = new FormData();
        fdShowTableViewToolbar.left = new FormAttachment(middle, 0);
        fdShowTableViewToolbar.right = new FormAttachment(100, -margin);
        fdShowTableViewToolbar.top = new FormAttachment((Control)wlShowTableViewToolbar, 0, 0x1000000);
        this.wShowTableViewToolbar.setLayoutData((Object)fdShowTableViewToolbar);
        this.wShowTableViewToolbar.addListener(13, e -> this.saveValues());
        Label wlDarkMode = new Label(wLookComp, 131072);
        wlDarkMode.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DarkMode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDarkMode);
        FormData fdlDarkMode = new FormData();
        fdlDarkMode.left = new FormAttachment(0, 0);
        fdlDarkMode.top = new FormAttachment((Control)this.wShowTableViewToolbar, 2 * margin);
        fdlDarkMode.right = new FormAttachment(middle, -margin);
        wlDarkMode.setLayoutData((Object)fdlDarkMode);
        this.wDarkMode = new Button(wLookComp, 32);
        this.wDarkMode.setSelection(props.isDarkMode());
        PropsUi.setLook((Widget)this.wDarkMode);
        FormData fdDarkMode = new FormData();
        fdDarkMode.left = new FormAttachment(middle, 0);
        fdDarkMode.top = new FormAttachment((Control)wlDarkMode, 0, 0x1000000);
        fdDarkMode.right = new FormAttachment(100, 0);
        this.wDarkMode.setLayoutData((Object)fdDarkMode);
        wlDarkMode.setEnabled(Const.isWindows());
        this.wDarkMode.setEnabled(Const.isWindows());
        this.wDarkMode.addListener(13, e -> this.saveValues());
        Label wlDefaultLocale = new Label(wLookComp, 131072);
        wlDefaultLocale.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DefaultLocale.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDefaultLocale);
        FormData fdlDefaultLocale = new FormData();
        fdlDefaultLocale.left = new FormAttachment(0, 0);
        fdlDefaultLocale.right = new FormAttachment(middle, -margin);
        fdlDefaultLocale.top = new FormAttachment((Control)wlDarkMode, 2 * margin);
        wlDefaultLocale.setLayoutData((Object)fdlDefaultLocale);
        this.wDefaultLocale = new Combo(wLookComp, 18444);
        this.wDefaultLocale.setItems(GlobalMessages.localeDescr);
        PropsUi.setLook((Widget)this.wDefaultLocale);
        FormData fdDefaultLocale = new FormData();
        fdDefaultLocale.left = new FormAttachment(middle, 0);
        fdDefaultLocale.right = new FormAttachment(100, -margin);
        fdDefaultLocale.top = new FormAttachment((Control)wlDefaultLocale, 0, 0x1000000);
        this.wDefaultLocale.setLayoutData((Object)fdDefaultLocale);
        this.wDefaultLocale.addListener(24, e -> this.saveValues());
        int idxDefault = Const.indexOfString((String)LanguageChoice.getInstance().getDefaultLocale().toString(), (String[])GlobalMessages.localeCodes);
        if (idxDefault >= 0) {
            this.wDefaultLocale.select(idxDefault);
        }
        FormData fdLookComp = new FormData();
        fdLookComp.left = new FormAttachment(0, 0);
        fdLookComp.right = new FormAttachment(100, 0);
        fdLookComp.top = new FormAttachment(0, 0);
        fdLookComp.bottom = new FormAttachment(100, 100);
        wLookComp.setLayoutData((Object)fdLookComp);
        wLookComp.pack();
        Rectangle bounds = wLookComp.getBounds();
        sLookComp.setContent((Control)wLookComp);
        sLookComp.setExpandHorizontal(true);
        sLookComp.setExpandVertical(true);
        sLookComp.setMinWidth(bounds.width);
        sLookComp.setMinHeight(bounds.height);
        wLookTab.setControl((Control)sLookComp);
    }

    private void paintNoteFont(PaintEvent pe) {
        pe.gc.setFont(this.noteFont);
        Rectangle max = this.wNoteCanvas.getBounds();
        String name = this.noteFontData.getName() + " - " + this.noteFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void resetNoteFont(Event e, PropsUi props, Display display) {
        this.noteFontData = props.getDefaultFontData();
        this.noteFont.dispose();
        this.noteFont = new Font((Device)display, this.noteFontData);
        this.wNoteCanvas.redraw();
        this.saveValues();
    }

    private void editNoteFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.noteFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.noteFontData = newfd;
            this.noteFont.dispose();
            this.noteFont = new Font((Device)shell.getDisplay(), this.noteFontData);
            this.wNoteCanvas.redraw();
            this.saveValues();
        }
    }

    private void drawGraphFont(PaintEvent pe) {
        pe.gc.setFont(this.graphFont);
        Rectangle max = this.wGraphCanvas.getBounds();
        String name = this.graphFontData.getName() + " - " + this.graphFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void editGraphFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.graphFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.graphFontData = newfd;
            this.graphFont.dispose();
            this.graphFont = new Font((Device)shell.getDisplay(), this.graphFontData);
            this.wGraphCanvas.redraw();
            this.saveValues();
        }
    }

    private void resetGraphFont(Shell shell, PropsUi props) {
        this.graphFont.dispose();
        this.graphFontData = props.getDefaultFontData();
        this.graphFont = new Font((Device)shell.getDisplay(), this.graphFontData);
        this.wGraphCanvas.redraw();
        this.saveValues();
    }

    private void resetFixedFont(Shell shell) {
        this.fixedFontData = new FontData(PropsUi.getInstance().getFixedFont().getName(), PropsUi.getInstance().getFixedFont().getHeight(), PropsUi.getInstance().getFixedFont().getStyle());
        this.fixedFont.dispose();
        this.fixedFont = new Font((Device)shell.getDisplay(), this.fixedFontData);
        this.wFixedCanvas.redraw();
        this.saveValues();
    }

    private void editFixedFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.fixedFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.fixedFontData = newfd;
            this.fixedFont.dispose();
            this.fixedFont = new Font((Device)shell.getDisplay(), this.fixedFontData);
            this.wFixedCanvas.redraw();
            this.saveValues();
        }
    }

    private void paintFixedFont(PaintEvent pe) {
        pe.gc.setFont(this.fixedFont);
        Rectangle max = this.wFixedCanvas.getBounds();
        String name = this.fixedFontData.getName() + " - " + this.fixedFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void resetDefaultFont(Shell shell) {
        this.defaultFontData = new FontData(PropsUi.getInstance().getFixedFont().getName(), PropsUi.getInstance().getFixedFont().getHeight(), PropsUi.getInstance().getFixedFont().getStyle());
        this.defaultFont.dispose();
        this.defaultFont = new Font((Device)shell.getDisplay(), this.defaultFontData);
        this.wDefaultCanvas.redraw();
        this.saveValues();
    }

    private void paintDefaultFont(PaintEvent pe) {
        pe.gc.setFont(this.defaultFont);
        Rectangle max = this.wDefaultCanvas.getBounds();
        String name = this.defaultFontData.getName() + " - " + this.defaultFontData.getHeight();
        Point size = pe.gc.textExtent(name);
        pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
    }

    private void editDefaultFont(Shell shell) {
        FontDialog fd = new FontDialog(shell);
        fd.setFontList(new FontData[]{this.defaultFontData});
        FontData newfd = fd.open();
        if (newfd != null) {
            this.defaultFontData = newfd;
            this.defaultFont.dispose();
            this.defaultFont = new Font((Device)shell.getDisplay(), this.defaultFontData);
            this.wDefaultCanvas.redraw();
            this.saveValues();
        }
    }

    private FormData layoutResetOptionButton(Button button) {
        FormData fd = new FormData();
        Image editButton = GuiResource.getInstance().getImageResetOption();
        if (editButton != null) {
            button.setImage(editButton);
            button.setBackground(GuiResource.getInstance().getColorWhite());
            fd.width = editButton.getBounds().width + 20;
            fd.height = editButton.getBounds().height;
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset", (String[])new String[0]));
        }
        button.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset.Tooltip", (String[])new String[0]));
        return fd;
    }

    private FormData layoutEditOptionButton(Button button) {
        FormData fd = new FormData();
        Image editButton = GuiResource.getInstance().getImageEdit();
        if (editButton != null) {
            button.setImage(editButton);
            button.setBackground(GuiResource.getInstance().getColorWhite());
            fd.width = editButton.getBounds().width + 20;
            fd.height = editButton.getBounds().height;
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Edit", (String[])new String[0]));
        }
        button.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Edit.Tooltip", (String[])new String[0]));
        return fd;
    }

    private void saveValues() {
        PropsUi props = PropsUi.getInstance();
        props.setDefaultFont(this.defaultFontData);
        props.setFixedFont(this.fixedFontData);
        props.setGraphFont(this.graphFontData);
        props.setNoteFont(this.noteFontData);
        props.setIconSize(Const.toInt((String)this.wIconSize.getText(), (int)props.getIconSize()));
        props.setLineWidth(Const.toInt((String)this.wLineWidth.getText(), (int)props.getLineWidth()));
        props.setMiddlePct(Const.toInt((String)this.wMiddlePct.getText(), (int)props.getMiddlePct()));
        props.setCanvasGridSize(Const.toInt((String)this.wGridSize.getText(), (int)1));
        props.setGlobalZoomFactor(Const.toDouble((String)this.wGlobalZoom.getText().replace("%", ""), (double)100.0) / 100.0);
        props.setShowCanvasGridEnabled(this.wShowCanvasGrid.getSelection());
        props.setHideViewportEnabled(this.wHideViewport.getSelection());
        props.setDarkMode(this.wDarkMode.getSelection());
        props.setHidingMenuBar(this.wHideMenuBar.getSelection());
        props.setShowTableViewToolbar(this.wShowTableViewToolbar.getSelection());
        int defaultLocaleIndex = this.wDefaultLocale.getSelectionIndex();
        if (defaultLocaleIndex < 0 || defaultLocaleIndex >= GlobalMessages.localeCodes.length) {
            defaultLocaleIndex = 0;
        }
        String defaultLocale = GlobalMessages.localeCodes[defaultLocaleIndex];
        LanguageChoice.getInstance().setDefaultLocale(EnvUtil.createLocale((String)defaultLocale));
        try {
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving configuration to file", e);
        }
    }
}

