/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class DelegateCoder<@UnknownKeyFor T, @UnknownKeyFor IntermediateT>
extends CustomCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<IntermediateT> coder;
    private final @UnknownKeyFor @NonNull @Initialized CodingFunction<T, IntermediateT> toFn;
    private final @UnknownKeyFor @NonNull @Initialized CodingFunction<IntermediateT, T> fromFn;
    private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> typeDescriptor;

    public static <T, IntermediateT> @UnknownKeyFor @NonNull @Initialized DelegateCoder<T, IntermediateT> of(@UnknownKeyFor @NonNull @Initialized Coder<IntermediateT> coder, @UnknownKeyFor @NonNull @Initialized CodingFunction<T, IntermediateT> toFn, @UnknownKeyFor @NonNull @Initialized CodingFunction<IntermediateT, T> fromFn) {
        return DelegateCoder.of(coder, toFn, fromFn, null);
    }

    public static <T, IntermediateT> @UnknownKeyFor @NonNull @Initialized DelegateCoder<T, IntermediateT> of(@UnknownKeyFor @NonNull @Initialized Coder<IntermediateT> coder, @UnknownKeyFor @NonNull @Initialized CodingFunction<T, IntermediateT> toFn, @UnknownKeyFor @NonNull @Initialized CodingFunction<IntermediateT, T> fromFn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> typeDescriptor) {
        return new DelegateCoder<T, IntermediateT>(coder, toFn, fromFn, typeDescriptor);
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.coder.encode(this.applyAndWrapExceptions(this.toFn, value), outStream, context);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.applyAndWrapExceptions(this.fromFn, this.coder.decode(inStream, context));
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<IntermediateT> getCoder() {
        return this.coder;
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.coder.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(T value) {
        try {
            IntermediateT intermediate = this.toFn.apply(value);
            return this.coder.structuralValue(intermediate);
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegateCoder that = (DelegateCoder)o;
        return Objects.equal(this.coder, that.coder) && Objects.equal(this.toFn, that.toFn) && Objects.equal(this.fromFn, that.fromFn);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.coder, this.toFn, this.fromFn});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("coder", this.coder).add("toFn", this.toFn).add("fromFn", this.fromFn).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        if (this.typeDescriptor == null) {
            return super.getEncodedTypeDescriptor();
        }
        return this.typeDescriptor;
    }

    private <InputT, OutputT> OutputT applyAndWrapExceptions(@UnknownKeyFor @NonNull @Initialized CodingFunction<InputT, OutputT> fn, InputT input) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return fn.apply(input);
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new CoderException(exc);
        }
    }

    protected DelegateCoder(@UnknownKeyFor @NonNull @Initialized Coder<IntermediateT> coder, @UnknownKeyFor @NonNull @Initialized CodingFunction<T, IntermediateT> toFn, @UnknownKeyFor @NonNull @Initialized CodingFunction<IntermediateT, T> fromFn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> typeDescriptor) {
        this.coder = coder;
        this.fromFn = fromFn;
        this.toFn = toFn;
        this.typeDescriptor = typeDescriptor;
    }

    public static interface CodingFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends Serializable {
        public OutputT apply(InputT var1) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

