/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class CompressedSource<@UnknownKeyFor T>
extends FileBasedSource<T> {
    private final @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> sourceDelegate;
    private final @UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory channelFactory;

    public static <T> @UnknownKeyFor @NonNull @Initialized CompressedSource<T> from(@UnknownKeyFor @NonNull @Initialized FileBasedSource<T> sourceDelegate) {
        return new CompressedSource<T>(sourceDelegate, CompressionMode.AUTO);
    }

    public @UnknownKeyFor @NonNull @Initialized CompressedSource<T> withDecompression(@UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory channelFactory) {
        return new CompressedSource<T>(this.sourceDelegate, channelFactory);
    }

    public @UnknownKeyFor @NonNull @Initialized CompressedSource<T> withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
        return this.withDecompression(CompressionMode.fromCanonical(compression));
    }

    private CompressedSource(@UnknownKeyFor @NonNull @Initialized FileBasedSource<T> sourceDelegate, @UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory channelFactory) {
        super(sourceDelegate.getFileOrPatternSpecProvider(), sourceDelegate.getEmptyMatchTreatment(), Long.MAX_VALUE);
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
    }

    private CompressedSource(@UnknownKeyFor @NonNull @Initialized FileBasedSource<T> sourceDelegate, @UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory channelFactory,  @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long minBundleSize, @UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset) {
        super(metadata, minBundleSize, startOffset, endOffset);
        boolean splittable;
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
        try {
            splittable = this.isSplittable();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine if the source is splittable", e);
        }
        Preconditions.checkArgument((splittable || startOffset == 0L ? 1 : 0) != 0, (String)"CompressedSources must start reading at offset 0. Requested offset: %s", (long)startOffset);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull(this.sourceDelegate);
        this.sourceDelegate.validate();
        Preconditions.checkNotNull((Object)this.channelFactory);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> createForSubrangeOfFile( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return new CompressedSource<T>(this.sourceDelegate.createForSubrangeOfFile(metadata, start, end), this.channelFactory, metadata, this.sourceDelegate.getMinBundleSize(), start, end);
    }

    @Override
    protected final @UnknownKeyFor @NonNull @Initialized boolean isSplittable() {
        try {
            if (!this.sourceDelegate.isSplittable()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.channelFactory == CompressionMode.UNCOMPRESSED) {
            return true;
        }
        if (this.channelFactory == CompressionMode.AUTO) {
            return !Compression.AUTO.isCompressed(this.getFileOrPatternSpec());
        }
        return false;
    }

    @Override
    protected final @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<T> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        if (this.isSplittable()) {
            return this.sourceDelegate.createSingleFileReader(options);
        }
        return new CompressedReader<T>(this, this.sourceDelegate.createSingleFileReader(options));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.include("source", this.sourceDelegate).add(DisplayData.item("source", this.sourceDelegate.getClass()).withLabel("Read Source"));
        if (this.channelFactory instanceof Enum) {
            builder.add(DisplayData.item("compressionMode", ((Enum)((Object)this.channelFactory)).name()).withLabel("Compression Mode"));
        } else {
            builder.add(DisplayData.item("compressionMode", this.channelFactory.getClass()).withLabel("Compression Mode"));
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.sourceDelegate.getOutputCoder();
    }

    public final @UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public static class CompressedReader<@UnknownKeyFor T>
    extends FileBasedSource.FileBasedReader<T> {
        private final @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<T> readerDelegate;
        private final @UnknownKeyFor @NonNull @Initialized Object progressLock = new Object();
        @GuardedBy(value="progressLock")
        private @UnknownKeyFor @NonNull @Initialized long numRecordsRead;
        @GuardedBy(value="progressLock")
        private @Nullable @UnknownKeyFor @Initialized CountingChannel channel;
        private @UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory channelFactory;

        public CompressedReader(@UnknownKeyFor @NonNull @Initialized CompressedSource<T> source, @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<T> readerDelegate) {
            super(source);
            this.channelFactory = source.getChannelFactory();
            this.readerDelegate = readerDelegate;
        }

        @Override
        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.readerDelegate.getCurrent();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean allowsDynamicSplitting() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final @UnknownKeyFor @NonNull @Initialized long getSplitPointsConsumed() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.isDone() && this.numRecordsRead > 0L ? 1L : 0L;
            }
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
            return this.isDone() ? 0L : 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final @UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.numRecordsRead == 1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Object object = this.progressLock;
            synchronized (object) {
                this.channel = new CountingChannel(channel, this.getCurrentSource().getStartOffset());
                channel = this.channel;
            }
            if (this.channelFactory == CompressionMode.AUTO) {
                this.readerDelegate.startReading(Compression.detect(((FileBasedSource)this.getCurrentSource()).getFileOrPatternSpec()).readDecompressed(channel));
            } else {
                this.readerDelegate.startReading(this.channelFactory.createDecompressingChannel(channel));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (!this.readerDelegate.readNextRecord()) {
                return false;
            }
            Object object = this.progressLock;
            synchronized (object) {
                ++this.numRecordsRead;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            Object object = this.progressLock;
            synchronized (object) {
                if (this.numRecordsRead <= 1L) {
                    return 0L;
                }
                return this.channel.getCount();
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.readerDelegate.getCurrentTimestamp();
        }

        private static class CountingChannel
        implements ReadableByteChannel {
            @UnknownKeyFor @NonNull @Initialized long count;
            private final @UnknownKeyFor @NonNull @Initialized ReadableByteChannel inner;

            public CountingChannel(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel inner, @UnknownKeyFor @NonNull @Initialized long count) {
                this.inner = inner;
                this.count = count;
            }

            public @UnknownKeyFor @NonNull @Initialized long getCount() {
                return this.count;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ByteBuffer dst) throws @UnknownKeyFor @NonNull @Initialized IOException {
                int bytes = this.inner.read(dst);
                if (bytes > 0) {
                    this.count += (long)bytes;
                }
                return bytes;
            }

            @Override
            @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
            public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
                return this.inner.isOpen();
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.inner.close();
            }
        }
    }

    @Deprecated
    public static enum CompressionMode implements DecompressingChannelFactory
    {
        UNCOMPRESSED(Compression.UNCOMPRESSED),
        AUTO(Compression.AUTO),
        GZIP(Compression.GZIP),
        BZIP2(Compression.BZIP2),
        ZIP(Compression.ZIP),
        ZSTD(Compression.ZSTD),
        LZO(Compression.LZO),
        LZOP(Compression.LZOP),
        DEFLATE(Compression.DEFLATE),
        SNAPPY(Compression.SNAPPY);

        private final @UnknownKeyFor @NonNull @Initialized Compression canonical;

        private CompressionMode(Compression canonical) {
            this.canonical = canonical;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String fileName) {
            return this.canonical.matches(fileName);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel createDecompressingChannel(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.canonical.readDecompressed(channel);
        }

        public static @UnknownKeyFor @NonNull @Initialized boolean isCompressed(@UnknownKeyFor @NonNull @Initialized String filename) {
            return Compression.AUTO.isCompressed(filename);
        }

        static @UnknownKeyFor @NonNull @Initialized DecompressingChannelFactory fromCanonical(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            switch (compression) {
                case AUTO: {
                    return AUTO;
                }
                case UNCOMPRESSED: {
                    return UNCOMPRESSED;
                }
                case GZIP: {
                    return GZIP;
                }
                case BZIP2: {
                    return BZIP2;
                }
                case ZIP: {
                    return ZIP;
                }
                case ZSTD: {
                    return ZSTD;
                }
                case LZO: {
                    return LZO;
                }
                case LZOP: {
                    return LZOP;
                }
                case DEFLATE: {
                    return DEFLATE;
                }
                case SNAPPY: {
                    return SNAPPY;
                }
            }
            throw new IllegalArgumentException("Unsupported compression type: " + (Object)((Object)compression));
        }
    }

    public static interface DecompressingChannelFactory
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel createDecompressingChannel(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }
}

