/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AutoValue_TFRecordIO_Read;
import org.apache.beam.sdk.io.AutoValue_TFRecordIO_ReadFiles;
import org.apache.beam.sdk.io.AutoValue_TFRecordIO_Write;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TFRecordIO {
    public static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> DEFAULT_BYTE_ARRAY_CODER = ByteArrayCoder.of();

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_TFRecordIO_Read.Builder().setValidate(true).setCompression(Compression.AUTO).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadFiles readFiles() {
        return new AutoValue_TFRecordIO_ReadFiles.Builder().build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_TFRecordIO_Write.Builder().setShardTemplate(null).setFilenameSuffix(null).setNumShards(0).setCompression(Compression.UNCOMPRESSED).setNoSpilling(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Sink sink() {
        return new Sink();
    }

    private TFRecordIO() {
    }

    @VisibleForTesting
    static class TFRecordCodec {
        private static final @UnknownKeyFor @NonNull @Initialized int HEADER_LEN = 12;
        private static final @UnknownKeyFor @NonNull @Initialized int FOOTER_LEN = 4;
        private static @UnknownKeyFor @NonNull @Initialized HashFunction crc32c = Hashing.crc32c();
        private @UnknownKeyFor @NonNull @Initialized ByteBuffer header = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        private @UnknownKeyFor @NonNull @Initialized ByteBuffer footer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);

        TFRecordCodec() {
        }

        private @UnknownKeyFor @NonNull @Initialized int mask(@UnknownKeyFor @NonNull @Initialized int crc) {
            return (crc >>> 15 | crc << 17) + -1568478504;
        }

        private @UnknownKeyFor @NonNull @Initialized int hashLong(@UnknownKeyFor @NonNull @Initialized long x) {
            return this.mask(crc32c.hashLong(x).asInt());
        }

        private @UnknownKeyFor @NonNull @Initialized int hashBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] x) {
            return this.mask(crc32c.hashBytes(x).asInt());
        }

        public @UnknownKeyFor @NonNull @Initialized int recordLength(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data) {
            return 12 + data.length + 4;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] read(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel inChannel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.header.clear();
            int headerBytes = TFRecordCodec.read(inChannel, this.header);
            if (headerBytes == 0) {
                return null;
            }
            Preconditions.checkState((headerBytes == 12 ? 1 : 0) != 0, (Object)"Not a valid TFRecord. Fewer than 12 bytes.");
            this.header.rewind();
            long length64 = this.header.getLong();
            long lengthHash = this.hashLong(length64);
            int maskedCrc32OfLength = this.header.getInt();
            if (lengthHash != (long)maskedCrc32OfLength) {
                throw new IOException(String.format("Mismatch of length mask when reading a record. Expected %d but received %d.", maskedCrc32OfLength, lengthHash));
            }
            int length = (int)length64;
            if ((long)length != length64) {
                throw new IOException(String.format("length overflow %d", length64));
            }
            ByteBuffer data = ByteBuffer.allocate(length);
            TFRecordCodec.readFully(inChannel, data);
            this.footer.clear();
            TFRecordCodec.readFully(inChannel, this.footer);
            this.footer.rewind();
            int maskedCrc32OfData = this.footer.getInt();
            int dataHash = this.hashBytes(data.array());
            if (dataHash != maskedCrc32OfData) {
                throw new IOException(String.format("Mismatch of data mask when reading a record. Expected %d but received %d.", maskedCrc32OfData, dataHash));
            }
            return data.array();
        }

        public void write(@UnknownKeyFor @NonNull @Initialized WritableByteChannel outChannel, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int maskedCrc32OfLength = this.hashLong(data.length);
            int maskedCrc32OfData = this.hashBytes(data);
            this.header.clear();
            this.header.putLong(data.length).putInt(maskedCrc32OfLength);
            this.header.rewind();
            TFRecordCodec.writeFully(outChannel, this.header);
            TFRecordCodec.writeFully(outChannel, ByteBuffer.wrap(data));
            this.footer.clear();
            this.footer.putInt(maskedCrc32OfData);
            this.footer.rewind();
            TFRecordCodec.writeFully(outChannel, this.footer);
        }

        @VisibleForTesting
        static void readFully(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel in, @UnknownKeyFor @NonNull @Initialized ByteBuffer bb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int actual;
            int expected = bb.remaining();
            if (expected != (actual = TFRecordCodec.read(in, bb))) {
                throw new IOException(String.format("expected %d, but got %d", expected, actual));
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel in, @UnknownKeyFor @NonNull @Initialized ByteBuffer bb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int expected = bb.remaining();
            while (bb.hasRemaining() && in.read(bb) >= 0) {
            }
            return expected - bb.remaining();
        }

        @VisibleForTesting
        static void writeFully(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel, @UnknownKeyFor @NonNull @Initialized ByteBuffer buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
        }
    }

    @VisibleForTesting
    static class TFRecordSink
    extends FileBasedSink<byte[], Void, byte[]> {
        @VisibleForTesting
        TFRecordSink(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> outputPrefix, @Nullable @UnknownKeyFor @Initialized String shardTemplate, @Nullable @UnknownKeyFor @Initialized String suffix, @UnknownKeyFor @NonNull @Initialized Compression compression) {
            super(outputPrefix, DynamicFileDestinations.constant(DefaultFilenamePolicy.fromStandardParameters(outputPrefix, shardTemplate, suffix, false)), compression);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> createWriteOperation() {
            return new TFRecordWriteOperation(this);
        }

        private static class TFRecordWriter
        extends FileBasedSink.Writer<Void, byte[]> {
            private @Nullable @UnknownKeyFor @Initialized WritableByteChannel outChannel;
            private @Nullable @UnknownKeyFor @Initialized TFRecordCodec codec;

            private TFRecordWriter(@UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> writeOperation) {
                super(writeOperation, "application/octet-stream");
            }

            @Override
            protected void prepareWrite(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.outChannel = channel;
                this.codec = new TFRecordCodec();
            }

            @Override
            public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.codec.write(this.outChannel, value);
            }
        }

        private static class TFRecordWriteOperation
        extends FileBasedSink.WriteOperation<Void, byte[]> {
            private TFRecordWriteOperation(@UnknownKeyFor @NonNull @Initialized TFRecordSink sink) {
                super(sink);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> createWriter() throws @UnknownKeyFor @NonNull @Initialized Exception {
                return new TFRecordWriter((FileBasedSink.WriteOperation)this);
            }
        }
    }

    @VisibleForTesting
    static class TFRecordSource
    extends FileBasedSource<byte[]> {
        @VisibleForTesting
        TFRecordSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileSpec) {
            super(fileSpec, Long.MAX_VALUE);
        }

        private TFRecordSource(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
            super(metadata, Long.MAX_VALUE, start, end);
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> createForSubrangeOfFile(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
            Preconditions.checkArgument((start == 0L ? 1 : 0) != 0, (Object)"TFRecordSource is not splittable");
            return new TFRecordSource(metadata, start, end);
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new TFRecordReader(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getOutputCoder() {
            return DEFAULT_BYTE_ARRAY_CODER;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized boolean isSplittable() {
            return false;
        }

        @VisibleForTesting
        static class TFRecordReader
        extends FileBasedSource.FileBasedReader<byte[]> {
            private @UnknownKeyFor @NonNull @Initialized long startOfRecord;
            private volatile @UnknownKeyFor @NonNull @Initialized long startOfNextRecord;
            private volatile @UnknownKeyFor @NonNull @Initialized boolean elementIsPresent;
            private @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] currentValue;
            private @Nullable @UnknownKeyFor @Initialized ReadableByteChannel inChannel;
            private @Nullable @UnknownKeyFor @Initialized TFRecordCodec codec;

            private TFRecordReader(@UnknownKeyFor @NonNull @Initialized TFRecordSource source) {
                super(source);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean allowsDynamicSplitting() {
                return false;
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (!this.elementIsPresent) {
                    throw new NoSuchElementException();
                }
                return this.startOfRecord;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (!this.elementIsPresent) {
                    throw new NoSuchElementException();
                }
                return this.currentValue;
            }

            @Override
            protected void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.inChannel = channel;
                this.codec = new TFRecordCodec();
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.startOfRecord = this.startOfNextRecord;
                this.currentValue = this.codec.read(this.inChannel);
                if (this.currentValue != null) {
                    this.elementIsPresent = true;
                    this.startOfNextRecord = this.startOfRecord + (long)this.codec.recordLength(this.currentValue);
                    return true;
                }
                this.elementIsPresent = false;
                return false;
            }
        }
    }

    @Deprecated
    public static enum CompressionType {
        AUTO(Compression.AUTO),
        NONE(Compression.UNCOMPRESSED),
        GZIP(Compression.GZIP),
        ZLIB(Compression.DEFLATE);

        private final @UnknownKeyFor @NonNull @Initialized Compression canonical;

        private CompressionType(Compression canonical) {
            this.canonical = canonical;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String filename) {
            return this.canonical.matches(filename);
        }
    }

    public static class Sink
    implements FileIO.Sink<byte[]> {
        private transient @Nullable @UnknownKeyFor @Initialized WritableByteChannel channel;
        private transient @Nullable @UnknownKeyFor @Initialized TFRecordCodec codec;

        @Override
        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.channel = channel;
            this.codec = new TFRecordCodec();
        }

        @Override
        public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.codec.write(this.channel, element);
        }

        @Override
        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<byte[]>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> getOutputPrefix();

        abstract @Nullable @UnknownKeyFor @Initialized String getFilenameSuffix();

        abstract @UnknownKeyFor @NonNull @Initialized int getNumShards();

        abstract @Nullable @UnknownKeyFor @Initialized String getShardTemplate();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getNoSpilling();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized String outputPrefix) {
            return this.to(FileBasedSink.convertToFileResourceIfPossible(outputPrefix));
        }

        public @UnknownKeyFor @NonNull @Initialized Write to(@UnknownKeyFor @NonNull @Initialized ResourceId outputResource) {
            return this.toResource(ValueProvider.StaticValueProvider.of(outputResource));
        }

        public @UnknownKeyFor @NonNull @Initialized Write toResource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> outputResource) {
            return this.toBuilder().setOutputPrefix(outputResource).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSuffix(@UnknownKeyFor @NonNull @Initialized String suffix) {
            return this.toBuilder().setFilenameSuffix(suffix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
            Preconditions.checkArgument((numShards >= 0 ? 1 : 0) != 0, (String)"Number of shards %s must be >= 0", (int)numShards);
            return this.toBuilder().setNumShards(numShards).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withShardNameTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return this.toBuilder().setShardTemplate(shardTemplate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withoutSharding() {
            return this.withNumShards(1).withShardNameTemplate("");
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write withCompressionType(@UnknownKeyFor @NonNull @Initialized CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> input) {
            Preconditions.checkState((this.getOutputPrefix() != null ? 1 : 0) != 0, (Object)"need to set the output prefix of a TFRecordIO.Write transform");
            WriteFiles<byte[], Void, byte[]> write = WriteFiles.to(new TFRecordSink(this.getOutputPrefix(), this.getShardTemplate(), this.getFilenameSuffix(), this.getCompression()));
            if (this.getNumShards() > 0) {
                write = write.withNumShards(this.getNumShards());
            }
            if (this.getNoSpilling()) {
                write = write.withNoSpilling();
            }
            input.apply("Write", write);
            return PDone.in(input.getPipeline());
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("filePrefix", this.getOutputPrefix()).withLabel("Output File Prefix")).addIfNotNull(DisplayData.item("fileSuffix", this.getFilenameSuffix()).withLabel("Output File Suffix")).addIfNotNull(DisplayData.item("shardNameTemplate", this.getShardTemplate()).withLabel("Output Shard Name Template")).addIfNotDefault(DisplayData.item("numShards", this.getNumShards()).withLabel("Maximum Output Shards"), 0).add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputPrefix(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setShardTemplate(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilenameSuffix(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNumShards(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNoSpilling(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<byte[]>> {
        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> expand(@UnknownKeyFor @NonNull @Initialized PCollection< @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            return (PCollection)input.apply("Read all via FileBasedSource", new ReadAllViaFileBasedSource<byte[]>(Long.MAX_VALUE, new CreateSourceFn(), DEFAULT_BYTE_ARRAY_CODER));
        }

        private static class CreateSourceFn
        implements SerializableFunction<String, FileBasedSource<byte[]>> {
            private CreateSourceFn() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> apply(@UnknownKeyFor @NonNull @Initialized String input) {
                return new TFRecordSource(ValueProvider.StaticValueProvider.of(input));
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<byte[]>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            return this.from(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Read withCompressionType(@UnknownKeyFor @NonNull @Initialized CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            if (this.getFilepattern() == null) {
                throw new IllegalStateException("Need to set the filepattern of a TFRecordIO.Read transform");
            }
            if (this.getValidate()) {
                Preconditions.checkState((boolean)this.getFilepattern().isAccessible(), (Object)"Cannot validate with a RVP.");
                try {
                    MatchResult matches = FileSystems.match(this.getFilepattern().get());
                    Preconditions.checkState((!matches.metadata().isEmpty() ? 1 : 0) != 0, (String)"Unable to find any files matching %s", (Object)this.getFilepattern().get());
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Failed to validate %s", this.getFilepattern().get()), e);
                }
            }
            return (PCollection)input.apply("Read", org.apache.beam.sdk.io.Read.from(this.getSource()));
        }

        protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getSource() {
            return CompressedSource.from(new TFRecordSource(this.getFilepattern())).withCompression(this.getCompression());
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type")).addIfNotDefault(DisplayData.item("validation", this.getValidate()).withLabel("Validation Enabled"), true).addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("File Pattern"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

