/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface ExperimentalOptions
extends PipelineOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String STATE_CACHE_SIZE = "state_cache_size";
    public static final @UnknownKeyFor @NonNull @Initialized String STATE_SAMPLING_PERIOD_MILLIS = "state_sampling_period_millis";

    @Description(value="Apache Beam provides a number of experimental features that can be enabled with this flag. If executing against a managed service, please contact the service owners before enabling any experiments.")
    public @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getExperiments();

    public void setExperiments(@Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    public static @UnknownKeyFor @NonNull @Initialized boolean hasExperiment(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized String experiment) {
        if (options == null) {
            return false;
        }
        List<String> experiments = options.as(ExperimentalOptions.class).getExperiments();
        return experiments != null && experiments.contains(experiment);
    }

    public static void addExperiment(@UnknownKeyFor @NonNull @Initialized ExperimentalOptions options, @UnknownKeyFor @NonNull @Initialized String experiment) {
        ArrayList experiments = options.getExperiments();
        if (experiments == null) {
            experiments = Lists.newArrayList();
        }
        if (!experiments.contains(experiment)) {
            experiments.add(experiment);
        }
        options.setExperiments(experiments);
    }

    public static @UnknownKeyFor @NonNull @Initialized String getExperimentValue(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized String experiment) {
        if (options == null) {
            return null;
        }
        List<String> experiments = options.as(ExperimentalOptions.class).getExperiments();
        if (experiments == null) {
            return null;
        }
        for (String experimentEntry : experiments) {
            String[] tokens = experimentEntry.split(experiment + "=", -1);
            if (tokens.length <= 1) continue;
            return tokens[1];
        }
        return null;
    }
}

