/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

public class GlobalWindow
extends BoundedWindow {
    public static final @UnknownKeyFor @NonNull @Initialized GlobalWindow INSTANCE = new GlobalWindow();
    private static final @UnknownKeyFor @NonNull @Initialized Instant END_OF_GLOBAL_WINDOW = GlobalWindow.extractMaxTimestampFromProto();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp() {
        return END_OF_GLOBAL_WINDOW;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        return other instanceof GlobalWindow;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return GlobalWindow.class.hashCode();
    }

    private GlobalWindow() {
    }

    private static @UnknownKeyFor @NonNull @Initialized Instant extractMaxTimestampFromProto() {
        return new Instant(Long.parseLong((String)RunnerApi.BeamConstants.Constants.GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS.getValueDescriptor().getOptions().getExtension(RunnerApi.beamConstant)));
    }

    public static class Coder
    extends StructuredCoder<GlobalWindow> {
        public static final @UnknownKeyFor @NonNull @Initialized Coder INSTANCE = new Coder();

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized GlobalWindow window, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GlobalWindow decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) {
            return INSTANCE;
        }

        @Override
        public void verifyDeterministic() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }

        @Override
        public final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.emptyList();
        }

        private Coder() {
        }
    }
}

