/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class OrFinallyTrigger
extends Trigger {
    private static final @UnknownKeyFor @NonNull @Initialized int ACTUAL = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int UNTIL = 1;

    @VisibleForTesting
    OrFinallyTrigger(@UnknownKeyFor @NonNull @Initialized Trigger actual, @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger until) {
        super(Arrays.asList(actual, until));
    }

    public @UnknownKeyFor @NonNull @Initialized Trigger getMainTrigger() {
        return this.subTriggers().get(0);
    }

    public @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger getUntilTrigger() {
        return (Trigger.OnceTrigger)this.subTriggers().get(1);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Instant untilDeadline;
        Instant actualDeadline = ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
        return actualDeadline.isBefore((ReadableInstant)(untilDeadline = ((Trigger)this.subTriggers.get(1)).getWatermarkThatGuaranteesFiring(window))) ? actualDeadline : untilDeadline;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean mayFinish() {
        return ((Trigger)this.subTriggers.get(0)).mayFinish() || ((Trigger)this.subTriggers.get(1)).mayFinish();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
        return Repeatedly.forever(new OrFinallyTrigger(continuationTriggers.get(0), (Trigger.OnceTrigger)continuationTriggers.get(1)));
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("%s.orFinally(%s)", this.subTriggers.get(0), this.subTriggers.get(1));
    }
}

