/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.StringCompression;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StringIDVertexCache
implements VertexCache {
    private static final int INITIAL_CAPACITY = 1000;
    private static final int INITIAL_TX_CAPACITY = 100;
    private final Map<String, Object> map;
    private final Set<String> mapKeysInCurrentTx;
    private final StringCompression compression;

    public StringIDVertexCache(StringCompression compression) {
        if (compression == null) {
            throw new IllegalArgumentException("Compression expected.");
        }
        this.compression = compression;
        this.map = new HashMap<String, Object>(1000);
        this.mapKeysInCurrentTx = new HashSet<String>(100);
    }

    public StringIDVertexCache() {
        this(StringCompression.NO_COMPRESSION);
    }

    @Override
    public Object getEntry(Object externalId) {
        String id = this.compression.compress(externalId.toString());
        return this.map.get(id);
    }

    @Override
    public void set(Vertex vertex, Object externalId) {
        this.setId(vertex, externalId);
    }

    @Override
    public void setId(Object vertexId, Object externalId) {
        String id = this.compression.compress(externalId.toString());
        this.map.put(id, vertexId);
        this.mapKeysInCurrentTx.add(id);
    }

    @Override
    public boolean contains(Object externalId) {
        return this.map.containsKey(this.compression.compress(externalId.toString()));
    }

    @Override
    public void newTransaction() {
        for (String id : this.mapKeysInCurrentTx) {
            Object o = this.map.get(id);
            assert (null != o);
            if (!(o instanceof Vertex)) continue;
            Vertex v = (Vertex)o;
            this.map.put(id, v.getId());
        }
        this.mapKeysInCurrentTx.clear();
    }
}

