/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

interface UnboundedReadDeduplicator {
    public @UnknownKeyFor @NonNull @Initialized boolean shouldOutput(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1);

    public static class CachedIdDeduplicator
    implements UnboundedReadDeduplicator {
        private static final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder RECORD_ID_CODER = ByteArrayCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized long MAX_RETENTION_SINCE_ACCESS = Duration.standardMinutes((long)10L).getMillis();
        private final @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized AtomicBoolean> ids = CacheBuilder.newBuilder().expireAfterAccess(MAX_RETENTION_SINCE_ACCESS, TimeUnit.MILLISECONDS).maximumSize(100000L).build((CacheLoader)new TrueBooleanLoader());

        public static @UnknownKeyFor @NonNull @Initialized UnboundedReadDeduplicator create() {
            return new CachedIdDeduplicator();
        }

        private CachedIdDeduplicator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean shouldOutput(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] recordId) {
            return ((AtomicBoolean)this.ids.getUnchecked(StructuralKey.of(recordId, RECORD_ID_CODER))).getAndSet(false);
        }

        private static class TrueBooleanLoader
        extends CacheLoader<StructuralKey<byte[]>, AtomicBoolean> {
            private TrueBooleanLoader() {
            }

            public @UnknownKeyFor @NonNull @Initialized AtomicBoolean load(@UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> key) throws @UnknownKeyFor @NonNull @Initialized Exception {
                return new AtomicBoolean(true);
            }
        }
    }

    public static class NeverDeduplicator
    implements UnboundedReadDeduplicator {
        public static @UnknownKeyFor @NonNull @Initialized UnboundedReadDeduplicator create() {
            return new NeverDeduplicator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean shouldOutput(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] recordId) {
            return true;
        }
    }
}

