/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.bigtable.v2.FeatureFlags;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import com.google.cloud.bigtable.data.v2.stub.BigtableBulkReadRowsCallSettings;
import com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsBatchingDescriptor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

public class EnhancedBigtableStubSettings
extends StubSettings<EnhancedBigtableStubSettings> {
    private static final Logger logger = Logger.getLogger(EnhancedBigtableStubSettings.class.getName());
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    private static final String SERVER_DEFAULT_APP_PROFILE_ID = "";
    private static final Set<StatusCode.Code> IDEMPOTENT_RETRY_CODES = ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE);
    private static final RetrySettings IDEMPOTENT_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)20L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)20L)).setTotalTimeout(Duration.ofMinutes((long)10L)).build();
    private static final Set<StatusCode.Code> READ_ROWS_RETRY_CODES = ImmutableSet.builder().addAll(IDEMPOTENT_RETRY_CODES).add((Object)StatusCode.Code.ABORTED).build();
    private static Duration PRIME_REQUEST_TIMEOUT = Duration.ofSeconds((long)30L);
    private static final RetrySettings READ_ROWS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setMaxAttempts(10).setJittered(true).setInitialRpcTimeout(Duration.ofMinutes((long)5L)).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(Duration.ofMinutes((long)5L)).setTotalTimeout(Duration.ofHours((long)12L)).build();
    private static final RetrySettings MUTATE_ROWS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setInitialRpcTimeout(Duration.ofMinutes((long)1L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMinutes((long)1L)).setTotalTimeout(Duration.ofMinutes((long)10L)).build();
    private static final Set<StatusCode.Code> GENERATE_INITIAL_CHANGE_STREAM_PARTITIONS_RETRY_CODES = ImmutableSet.builder().addAll(IDEMPOTENT_RETRY_CODES).add((Object)StatusCode.Code.ABORTED).build();
    private static final RetrySettings GENERATE_INITIAL_CHANGE_STREAM_PARTITIONS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setMaxAttempts(10).setJittered(true).setInitialRpcTimeout(Duration.ofMinutes((long)1L)).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(Duration.ofMinutes((long)10L)).setTotalTimeout(Duration.ofMinutes((long)60L)).build();
    private static final Set<StatusCode.Code> READ_CHANGE_STREAM_RETRY_CODES = ImmutableSet.builder().addAll(IDEMPOTENT_RETRY_CODES).add((Object)StatusCode.Code.ABORTED).build();
    private static final RetrySettings READ_CHANGE_STREAM_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setMaxAttempts(10).setJittered(true).setInitialRpcTimeout(Duration.ofMinutes((long)5L)).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(Duration.ofMinutes((long)5L)).setTotalTimeout(Duration.ofHours((long)12L)).build();
    private static final ImmutableList<String> JWT_ENABLED_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigtable.data").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.data").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final Map<String, String> DEFAULT_JWT_AUDIENCE_MAPPING = ImmutableMap.of((Object)"batch-bigtable.googleapis.com", (Object)"https://bigtable.googleapis.com/");
    private final String projectId;
    private final String instanceId;
    private final String appProfileId;
    private final boolean isRefreshingChannel;
    private ImmutableList<String> primedTableIds;
    private final Map<String, String> jwtAudienceMapping;
    private final ServerStreamingCallSettings<Query, Row> readRowsSettings;
    private final UnaryCallSettings<Query, Row> readRowSettings;
    private final UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings;
    private final UnaryCallSettings<RowMutation, Void> mutateRowSettings;
    private final BigtableBatchingCallSettings bulkMutateRowsSettings;
    private final BigtableBulkReadRowsCallSettings bulkReadRowsSettings;
    private final UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
    private final UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings;
    private final ServerStreamingCallSettings<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsSettings;
    private final ServerStreamingCallSettings<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamSettings;
    private final UnaryCallSettings<PingAndWarmRequest, Void> pingAndWarmSettings;
    private final FeatureFlags featureFlags;

    private EnhancedBigtableStubSettings(Builder builder) {
        super((StubSettings.Builder)builder);
        Preconditions.checkState((boolean)builder.readRowSettings.getRetryableCodes().equals(builder.readRowsSettings.getRetryableCodes()), (Object)"Single ReadRow retry codes must match ReadRows retry codes");
        Preconditions.checkState((boolean)builder.bulkReadRowsSettings.getRetryableCodes().equals(builder.readRowsSettings.getRetryableCodes()), (Object)"Bulk ReadRow retry codes must match ReadRows retry codes");
        this.projectId = builder.projectId;
        this.instanceId = builder.instanceId;
        this.appProfileId = builder.appProfileId;
        this.isRefreshingChannel = builder.isRefreshingChannel;
        this.primedTableIds = builder.primedTableIds;
        this.jwtAudienceMapping = builder.jwtAudienceMapping;
        this.readRowsSettings = builder.readRowsSettings.build();
        this.readRowSettings = builder.readRowSettings.build();
        this.sampleRowKeysSettings = builder.sampleRowKeysSettings.build();
        this.mutateRowSettings = builder.mutateRowSettings.build();
        this.bulkMutateRowsSettings = builder.bulkMutateRowsSettings.build();
        this.bulkReadRowsSettings = builder.bulkReadRowsSettings.build();
        this.checkAndMutateRowSettings = builder.checkAndMutateRowSettings.build();
        this.readModifyWriteRowSettings = builder.readModifyWriteRowSettings.build();
        this.generateInitialChangeStreamPartitionsSettings = builder.generateInitialChangeStreamPartitionsSettings.build();
        this.readChangeStreamSettings = builder.readChangeStreamSettings.build();
        this.pingAndWarmSettings = builder.pingAndWarmSettings.build();
        this.featureFlags = builder.featureFlags.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getAppProfileId() {
        return this.appProfileId;
    }

    @Deprecated
    public boolean isRefreshingChannel() {
        return this.isRefreshingChannel;
    }

    @Deprecated
    public List<String> getPrimedTableIds() {
        return this.primedTableIds;
    }

    @InternalApi(value="Used for internal testing")
    public Map<String, String> getJwtAudienceMapping() {
        return this.jwtAudienceMapping;
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return BigtableStubSettings.defaultGrpcTransportProviderBuilder().setPoolSize(EnhancedBigtableStubSettings.getDefaultChannelPoolSize()).setMaxInboundMessageSize(Integer.valueOf(0x10000000)).setKeepAliveTime(Duration.ofSeconds((long)30L)).setKeepAliveTimeout(Duration.ofSeconds((long)10L)).setAttemptDirectPath(true);
    }

    static int getDefaultChannelPoolSize() {
        return 2 * Runtime.getRuntime().availableProcessors();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnhancedBigtableStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return BigtableStubSettings.defaultCredentialsProviderBuilder().setJwtEnabledScopes(JWT_ENABLED_SCOPES);
    }

    public ServerStreamingCallSettings<Query, Row> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings() {
        return this.sampleRowKeysSettings;
    }

    public UnaryCallSettings<Query, Row> readRowSettings() {
        return this.readRowSettings;
    }

    public UnaryCallSettings<RowMutation, Void> mutateRowSettings() {
        return this.mutateRowSettings;
    }

    public BigtableBatchingCallSettings bulkMutateRowsSettings() {
        return this.bulkMutateRowsSettings;
    }

    public BigtableBulkReadRowsCallSettings bulkReadRowsSettings() {
        return this.bulkReadRowsSettings;
    }

    public UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
        return this.checkAndMutateRowSettings;
    }

    public UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
        return this.readModifyWriteRowSettings;
    }

    public ServerStreamingCallSettings<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsSettings() {
        return this.generateInitialChangeStreamPartitionsSettings;
    }

    public ServerStreamingCallSettings<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamSettings() {
        return this.readChangeStreamSettings;
    }

    UnaryCallSettings<PingAndWarmRequest, Void> pingAndWarmSettings() {
        return this.pingAndWarmSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("projectId", (Object)this.projectId).add("instanceId", (Object)this.instanceId).add("appProfileId", (Object)this.appProfileId).add("isRefreshingChannel", this.isRefreshingChannel).add("primedTableIds", this.primedTableIds).add("jwtAudienceMapping", this.jwtAudienceMapping).add("readRowsSettings", this.readRowsSettings).add("readRowSettings", this.readRowSettings).add("sampleRowKeysSettings", this.sampleRowKeysSettings).add("mutateRowSettings", this.mutateRowSettings).add("bulkMutateRowsSettings", (Object)this.bulkMutateRowsSettings).add("bulkReadRowsSettings", (Object)this.bulkReadRowsSettings).add("checkAndMutateRowSettings", this.checkAndMutateRowSettings).add("readModifyWriteRowSettings", this.readModifyWriteRowSettings).add("generateInitialChangeStreamPartitionsSettings", this.generateInitialChangeStreamPartitionsSettings).add("readChangeStreamSettings", this.readChangeStreamSettings).add("pingAndWarmSettings", this.pingAndWarmSettings).add("parent", (Object)super.toString()).toString();
    }

    public static class Builder
    extends StubSettings.Builder<EnhancedBigtableStubSettings, Builder> {
        private String projectId;
        private String instanceId;
        private String appProfileId;
        private boolean isRefreshingChannel;
        private ImmutableList<String> primedTableIds;
        private Map<String, String> jwtAudienceMapping;
        private final ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings;
        private final UnaryCallSettings.Builder<Query, Row> readRowSettings;
        private final UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings;
        private final UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings;
        private final BigtableBatchingCallSettings.Builder bulkMutateRowsSettings;
        private final BigtableBulkReadRowsCallSettings.Builder bulkReadRowsSettings;
        private final UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
        private final UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings;
        private final ServerStreamingCallSettings.Builder<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsSettings;
        private final ServerStreamingCallSettings.Builder<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamSettings;
        private final UnaryCallSettings.Builder<PingAndWarmRequest, Void> pingAndWarmSettings;
        private FeatureFlags.Builder featureFlags;

        private Builder() {
            this.appProfileId = EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID;
            this.isRefreshingChannel = true;
            this.primedTableIds = ImmutableList.of();
            this.jwtAudienceMapping = DEFAULT_JWT_AUDIENCE_MAPPING;
            this.setCredentialsProvider((CredentialsProvider)EnhancedBigtableStubSettings.defaultCredentialsProviderBuilder().build());
            BigtableStubSettings.Builder baseDefaults = BigtableStubSettings.newBuilder();
            this.setEndpoint(baseDefaults.getEndpoint());
            this.setTransportChannelProvider(EnhancedBigtableStubSettings.defaultTransportChannelProvider());
            this.setStreamWatchdogCheckInterval(baseDefaults.getStreamWatchdogCheckInterval());
            this.setStreamWatchdogProvider(baseDefaults.getStreamWatchdogProvider());
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.readRowsSettings.setRetryableCodes(READ_ROWS_RETRY_CODES).setRetrySettings(READ_ROWS_RETRY_SETTINGS).setIdleTimeout(Duration.ofMinutes((long)5L));
            this.readRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readRowSettings.setRetryableCodes(this.readRowsSettings.getRetryableCodes()).setRetrySettings(this.readRowsSettings().getRetrySettings().toBuilder().setTotalTimeout(IDEMPOTENT_RETRY_SETTINGS.getTotalTimeout()).build());
            this.sampleRowKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sampleRowKeysSettings.setRetryableCodes(IDEMPOTENT_RETRY_CODES).setRetrySettings(IDEMPOTENT_RETRY_SETTINGS);
            this.mutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.mutateRowSettings(), this.mutateRowSettings);
            long maxBulkMutateElementPerBatch = 100L;
            long maxBulkMutateOutstandingElementCount = Math.min(20000L, 10L * maxBulkMutateElementPerBatch * (long)EnhancedBigtableStubSettings.getDefaultChannelPoolSize());
            this.bulkMutateRowsSettings = BigtableBatchingCallSettings.newBuilder(new MutateRowsBatchingDescriptor()).setRetryableCodes(IDEMPOTENT_RETRY_CODES).setRetrySettings(MUTATE_ROWS_RETRY_SETTINGS).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(true)).setElementCountThreshold(Long.valueOf(maxBulkMutateElementPerBatch)).setRequestByteThreshold(Long.valueOf(0x1400000L)).setDelayThreshold(Duration.ofSeconds((long)1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L)).setMaxOutstandingElementCount(Long.valueOf(maxBulkMutateOutstandingElementCount)).build()).build());
            long maxBulkReadElementPerBatch = 100L;
            long maxBulkReadRequestSizePerBatch = 409600L;
            long maxBulkReadOutstandingElementCount = 10L * maxBulkReadElementPerBatch * (long)EnhancedBigtableStubSettings.getDefaultChannelPoolSize();
            this.bulkReadRowsSettings = BigtableBulkReadRowsCallSettings.newBuilder(new ReadRowsBatchingDescriptor()).setRetryableCodes(this.readRowsSettings.getRetryableCodes()).setRetrySettings(IDEMPOTENT_RETRY_SETTINGS).setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(maxBulkReadElementPerBatch)).setRequestByteThreshold(Long.valueOf(maxBulkReadRequestSizePerBatch)).setDelayThreshold(Duration.ofSeconds((long)1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingElementCount(Long.valueOf(maxBulkReadOutstandingElementCount)).build()).build());
            this.checkAndMutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.checkAndMutateRowSettings(), this.checkAndMutateRowSettings);
            this.readModifyWriteRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.readModifyWriteRowSettings(), this.readModifyWriteRowSettings);
            this.generateInitialChangeStreamPartitionsSettings = ServerStreamingCallSettings.newBuilder();
            this.generateInitialChangeStreamPartitionsSettings.setRetryableCodes(GENERATE_INITIAL_CHANGE_STREAM_PARTITIONS_RETRY_CODES).setRetrySettings(GENERATE_INITIAL_CHANGE_STREAM_PARTITIONS_RETRY_SETTINGS).setIdleTimeout(Duration.ofMinutes((long)5L));
            this.readChangeStreamSettings = ServerStreamingCallSettings.newBuilder();
            this.readChangeStreamSettings.setRetryableCodes(READ_CHANGE_STREAM_RETRY_CODES).setRetrySettings(READ_CHANGE_STREAM_RETRY_SETTINGS).setIdleTimeout(Duration.ofMinutes((long)5L));
            this.pingAndWarmSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pingAndWarmSettings.setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(1).setInitialRpcTimeout(PRIME_REQUEST_TIMEOUT).setMaxRpcTimeout(PRIME_REQUEST_TIMEOUT).setTotalTimeout(PRIME_REQUEST_TIMEOUT).build());
            this.featureFlags = FeatureFlags.newBuilder();
        }

        private Builder(EnhancedBigtableStubSettings settings) {
            super((StubSettings)settings);
            this.projectId = settings.projectId;
            this.instanceId = settings.instanceId;
            this.appProfileId = settings.appProfileId;
            this.isRefreshingChannel = settings.isRefreshingChannel;
            this.primedTableIds = settings.primedTableIds;
            this.jwtAudienceMapping = settings.jwtAudienceMapping;
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.readRowSettings = settings.readRowSettings.toBuilder();
            this.sampleRowKeysSettings = settings.sampleRowKeysSettings.toBuilder();
            this.mutateRowSettings = settings.mutateRowSettings.toBuilder();
            this.bulkMutateRowsSettings = settings.bulkMutateRowsSettings.toBuilder();
            this.bulkReadRowsSettings = settings.bulkReadRowsSettings.toBuilder();
            this.checkAndMutateRowSettings = settings.checkAndMutateRowSettings.toBuilder();
            this.readModifyWriteRowSettings = settings.readModifyWriteRowSettings.toBuilder();
            this.generateInitialChangeStreamPartitionsSettings = settings.generateInitialChangeStreamPartitionsSettings.toBuilder();
            this.readChangeStreamSettings = settings.readChangeStreamSettings.toBuilder();
            this.pingAndWarmSettings = settings.pingAndWarmSettings.toBuilder();
            this.featureFlags = settings.featureFlags.toBuilder();
        }

        private static void copyRetrySettings(UnaryCallSettings.Builder<?, ?> source, UnaryCallSettings.Builder<?, ?> dest) {
            dest.setRetryableCodes(source.getRetryableCodes());
            dest.setRetrySettings(source.getRetrySettings());
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setInstanceId(@Nonnull String instanceId) {
            Preconditions.checkNotNull((Object)instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            Preconditions.checkNotNull((Object)appProfileId, (Object)"AppProfileId can't be null");
            this.appProfileId = appProfileId;
            return this;
        }

        public Builder setDefaultAppProfileId() {
            this.setAppProfileId(EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID);
            return this;
        }

        public String getAppProfileId() {
            return this.appProfileId;
        }

        @Deprecated
        public Builder setRefreshingChannel(boolean isRefreshingChannel) {
            this.isRefreshingChannel = isRefreshingChannel;
            return this;
        }

        @Deprecated
        public Builder setPrimedTableIds(String ... tableIds) {
            this.primedTableIds = ImmutableList.copyOf((Object[])tableIds);
            return this;
        }

        @Deprecated
        public boolean isRefreshingChannel() {
            return this.isRefreshingChannel;
        }

        @Deprecated
        public List<String> getPrimedTableIds() {
            return this.primedTableIds;
        }

        @InternalApi(value="Used for internal testing")
        public Builder setJwtAudienceMapping(Map<String, String> jwtAudienceMapping) {
            this.jwtAudienceMapping = (Map)Preconditions.checkNotNull(jwtAudienceMapping);
            return this;
        }

        @InternalApi(value="Used for internal testing")
        public Map<String, String> getJwtAudienceMapping() {
            return this.jwtAudienceMapping;
        }

        public ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<Query, Row> readRowSettings() {
            return this.readRowSettings;
        }

        public UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings() {
            return this.sampleRowKeysSettings;
        }

        public UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings() {
            return this.mutateRowSettings;
        }

        public BigtableBatchingCallSettings.Builder bulkMutateRowsSettings() {
            return this.bulkMutateRowsSettings;
        }

        public BigtableBulkReadRowsCallSettings.Builder bulkReadRowsSettings() {
            return this.bulkReadRowsSettings;
        }

        public UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
            return this.checkAndMutateRowSettings;
        }

        public UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
            return this.readModifyWriteRowSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamSettings() {
            return this.readChangeStreamSettings;
        }

        public ServerStreamingCallSettings.Builder<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsSettings() {
            return this.generateInitialChangeStreamPartitionsSettings;
        }

        public UnaryCallSettings.Builder<PingAndWarmRequest, Void> pingAndWarmSettings() {
            return this.pingAndWarmSettings;
        }

        public EnhancedBigtableStubSettings build() {
            Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project id must be set");
            Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance id must be set");
            if (this.isRefreshingChannel) {
                Preconditions.checkArgument((boolean)(this.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider), (Object)"refreshingChannel only works with InstantiatingGrpcChannelProviders");
                InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = ((InstantiatingGrpcChannelProvider)this.getTransportChannelProvider()).toBuilder();
                Credentials credentials = null;
                if (this.getCredentialsProvider() != null) {
                    try {
                        credentials = this.getCredentialsProvider().getCredentials();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create(credentials));
                channelProviderBuilder.setChannelPrimer((ChannelPrimer)BigtableChannelPrimer.create(credentials, this.projectId, this.instanceId, this.appProfileId));
                this.setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build());
            }
            if (this.bulkMutateRowsSettings().isServerInitiatedFlowControlEnabled()) {
                this.featureFlags.setMutateRowsRateLimit(true);
            }
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            try {
                this.featureFlags.build().writeTo((OutputStream)boas);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected IOException while serializing feature flags", e);
            }
            byte[] serializedFlags = boas.toByteArray();
            byte[] encodedFlags = Base64.getUrlEncoder().encode(serializedFlags);
            ImmutableMap headers = ImmutableMap.builder().putAll(BigtableStubSettings.defaultApiClientHeaderProviderBuilder().build().getHeaders()).put((Object)"user-agent", (Object)("bigtable-java/" + Version.VERSION)).put((Object)"bigtable-features", (Object)new String(encodedFlags, StandardCharsets.UTF_8)).build();
            this.setInternalHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)headers));
            return new EnhancedBigtableStubSettings(this);
        }
    }
}

