/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriber;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class SubscriptionPartitionProcessorImpl
implements SubscriptionPartitionProcessor {
    private final @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetByteRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver;
    private final @UnknownKeyFor @NonNull @Initialized MemoryBufferedSubscriber subscriber;
    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Offset> lastClaimedOffset = Optional.empty();

    SubscriptionPartitionProcessorImpl(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetByteRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver, @UnknownKeyFor @NonNull @Initialized MemoryBufferedSubscriber subscriber) {
        Preconditions.checkArgument((boolean)Offset.of((long)((OffsetByteRange)tracker.currentRestriction()).getRange().getFrom()).equals(subscriber.fetchOffset()));
        this.tracker = tracker;
        this.receiver = receiver;
        this.subscriber = subscriber;
        subscriber.rebuffer();
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation run() {
        Optional<SequencedMessage> next = this.subscriber.peek();
        while (next.isPresent()) {
            SequencedMessage message = next.get();
            Offset messageOffset = Offset.of((long)message.getCursor().getOffset());
            if (!this.tracker.tryClaim((Object)OffsetByteProgress.of(messageOffset, message.getSizeBytes()))) {
                return DoFn.ProcessContinuation.stop();
            }
            this.subscriber.pop();
            this.lastClaimedOffset = Optional.of(messageOffset);
            this.receiver.outputWithTimestamp((Object)message, new Instant(Timestamps.toMillis((Timestamp)message.getPublishTime())));
            next = this.subscriber.peek();
        }
        return DoFn.ProcessContinuation.resume();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Offset> lastClaimed() {
        return this.lastClaimedOffset;
    }
}

