/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Struct;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSet;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSetMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ColumnType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.InitialPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.Mod;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ModType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.TypeCode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ValueCaptureType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ChangeStreamRecordMapper {
    private static final @UnknownKeyFor @NonNull @Initialized String DATA_CHANGE_RECORD_COLUMN = "data_change_record";
    private static final @UnknownKeyFor @NonNull @Initialized String HEARTBEAT_RECORD_COLUMN = "heartbeat_record";
    private static final @UnknownKeyFor @NonNull @Initialized String CHILD_PARTITIONS_RECORD_COLUMN = "child_partitions_record";
    private static final @UnknownKeyFor @NonNull @Initialized String COMMIT_TIMESTAMP_COLUMN = "commit_timestamp";
    private static final @UnknownKeyFor @NonNull @Initialized String SERVER_TRANSACTION_ID_COLUMN = "server_transaction_id";
    private static final @UnknownKeyFor @NonNull @Initialized String IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_COLUMN = "is_last_record_in_transaction_in_partition";
    private static final @UnknownKeyFor @NonNull @Initialized String RECORD_SEQUENCE_COLUMN = "record_sequence";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_NAME_COLUMN = "table_name";
    private static final @UnknownKeyFor @NonNull @Initialized String COLUMN_TYPES_COLUMN = "column_types";
    private static final @UnknownKeyFor @NonNull @Initialized String MODS_COLUMN = "mods";
    private static final @UnknownKeyFor @NonNull @Initialized String MOD_TYPE_COLUMN = "mod_type";
    private static final @UnknownKeyFor @NonNull @Initialized String VALUE_CAPTURE_TYPE_COLUMN = "value_capture_type";
    private static final @UnknownKeyFor @NonNull @Initialized String NUMBER_OF_RECORDS_IN_TRANSACTION_COLUMN = "number_of_records_in_transaction";
    private static final @UnknownKeyFor @NonNull @Initialized String NUMBER_OF_PARTITIONS_IN_TRANSACTION_COLUMN = "number_of_partitions_in_transaction";
    private static final @UnknownKeyFor @NonNull @Initialized String TRANSACTION_TAG = "transaction_tag";
    private static final @UnknownKeyFor @NonNull @Initialized String IS_SYSTEM_TRANSACTION = "is_system_transaction";
    private static final @UnknownKeyFor @NonNull @Initialized String NAME_COLUMN = "name";
    private static final @UnknownKeyFor @NonNull @Initialized String TYPE_COLUMN = "type";
    private static final @UnknownKeyFor @NonNull @Initialized String IS_PRIMARY_KEY_COLUMN = "is_primary_key";
    private static final @UnknownKeyFor @NonNull @Initialized String ORDINAL_POSITION_COLUMN = "ordinal_position";
    private static final @UnknownKeyFor @NonNull @Initialized String KEYS_COLUMN = "keys";
    private static final @UnknownKeyFor @NonNull @Initialized String OLD_VALUES_COLUMN = "old_values";
    private static final @UnknownKeyFor @NonNull @Initialized String NEW_VALUES_COLUMN = "new_values";
    private static final @UnknownKeyFor @NonNull @Initialized String TIMESTAMP_COLUMN = "timestamp";
    private static final @UnknownKeyFor @NonNull @Initialized String START_TIMESTAMP_COLUMN = "start_timestamp";
    private static final @UnknownKeyFor @NonNull @Initialized String CHILD_PARTITIONS_COLUMN = "child_partitions";
    private static final @UnknownKeyFor @NonNull @Initialized String PARENT_PARTITION_TOKENS_COLUMN = "parent_partition_tokens";
    private static final @UnknownKeyFor @NonNull @Initialized String TOKEN_COLUMN = "token";
    private final @UnknownKeyFor @NonNull @Initialized Dialect dialect;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized JsonFormat.Printer printer;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized JsonFormat.Parser parser;

    ChangeStreamRecordMapper(@UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        this.dialect = dialect;
        this.printer = JsonFormat.printer().preservingProtoFieldNames().omittingInsignificantWhitespace();
        this.parser = JsonFormat.parser().ignoringUnknownFields();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamRecord> toChangeStreamRecords(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSet resultSet, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        if (this.isPostgres()) {
            return Collections.singletonList(this.toChangeStreamRecordJson(partition, resultSet.getPgJsonb(0), resultSetMetadata));
        }
        return resultSet.getCurrentRowAsStruct().getStructList(0).stream().flatMap(struct -> this.toChangeStreamRecord(partition, (Struct)struct, resultSetMetadata)).collect(Collectors.toList());
    }

    @UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized ChangeStreamRecord> toChangeStreamRecord(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Struct row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Stream<DataChangeRecord> dataChangeRecords = row.getStructList(DATA_CHANGE_RECORD_COLUMN).stream().filter(this::isNonNullDataChangeRecord).map(struct -> this.toDataChangeRecord(partition, (Struct)struct, resultSetMetadata));
        Stream<HeartbeatRecord> heartbeatRecords = row.getStructList(HEARTBEAT_RECORD_COLUMN).stream().filter(this::isNonNullHeartbeatRecord).map(struct -> this.toHeartbeatRecord(partition, (Struct)struct, resultSetMetadata));
        Stream<ChildPartitionsRecord> childPartitionsRecords = row.getStructList(CHILD_PARTITIONS_RECORD_COLUMN).stream().filter(this::isNonNullChildPartitionsRecord).map(struct -> this.toChildPartitionsRecord(partition, (Struct)struct, resultSetMetadata));
        return Stream.concat(Stream.concat(dataChangeRecords, heartbeatRecords), childPartitionsRecords);
    }

    @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord toChangeStreamRecordJson(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized String row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Value.Builder valueBuilder = Value.newBuilder();
        try {
            this.parser.merge(row, (Message.Builder)valueBuilder);
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException("Failed to parse record into proto: " + row);
        }
        Value value = valueBuilder.build();
        if (this.isNonNullDataChangeRecordJson(value)) {
            return this.toDataChangeRecordJson(partition, value, resultSetMetadata);
        }
        if (this.isNonNullHeartbeatRecordJson(value)) {
            return this.toHeartbeatRecordJson(partition, value, resultSetMetadata);
        }
        if (this.isNonNullChildPartitionsRecordJson(value)) {
            return this.toChildPartitionsRecordJson(partition, value, resultSetMetadata);
        }
        throw new IllegalArgumentException("Unknown change stream record type " + row);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNonNullDataChangeRecord(@UnknownKeyFor @NonNull @Initialized Struct row) {
        return !row.isNull(COMMIT_TIMESTAMP_COLUMN);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNonNullDataChangeRecordJson(@UnknownKeyFor @NonNull @Initialized Value row) {
        return row.getStructValue().getFieldsMap().containsKey(DATA_CHANGE_RECORD_COLUMN);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNonNullHeartbeatRecord(@UnknownKeyFor @NonNull @Initialized Struct row) {
        return !row.isNull(TIMESTAMP_COLUMN);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNonNullHeartbeatRecordJson(@UnknownKeyFor @NonNull @Initialized Value row) {
        return row.getStructValue().getFieldsMap().containsKey(HEARTBEAT_RECORD_COLUMN);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNonNullChildPartitionsRecord(@UnknownKeyFor @NonNull @Initialized Struct row) {
        return !row.isNull(START_TIMESTAMP_COLUMN);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isNonNullChildPartitionsRecordJson(@UnknownKeyFor @NonNull @Initialized Value row) {
        return row.getStructValue().getFieldsMap().containsKey(CHILD_PARTITIONS_RECORD_COLUMN);
    }

    private @UnknownKeyFor @NonNull @Initialized DataChangeRecord toDataChangeRecord(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Struct row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Timestamp commitTimestamp = row.getTimestamp(COMMIT_TIMESTAMP_COLUMN);
        return new DataChangeRecord(partition.getPartitionToken(), commitTimestamp, row.getString(SERVER_TRANSACTION_ID_COLUMN), row.getBoolean(IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_COLUMN), row.getString(RECORD_SEQUENCE_COLUMN), row.getString(TABLE_NAME_COLUMN), row.getStructList(COLUMN_TYPES_COLUMN).stream().map(this::columnTypeFrom).collect(Collectors.toList()), row.getStructList(MODS_COLUMN).stream().map(this::modFrom).collect(Collectors.toList()), this.modTypeFrom(row.getString(MOD_TYPE_COLUMN)), this.valueCaptureTypeFrom(row.getString(VALUE_CAPTURE_TYPE_COLUMN)), row.getLong(NUMBER_OF_RECORDS_IN_TRANSACTION_COLUMN), row.getLong(NUMBER_OF_PARTITIONS_IN_TRANSACTION_COLUMN), row.getString(TRANSACTION_TAG), row.getBoolean(IS_SYSTEM_TRANSACTION), this.changeStreamRecordMetadataFrom(partition, commitTimestamp, resultSetMetadata));
    }

    private @UnknownKeyFor @NonNull @Initialized DataChangeRecord toDataChangeRecordJson(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Value row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Value dataChangeRecordValue = Optional.ofNullable((Value)row.getStructValue().getFieldsMap().get(DATA_CHANGE_RECORD_COLUMN)).orElseThrow(IllegalArgumentException::new);
        Map valueMap = dataChangeRecordValue.getStructValue().getFieldsMap();
        String commitTimestamp = Optional.ofNullable((Value)valueMap.get(COMMIT_TIMESTAMP_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue();
        return new DataChangeRecord(partition.getPartitionToken(), Timestamp.parseTimestamp((String)commitTimestamp), Optional.ofNullable((Value)valueMap.get(SERVER_TRANSACTION_ID_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_COLUMN)).orElseThrow(IllegalArgumentException::new).getBoolValue(), Optional.ofNullable((Value)valueMap.get(RECORD_SEQUENCE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(TABLE_NAME_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(COLUMN_TYPES_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList().stream().map(this::columnTypeJsonFrom).collect(Collectors.toList()), Optional.ofNullable((Value)valueMap.get(MODS_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList().stream().map(this::modJsonFrom).collect(Collectors.toList()), this.modTypeFrom(Optional.ofNullable((Value)valueMap.get(MOD_TYPE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue()), this.valueCaptureTypeFrom(Optional.ofNullable((Value)valueMap.get(VALUE_CAPTURE_TYPE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue()), (long)Optional.ofNullable((Value)valueMap.get(NUMBER_OF_RECORDS_IN_TRANSACTION_COLUMN)).orElseThrow(IllegalArgumentException::new).getNumberValue(), (long)Optional.ofNullable((Value)valueMap.get(NUMBER_OF_PARTITIONS_IN_TRANSACTION_COLUMN)).orElseThrow(IllegalArgumentException::new).getNumberValue(), Optional.ofNullable((Value)valueMap.get(TRANSACTION_TAG)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(IS_SYSTEM_TRANSACTION)).orElseThrow(IllegalArgumentException::new).getBoolValue(), this.changeStreamRecordMetadataFrom(partition, Timestamp.parseTimestamp((String)commitTimestamp), resultSetMetadata));
    }

    private @UnknownKeyFor @NonNull @Initialized HeartbeatRecord toHeartbeatRecord(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Struct row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Timestamp timestamp = row.getTimestamp(TIMESTAMP_COLUMN);
        return new HeartbeatRecord(timestamp, this.changeStreamRecordMetadataFrom(partition, timestamp, resultSetMetadata));
    }

    private @UnknownKeyFor @NonNull @Initialized HeartbeatRecord toHeartbeatRecordJson(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Value row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Value heartBeatRecordValue = Optional.ofNullable((Value)row.getStructValue().getFieldsMap().get(HEARTBEAT_RECORD_COLUMN)).orElseThrow(IllegalArgumentException::new);
        Map valueMap = heartBeatRecordValue.getStructValue().getFieldsMap();
        String heartbeatTimestamp = Optional.ofNullable((Value)valueMap.get(TIMESTAMP_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue();
        return new HeartbeatRecord(Timestamp.parseTimestamp((String)heartbeatTimestamp), this.changeStreamRecordMetadataFrom(partition, Timestamp.parseTimestamp((String)heartbeatTimestamp), resultSetMetadata));
    }

    private @UnknownKeyFor @NonNull @Initialized ChildPartitionsRecord toChildPartitionsRecord(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Struct row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Timestamp startTimestamp = row.getTimestamp(START_TIMESTAMP_COLUMN);
        return new ChildPartitionsRecord(startTimestamp, row.getString(RECORD_SEQUENCE_COLUMN), row.getStructList(CHILD_PARTITIONS_COLUMN).stream().map(struct -> this.childPartitionFrom(partition.getPartitionToken(), (Struct)struct)).collect(Collectors.toList()), this.changeStreamRecordMetadataFrom(partition, startTimestamp, resultSetMetadata));
    }

    private @UnknownKeyFor @NonNull @Initialized ChildPartitionsRecord toChildPartitionsRecordJson(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Value row, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        Value childPartitionsRecordValue = Optional.ofNullable((Value)row.getStructValue().getFieldsMap().get(CHILD_PARTITIONS_RECORD_COLUMN)).orElseThrow(IllegalArgumentException::new);
        Map valueMap = childPartitionsRecordValue.getStructValue().getFieldsMap();
        String startTimestamp = Optional.ofNullable((Value)valueMap.get(START_TIMESTAMP_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue();
        return new ChildPartitionsRecord(Timestamp.parseTimestamp((String)startTimestamp), Optional.ofNullable((Value)valueMap.get(RECORD_SEQUENCE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(CHILD_PARTITIONS_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList().stream().map(value -> this.childPartitionJsonFrom(partition.getPartitionToken(), (Value)value)).collect(Collectors.toList()), this.changeStreamRecordMetadataFrom(partition, Timestamp.parseTimestamp((String)startTimestamp), resultSetMetadata));
    }

    private @UnknownKeyFor @NonNull @Initialized ColumnType columnTypeFrom(@UnknownKeyFor @NonNull @Initialized Struct struct) {
        String type = struct.getJson(TYPE_COLUMN);
        return new ColumnType(struct.getString(NAME_COLUMN), new TypeCode(type), struct.getBoolean(IS_PRIMARY_KEY_COLUMN), struct.getLong(ORDINAL_POSITION_COLUMN));
    }

    private @UnknownKeyFor @NonNull @Initialized ColumnType columnTypeJsonFrom(@UnknownKeyFor @NonNull @Initialized Value row) {
        Map valueMap = row.getStructValue().getFieldsMap();
        try {
            String type = this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(TYPE_COLUMN)).orElseThrow(IllegalArgumentException::new));
            return new ColumnType(Optional.ofNullable((Value)valueMap.get(NAME_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), new TypeCode(type), Optional.ofNullable((Value)valueMap.get(IS_PRIMARY_KEY_COLUMN)).orElseThrow(IllegalArgumentException::new).getBoolValue(), (long)Optional.ofNullable((Value)valueMap.get(ORDINAL_POSITION_COLUMN)).orElseThrow(IllegalArgumentException::new).getNumberValue());
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException("Failed to print type: " + row);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Mod modFrom(@UnknownKeyFor @NonNull @Initialized Struct struct) {
        String keys = struct.getJson(KEYS_COLUMN);
        String oldValues = struct.isNull(OLD_VALUES_COLUMN) ? null : struct.getJson(OLD_VALUES_COLUMN);
        String newValues = struct.isNull(NEW_VALUES_COLUMN) ? null : struct.getJson(NEW_VALUES_COLUMN);
        return new Mod(keys, oldValues, newValues);
    }

    private @UnknownKeyFor @NonNull @Initialized Mod modJsonFrom(@UnknownKeyFor @NonNull @Initialized Value row) {
        try {
            Map valueMap = row.getStructValue().getFieldsMap();
            String keys = this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(KEYS_COLUMN)).orElseThrow(IllegalArgumentException::new));
            String oldValues = !valueMap.containsKey(OLD_VALUES_COLUMN) ? null : this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(OLD_VALUES_COLUMN)).orElseThrow(IllegalArgumentException::new));
            String newValues = !valueMap.containsKey(NEW_VALUES_COLUMN) ? null : this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(NEW_VALUES_COLUMN)).orElseThrow(IllegalArgumentException::new));
            return new Mod(keys, oldValues, newValues);
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException("Failed to print mod: " + row);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ModType modTypeFrom(@UnknownKeyFor @NonNull @Initialized String name) {
        try {
            return ModType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return ModType.UNKNOWN;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ValueCaptureType valueCaptureTypeFrom(@UnknownKeyFor @NonNull @Initialized String name) {
        try {
            return ValueCaptureType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return ValueCaptureType.UNKNOWN;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ChildPartition childPartitionFrom(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Struct struct) {
        HashSet parentTokens = Sets.newHashSet((Iterable)struct.getStringList(PARENT_PARTITION_TOKENS_COLUMN));
        if (InitialPartition.isInitialPartition(partitionToken)) {
            parentTokens.add(partitionToken);
        }
        return new ChildPartition(struct.getString(TOKEN_COLUMN), parentTokens);
    }

    private @UnknownKeyFor @NonNull @Initialized ChildPartition childPartitionJsonFrom(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Value row) {
        Map valueMap = row.getStructValue().getFieldsMap();
        HashSet parentTokens = Sets.newHashSet();
        for (Value parentToken : Optional.ofNullable((Value)valueMap.get(PARENT_PARTITION_TOKENS_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList()) {
            parentTokens.add(parentToken.getStringValue());
        }
        if (InitialPartition.isInitialPartition(partitionToken)) {
            parentTokens.add(partitionToken);
        }
        return new ChildPartition(Optional.ofNullable((Value)valueMap.get(TOKEN_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), parentTokens);
    }

    private @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata changeStreamRecordMetadataFrom(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized Timestamp recordTimestamp, @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSetMetadata resultSetMetadata) {
        return ChangeStreamRecordMetadata.newBuilder().withRecordTimestamp(recordTimestamp).withPartitionToken(partition.getPartitionToken()).withPartitionStartTimestamp(partition.getStartTimestamp()).withPartitionEndTimestamp(partition.getEndTimestamp()).withPartitionCreatedAt(partition.getCreatedAt()).withPartitionScheduledAt(partition.getScheduledAt()).withPartitionRunningAt(partition.getRunningAt()).withQueryStartedAt(resultSetMetadata.getQueryStartedAt()).withRecordStreamStartedAt(resultSetMetadata.getRecordStreamStartedAt()).withRecordStreamEndedAt(resultSetMetadata.getRecordStreamEndedAt()).withRecordReadAt(resultSetMetadata.getRecordReadAt()).withTotalStreamTimeMillis(resultSetMetadata.getTotalStreamDuration().getMillis()).withNumberOfRecordsRead(resultSetMetadata.getNumberOfRecordsRead()).build();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPostgres() {
        return this.dialect == Dialect.POSTGRESQL;
    }
}

