/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SdkComponents {
    private final @UnknownKeyFor @NonNull @Initialized String newIdPrefix;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder componentsBuilder = RunnerApi.Components.newBuilder();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> transformIds = HashBiMap.create();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> pCollectionIds = HashBiMap.create();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> windowingStrategyIds = HashBiMap.create();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized String> coderIds = HashBiMap.create();
    private final @UnknownKeyFor @NonNull @Initialized BiMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment, @UnknownKeyFor @NonNull @Initialized String> environmentIds = HashBiMap.create();
    private final @UnknownKeyFor @NonNull @Initialized BiMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder, @UnknownKeyFor @NonNull @Initialized String> coderProtoToId = HashBiMap.create();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> requirements;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> reservedIds = new HashSet<String>();
    private @UnknownKeyFor @NonNull @Initialized String defaultEnvironmentId;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ResourceHints, @UnknownKeyFor @NonNull @Initialized String> environmentIdsByResourceHints = new HashMap<ResourceHints, String>();

    public static @UnknownKeyFor @NonNull @Initialized SdkComponents create() {
        return new SdkComponents(RunnerApi.Components.getDefaultInstance(), null, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized SdkComponents create(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        return new SdkComponents(components, requirements, "");
    }

    static @UnknownKeyFor @NonNull @Initialized SdkComponents create(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> transforms, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pCollections, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> windowingStrategies, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> coders, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment> environments, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        SdkComponents sdkComponents = SdkComponents.create(components, requirements);
        sdkComponents.transformIds.inverse().putAll(transforms);
        sdkComponents.pCollectionIds.inverse().putAll(pCollections);
        sdkComponents.windowingStrategyIds.inverse().putAll(windowingStrategies);
        sdkComponents.coderIds.inverse().putAll(coders);
        sdkComponents.environmentIds.inverse().putAll(environments);
        return sdkComponents;
    }

    public static @UnknownKeyFor @NonNull @Initialized SdkComponents create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        SdkComponents sdkComponents = new SdkComponents(RunnerApi.Components.getDefaultInstance(), null, "");
        PortablePipelineOptions portablePipelineOptions = (PortablePipelineOptions)options.as(PortablePipelineOptions.class);
        sdkComponents.registerEnvironment(Environments.createOrGetDefaultEnvironment(portablePipelineOptions));
        return sdkComponents;
    }

    private SdkComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized RunnerApi.Components components, @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> requirements, @UnknownKeyFor @NonNull @Initialized String newIdPrefix) {
        this.newIdPrefix = newIdPrefix;
        this.requirements = new HashSet<String>();
        if (components == null) {
            if (requirements != null) {
                this.requirements.addAll(requirements);
            }
        } else {
            this.mergeFrom(components, requirements);
        }
    }

    public void mergeFrom(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        this.reservedIds.addAll(components.getTransformsMap().keySet());
        this.reservedIds.addAll(components.getPcollectionsMap().keySet());
        this.reservedIds.addAll(components.getWindowingStrategiesMap().keySet());
        this.reservedIds.addAll(components.getCodersMap().keySet());
        this.reservedIds.addAll(components.getEnvironmentsMap().keySet());
        components.getEnvironmentsMap().forEach((arg_0, arg_1) -> ((BiMap)this.environmentIds.inverse()).forcePut(arg_0, arg_1));
        components.getCodersMap().forEach((arg_0, arg_1) -> ((BiMap)this.coderProtoToId.inverse()).forcePut(arg_0, arg_1));
        if (requirements != null) {
            this.requirements.addAll(requirements);
        }
        this.componentsBuilder.mergeFrom(components);
    }

    public @UnknownKeyFor @NonNull @Initialized SdkComponents withNewIdPrefix(@UnknownKeyFor @NonNull @Initialized String newIdPrefix) {
        SdkComponents sdkComponents = new SdkComponents(this.componentsBuilder.build(), this.requirements, newIdPrefix);
        sdkComponents.transformIds.putAll(this.transformIds);
        sdkComponents.pCollectionIds.putAll(this.pCollectionIds);
        sdkComponents.windowingStrategyIds.putAll(this.windowingStrategyIds);
        sdkComponents.coderIds.putAll(this.coderIds);
        sdkComponents.environmentIds.putAll(this.environmentIds);
        return sdkComponents;
    }

    public @UnknownKeyFor @NonNull @Initialized String registerPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> children) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String name = this.getApplicationName(appliedPTransform);
        if (this.componentsBuilder.getTransformsOrDefault(name, null) != null) {
            return name;
        }
        Preconditions.checkNotNull(children, (Object)"child nodes may not be null");
        this.componentsBuilder.putTransforms(name, PTransformTranslation.toProto(appliedPTransform, children, this));
        return name;
    }

    private @UnknownKeyFor @NonNull @Initialized String getApplicationName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        if (existing != null) {
            return existing;
        }
        String name = appliedPTransform.getFullName();
        if (name.isEmpty()) {
            name = "unnamed-ptransform";
        }
        int maxNameLength = 100;
        name = (name = Normalizer.normalize(name, Normalizer.Form.NFC).replaceAll("[^A-Za-z0-9-_]", "-")).length() > maxNameLength ? name.substring(0, maxNameLength) : name;
        name = this.uniqify(name, this.transformIds.values());
        this.transformIds.put(appliedPTransform, (Object)name);
        return name;
    }

    @UnknownKeyFor @NonNull @Initialized String getExistingPTransformId(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform) {
        Preconditions.checkArgument((boolean)this.transformIds.containsKey(appliedPTransform), (String)"%s %s has not been previously registered", (Object)AppliedPTransform.class.getSimpleName(), appliedPTransform);
        return (String)this.transformIds.get(appliedPTransform);
    }

    public @UnknownKeyFor @NonNull @Initialized String getPTransformIdOrThrow(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (String)"PTransform id not found for: %s", appliedPTransform);
        return existing;
    }

    public @UnknownKeyFor @NonNull @Initialized String registerPCollection(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCollection) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String existing = (String)this.pCollectionIds.get(pCollection);
        if (existing != null) {
            return existing;
        }
        String uniqueName = this.uniqify(pCollection.getName(), this.pCollectionIds.values());
        this.pCollectionIds.put(pCollection, (Object)uniqueName);
        this.componentsBuilder.putPcollections(uniqueName, PCollectionTranslation.toProto(pCollection, this));
        return uniqueName;
    }

    public @UnknownKeyFor @NonNull @Initialized String registerWindowingStrategy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String existing = (String)this.windowingStrategyIds.get(windowingStrategy);
        if (existing != null) {
            return existing;
        }
        String baseName = String.format("%s(%s)", NameUtils.approximateSimpleName(windowingStrategy), NameUtils.approximateSimpleName((Object)windowingStrategy.getWindowFn()));
        String name = this.uniqify(baseName, this.windowingStrategyIds.values());
        this.windowingStrategyIds.put(windowingStrategy, (Object)name);
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, this);
        this.componentsBuilder.putWindowingStrategies(name, windowingStrategyProto);
        return name;
    }

    public @UnknownKeyFor @NonNull @Initialized String registerCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String existing = (String)this.coderIds.get(coder);
        if (existing != null) {
            return existing;
        }
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, this);
        if (this.coderProtoToId.containsKey((Object)coderProto)) {
            return (String)this.coderProtoToId.get((Object)coderProto);
        }
        String baseName = NameUtils.approximateSimpleName(coder);
        String name = this.uniqify(baseName, this.coderIds.values());
        this.coderIds.put(coder, (Object)name);
        this.coderProtoToId.put((Object)coderProto, (Object)name);
        this.componentsBuilder.putCoders(name, coderProto);
        return name;
    }

    public @UnknownKeyFor @NonNull @Initialized String registerEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment env) {
        String environmentId;
        String existing = (String)this.environmentIds.get((Object)env);
        if (existing != null) {
            environmentId = existing;
        } else {
            String name = this.uniqify(env.getUrn(), this.environmentIds.values());
            this.environmentIds.put((Object)env, (Object)name);
            this.componentsBuilder.putEnvironments(name, env);
            environmentId = name;
        }
        if (this.defaultEnvironmentId == null) {
            this.defaultEnvironmentId = environmentId;
        }
        return environmentId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getEnvironmentIdFor(@UnknownKeyFor @NonNull @Initialized ResourceHints resourceHints) {
        if (!this.environmentIdsByResourceHints.containsKey(resourceHints)) {
            String baseEnvironmentId = this.getOnlyEnvironmentId();
            if (resourceHints.hints().size() == 0) {
                this.environmentIdsByResourceHints.put(resourceHints, baseEnvironmentId);
            } else {
                RunnerApi.Environment env = ((RunnerApi.Environment)this.componentsBuilder.getEnvironmentsMap().get(baseEnvironmentId)).toBuilder().putAllResourceHints(Maps.transformValues((Map)resourceHints.hints(), hint -> ByteString.copyFrom((byte[])hint.toBytes()))).build();
                String name = this.uniqify(env.getUrn(), this.environmentIds.values());
                this.environmentIds.put((Object)env, (Object)name);
                this.componentsBuilder.putEnvironments(name, env);
                this.environmentIdsByResourceHints.put(resourceHints, name);
            }
        }
        return this.environmentIdsByResourceHints.get(resourceHints);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized String getOnlyEnvironmentId() {
        if (this.defaultEnvironmentId == null) {
            this.defaultEnvironmentId = (String)Iterables.getOnlyElement(this.componentsBuilder.getEnvironmentsMap().keySet());
        }
        return this.defaultEnvironmentId;
    }

    public void addRequirement(@UnknownKeyFor @NonNull @Initialized String urn) {
        this.requirements.add(urn);
    }

    private @UnknownKeyFor @NonNull @Initialized String uniqify(@UnknownKeyFor @NonNull @Initialized String baseName, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> existing) {
        String name = this.newIdPrefix + baseName;
        int increment = 1;
        while (existing.contains(name) || this.reservedIds.contains(name)) {
            name = this.newIdPrefix + baseName + Integer.toString(increment);
            ++increment;
        }
        return name;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components toComponents() {
        return this.componentsBuilder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> requirements() {
        return ImmutableSet.copyOf(this.requirements);
    }
}

