/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.function.BiFunction;

public interface UpdateFunction<K, V> {
    public static final Simple<Object> noOp = Simple.of((a, b) -> a);

    public V insert(K var1);

    public V merge(V var1, K var2);

    public void onAllocatedOnHeap(long var1);

    public static <K> UpdateFunction<K, K> noOp() {
        return noOp;
    }

    public static final class Simple<V>
    implements UpdateFunction<V, V> {
        private final BiFunction<V, V, V> wrapped;

        public Simple(BiFunction<V, V, V> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public V insert(V v) {
            return v;
        }

        @Override
        public V merge(V replacing, V update) {
            return this.wrapped.apply(replacing, update);
        }

        @Override
        public void onAllocatedOnHeap(long heapSize) {
        }

        public static <V> Simple<V> of(BiFunction<V, V, V> f) {
            return new Simple<V>(f);
        }

        Simple<V> flip() {
            return Simple.of((a, b) -> this.wrapped.apply(b, a));
        }
    }
}

