/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.validator;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.validator.Validation;
import org.apache.hop.pipeline.transforms.validator.Validator;
import org.apache.hop.pipeline.transforms.validator.ValidatorData;

@Transform(id="Validator", name="i18n::ValidatorDialog.Transform.Name", description="i18n::ValidatorDialog.Transform.Description", keywords={"i18n::ValidatorDialog.Transform.KeyWords"}, image="validator.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/validator.html")
public class ValidatorMeta
extends BaseTransformMeta<Validator, ValidatorData> {
    private static final Class<?> PKG = ValidatorMeta.class;
    @HopMetadataProperty(key="validator_field", injectionGroupKey="VALIDATIONS", injectionGroupDescription="Validator.Injection.VALIDATIONS", injectionKey="VALIDATION", injectionKeyDescription="Validator.Injection.VALIDATION")
    private List<Validation> validations = new ArrayList<Validation>();
    @HopMetadataProperty(key="validate_all", injectionKey="VALIDATE_ALL", injectionKeyDescription="Validator.Injection.VALIDATE_ALL")
    private boolean validatingAll;
    @HopMetadataProperty(key="concat_errors", injectionKey="CONCATENATE_ERRORS", injectionKeyDescription="Validator.Injection.CONCATENATE_ERRORS")
    private boolean concatenatingErrors;
    @HopMetadataProperty(key="concat_separator", injectionKey="CONCATENATION_SEPARATOR", injectionKeyDescription="Validator.Injection.CONCATENATION_SEPARATOR")
    private String concatenationSeparator;
    private static IStream newValidation = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"ValidatorMeta.NewValidation.Description", (String[])new String[0]), StreamIcon.INFO, null);

    public ValidatorMeta() {
    }

    public ValidatorMeta(ValidatorMeta m) {
        this();
        m.validations.forEach(v -> this.validations.add(new Validation((Validation)v)));
        this.validatingAll = m.validatingAll;
        this.concatenatingErrors = m.concatenatingErrors;
        this.concatenationSeparator = m.concatenationSeparator;
    }

    public ValidatorMeta clone() {
        return new ValidatorMeta(this);
    }

    public void check(List remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ValidatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add(cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta != null) {
            return ioMeta;
        }
        ioMeta = new TransformIOMeta(true, true, false, false, true, false);
        for (Validation validation : this.validations) {
            Stream stream = new Stream(IStream.StreamType.INFO, validation.getSourcingTransform(), BaseMessages.getString(PKG, (String)"ValidatorMeta.InfoStream.ValidationInput.Description", (String[])new String[]{Const.NVL((String)validation.getName(), (String)"")}), StreamIcon.INFO, validation.getSourcingTransformName());
            ioMeta.addStream((IStream)stream);
        }
        return ioMeta;
    }

    public void searchInfoAndTargetTransforms(List transforms) {
        for (Validation validation : this.validations) {
            TransformMeta transformMeta = TransformMeta.findTransform((List)transforms, (String)validation.getSourcingTransformName());
            validation.setSourcingTransform(transformMeta);
        }
        this.resetTransformIoMeta();
    }

    public void handleStreamSelection(IStream stream) {
        List streams = this.getTransformIOMeta().getInfoStreams();
        for (int i = 0; i < this.validations.size(); ++i) {
            this.validations.get(i).setSourcingTransform(((IStream)streams.get(i)).getTransformMeta());
        }
        if (stream == newValidation) {
            Validation validation = new Validation();
            validation.setName(stream.getTransformName());
            validation.setSourcingTransform(stream.getTransformMeta());
            validation.setSourcingValues(true);
            this.validations.add(validation);
        }
        this.resetTransformIoMeta();
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    public boolean isValidatingAll() {
        return this.validatingAll;
    }

    public void setValidatingAll(boolean validatingAll) {
        this.validatingAll = validatingAll;
    }

    public boolean isConcatenatingErrors() {
        return this.concatenatingErrors;
    }

    public void setConcatenatingErrors(boolean concatenatingErrors) {
        this.concatenatingErrors = concatenatingErrors;
    }

    public String getConcatenationSeparator() {
        return this.concatenationSeparator;
    }

    public void setConcatenationSeparator(String concatenationSeparator) {
        this.concatenationSeparator = concatenationSeparator;
    }

    public static IStream getNewValidation() {
        return newValidation;
    }

    public static void setNewValidation(IStream newValidation) {
        ValidatorMeta.newValidation = newValidation;
    }
}

