/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class IFSFileSystemView
extends FileSystemView {
    private static final boolean DEBUG = false;
    private AS400 system_;
    private static final String ROOT_PATH = File.separator;
    private static final String DEFAULT_FOLDER_NAME = "NewFolder";
    private static final String NEW_FOLDER_STRING0 = UIManager.getString("FileChooser.other.newFolder");
    private static final String NEW_FOLDER_NEXT_STRING0 = UIManager.getString("FileChooser.other.newFolder.subsequent");
    private static final String NEW_FOLDER_STRING = NEW_FOLDER_STRING0 == null || NEW_FOLDER_STRING0.length() == 0 ? "NewFolder" : NEW_FOLDER_STRING0;
    private static final String NEW_FOLDER_NEXT_STRING = NEW_FOLDER_NEXT_STRING0 == null || NEW_FOLDER_NEXT_STRING0.length() == 0 ? "NewFolder.{0}" : NEW_FOLDER_NEXT_STRING0;
    private static Icon serverIcon32_ = ResourceLoader.getIcon("AS40032.gif");

    public IFSFileSystemView(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public File createFileObject(File file, String string) {
        IFSJavaFile iFSJavaFile;
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (file != null) {
            IFSJavaFile iFSJavaFile2 = this.convertToIFSJavaFile(file);
            iFSJavaFile = new IFSJavaFile(iFSJavaFile2, string);
        } else {
            iFSJavaFile = new IFSJavaFile(this.system_, string);
        }
        if (this.isFileSystemRoot(iFSJavaFile)) {
            return this.createFileSystemRoot(iFSJavaFile);
        }
        return iFSJavaFile;
    }

    public File createFileObject(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        IFSJavaFile iFSJavaFile = new IFSJavaFile(this.system_, string);
        if (this.isFileSystemRoot(iFSJavaFile)) {
            return this.createFileSystemRoot(iFSJavaFile);
        }
        return iFSJavaFile;
    }

    protected File createFileSystemRoot(File file) {
        try {
            return super.createFileSystemRoot(file);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (Trace.isTraceOn()) {
                Trace.log(1, noSuchMethodError);
            }
            return file;
        }
    }

    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        IFSJavaFile iFSJavaFile = this.convertToIFSJavaFile(file);
        IFSJavaFile iFSJavaFile2 = new IFSJavaFile(iFSJavaFile, NEW_FOLDER_STRING);
        int n = 1;
        while (iFSJavaFile2.exists() && n < 100) {
            iFSJavaFile2 = new IFSJavaFile(iFSJavaFile, MessageFormat.format(NEW_FOLDER_NEXT_STRING, new Integer(n++)));
        }
        if (iFSJavaFile2.exists()) {
            throw new IOException("Directory already exists:" + iFSJavaFile2.getAbsolutePath());
        }
        iFSJavaFile2.mkdirs();
        return iFSJavaFile2;
    }

    public File getDefaultDirectory() {
        return this.createFileSystemRoot(new IFSJavaFile(this.system_, ROOT_PATH));
    }

    public File[] getFiles(File file, boolean bl) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        IFSJavaFile iFSJavaFile = this.convertToIFSJavaFile(file);
        return iFSJavaFile.listFiles();
    }

    public File getHomeDirectory() {
        return new IFSJavaFile(this.system_, ROOT_PATH);
    }

    public File getParentDirectory(File file) {
        if (file == null) {
            return null;
        }
        IFSJavaFile iFSJavaFile = this.convertToIFSJavaFile(file);
        IFSJavaFile iFSJavaFile2 = (IFSJavaFile)iFSJavaFile.getParentFile();
        if (this.isFileSystemRoot(iFSJavaFile2)) {
            return this.createFileSystemRoot(iFSJavaFile2);
        }
        return iFSJavaFile2;
    }

    public File[] getRoots() {
        return new File[]{this.createFileSystemRoot(new IFSJavaFile(this.system_, ROOT_PATH))};
    }

    public String getSystemDisplayName(File file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public Icon getSystemIcon(File file) {
        return serverIcon32_;
    }

    public String getSystemTypeDescription(File file) {
        return this.system_.getSystemName();
    }

    public boolean isComputerNode(File file) {
        return false;
    }

    public boolean isDrive(File file) {
        return false;
    }

    public boolean isFloppyDrive(File file) {
        return false;
    }

    public boolean isFileSystemRoot(File file) {
        if (file == null) {
            return false;
        }
        return file.getAbsolutePath().equals(ROOT_PATH);
    }

    public boolean isRoot(File file) {
        if (file == null || !file.isAbsolute()) {
            return false;
        }
        return file.getAbsolutePath().equals(ROOT_PATH);
    }

    private IFSJavaFile convertToIFSJavaFile(File file) {
        if (file instanceof IFSJavaFile) {
            return (IFSJavaFile)file;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "File is not an IFSJavaFile.  File is of type " + file.getClass().getName());
        }
        return new IFSJavaFile(this.system_, file.getPath());
    }

    private IFSJavaFile convertToIFSJavaFile(File file, String string) {
        return this.convertToIFSJavaFile(file);
    }
}

