/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.runners.fnexecution.environment.DockerContainerEnvironment;
import org.apache.beam.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.options.ManualDockerEnvironmentOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.RemoteEnvironmentOptions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.net.HostAndPort;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEnvironmentFactory
implements EnvironmentFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DockerEnvironmentFactory.class);
    private final @UnknownKeyFor @NonNull @Initialized DockerCommand docker;
    private final @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer;
    private final @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;

    static @UnknownKeyFor @NonNull @Initialized DockerEnvironmentFactory forServicesWithDocker(@UnknownKeyFor @NonNull @Initialized DockerCommand docker, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        return new DockerEnvironmentFactory(docker, provisioningServiceServer, clientSource, pipelineOptions);
    }

    private DockerEnvironmentFactory(@UnknownKeyFor @NonNull @Initialized DockerCommand docker, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.docker = docker;
        this.provisioningServiceServer = provisioningServiceServer;
        this.clientSource = clientSource;
        this.pipelineOptions = pipelineOptions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized RemoteEnvironment createEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, @UnknownKeyFor @NonNull @Initialized String workerId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState((boolean)environment.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.DOCKER)), (Object)"The passed environment does not contain a DockerPayload.");
        RunnerApi.DockerPayload dockerPayload = RunnerApi.DockerPayload.parseFrom((ByteString)environment.getPayload());
        String containerImage = dockerPayload.getContainerImage();
        String provisionEndpoint = this.provisioningServiceServer.getApiServiceDescriptor().getUrl();
        ImmutableList.Builder dockerOptsBuilder = ImmutableList.builder().addAll(this.gcsCredentialArgs()).add((Object)"--network=host").add((Object)("--env=DOCKER_MAC_CONTAINER=" + System.getenv("DOCKER_MAC_CONTAINER")));
        boolean retainDockerContainer = ((ManualDockerEnvironmentOptions)this.pipelineOptions.as(ManualDockerEnvironmentOptions.class)).getRetainDockerContainers();
        String semiPersistDir = ((RemoteEnvironmentOptions)this.pipelineOptions.as(RemoteEnvironmentOptions.class)).getSemiPersistDir();
        ImmutableList.Builder argsBuilder = ImmutableList.builder().add((Object)String.format("--id=%s", workerId)).add((Object)String.format("--provision_endpoint=%s", provisionEndpoint));
        if (semiPersistDir != null) {
            argsBuilder.add((Object)String.format("--semi_persist_dir=%s", semiPersistDir));
        }
        LOG.debug("Creating Docker Container with ID {}", (Object)workerId);
        String containerId = null;
        InstructionRequestHandler instructionHandler = null;
        try {
            containerId = this.docker.runImage(containerImage, (List<String>)dockerOptsBuilder.build(), (List<String>)argsBuilder.build());
            LOG.debug("Created Docker Container with Container ID {}", (Object)containerId);
            while (instructionHandler == null) {
                try {
                    if (!this.docker.isContainerRunning(containerId)) {
                        IllegalStateException illegalStateException = new IllegalStateException(String.format("No container running for id %s", containerId));
                        try {
                            String containerLogs = this.docker.getContainerLogs(containerId);
                            LOG.error("Docker container {} logs:\n{}", (Object)containerId, (Object)containerLogs);
                            throw illegalStateException;
                        }
                        catch (Exception getLogsException) {
                            illegalStateException.addSuppressed(getLogsException);
                        }
                        throw illegalStateException;
                    }
                    instructionHandler = this.clientSource.take(workerId, Duration.ofSeconds(5L));
                }
                catch (TimeoutException timeoutEx) {
                    LOG.info("Still waiting for startup of environment {} for worker id {}", (Object)dockerPayload.getContainerImage(), (Object)workerId);
                }
                catch (InterruptedException interruptEx) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptEx);
                    return DockerContainerEnvironment.create(this.docker, environment, containerId, instructionHandler, retainDockerContainer);
                }
            }
        }
        catch (Exception e) {
            if (containerId == null) throw e;
            try {
                this.docker.killContainer(containerId);
                if (retainDockerContainer) throw e;
                this.docker.removeContainer(containerId);
                throw e;
            }
            catch (Exception dockerException) {
                e.addSuppressed(dockerException);
            }
            throw e;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> gcsCredentialArgs() {
        String dockerGcloudConfig = "/root/.config/gcloud";
        String localGcloudConfig = (String)MoreObjects.firstNonNull((Object)System.getenv("CLOUDSDK_CONFIG"), (Object)Paths.get(System.getProperty("user.home"), ".config", "gcloud").toString());
        if (Files.exists(Paths.get(localGcloudConfig, new String[0]), new LinkOption[0])) {
            return ImmutableList.of((Object)"--mount", (Object)String.format("type=bind,src=%s,dst=%s", localGcloudConfig, dockerGcloudConfig));
        }
        return ImmutableList.of();
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;

        public Provider(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.pipelineOptions = options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized EnvironmentFactory createEnvironmentFactory(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> controlServiceServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> loggingServiceServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService> retrievalServiceServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool clientPool, @UnknownKeyFor @NonNull @Initialized IdGenerator idGenerator) {
            return DockerEnvironmentFactory.forServicesWithDocker(DockerCommand.getDefault(), provisioningServiceServer, clientPool.getSource(), this.pipelineOptions);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ServerFactory getServerFactory() {
            switch (Provider.getPlatform()) {
                case LINUX: {
                    return ServerFactory.createDefault();
                }
                case MAC: {
                    return DockerOnMac.getServerFactory();
                }
            }
            LOG.warn("Unknown Docker platform. Falling back to default server factory");
            return ServerFactory.createDefault();
        }

        private static @UnknownKeyFor @NonNull @Initialized Platform getPlatform() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("mac") || DockerOnMac.RUNNING_INSIDE_DOCKER_ON_MAC) {
                return Platform.MAC;
            }
            if (osName.startsWith("linux")) {
                return Platform.LINUX;
            }
            return Platform.OTHER;
        }

        private static enum Platform {
            MAC,
            LINUX,
            OTHER;

        }
    }

    static class DockerOnMac {
        private static final @UnknownKeyFor @NonNull @Initialized String DOCKER_FOR_MAC_HOST = "host.docker.internal";
        private static final @UnknownKeyFor @NonNull @Initialized boolean RUNNING_INSIDE_DOCKER_ON_MAC = "1".equals(System.getenv("DOCKER_MAC_CONTAINER"));
        private static final @UnknownKeyFor @NonNull @Initialized int MAC_PORT_START = 8100;
        private static final @UnknownKeyFor @NonNull @Initialized int MAC_PORT_END = 8200;
        private static final @UnknownKeyFor @NonNull @Initialized AtomicInteger MAC_PORT = new AtomicInteger(8100);

        DockerOnMac() {
        }

        static @UnknownKeyFor @NonNull @Initialized ServerFactory getServerFactory() {
            ServerFactory.UrlFactory dockerUrlFactory = (host, port) -> HostAndPort.fromParts((String)DOCKER_FOR_MAC_HOST, (int)port).toString();
            if (RUNNING_INSIDE_DOCKER_ON_MAC) {
                return ServerFactory.createWithUrlFactoryAndPortSupplier((ServerFactory.UrlFactory)dockerUrlFactory, () -> MAC_PORT.getAndUpdate(val -> val == 8200 ? 8100 : val + 1));
            }
            return ServerFactory.createWithUrlFactory((ServerFactory.UrlFactory)dockerUrlFactory);
        }
    }
}

