/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtobufUtil;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class ProtoCoder<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Message>
extends CustomCoder<T> {
    public static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -5043999806040629525L;
    final @UnknownKeyFor @NonNull @Initialized Class<T> protoMessageClass;
    final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> extensionHostClasses;
    private volatile transient @UnknownKeyFor @NonNull @Initialized ExtensionRegistry memoizedExtensionRegistry;
    transient @UnknownKeyFor @NonNull @Initialized Parser<T> memoizedParser;
    static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Message> MESSAGE_TYPE = new TypeDescriptor<Message>(){};

    public static <T extends Message> @UnknownKeyFor @NonNull @Initialized ProtoCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> protoMessageClass) {
        return new ProtoCoder<T>(protoMessageClass, (Set<Class<?>>)ImmutableSet.of());
    }

    public static <T extends Message> @UnknownKeyFor @NonNull @Initialized ProtoCoder<T> of(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> protoMessageType) {
        Class protoMessageClass = protoMessageType.getRawType();
        return ProtoCoder.of(protoMessageClass);
    }

    void validateExtensions(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> moreExtensionHosts) {
        for (Class<?> extensionHost : moreExtensionHosts) {
            try {
                Method registerAllExtensions = extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class);
                Preconditions.checkArgument((boolean)Modifier.isStatic(registerAllExtensions.getModifiers()), (Object)"Method registerAllExtensions() must be static");
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(String.format("Unable to register extensions for %s", extensionHost.getCanonicalName()), e);
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized ProtoCoder<T> withExtensionsFrom(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> moreExtensionHosts) {
        this.validateExtensions(moreExtensionHosts);
        return new ProtoCoder<T>(this.protoMessageClass, (Set<Class<?>>)new ImmutableSet.Builder().addAll(this.extensionHostClasses).addAll(moreExtensionHosts).build());
    }

    public @UnknownKeyFor @NonNull @Initialized ProtoCoder<T> withExtensionsFrom(Class<?> ... moreExtensionHosts) {
        return this.withExtensionsFrom(Arrays.asList(moreExtensionHosts));
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null " + this.protoMessageClass.getSimpleName());
        }
        if (context.isWholeStream) {
            value.writeTo(outStream);
        } else {
            value.writeDelimitedTo(outStream);
        }
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (context.isWholeStream) {
            return (T)((Message)this.getParser().parseFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
        }
        return (T)((Message)this.getParser().parseDelimitedFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        ProtoCoder otherCoder = (ProtoCoder)((Object)other);
        return this.protoMessageClass.equals(otherCoder.protoMessageClass) && Sets.newHashSet(this.extensionHostClasses).equals(Sets.newHashSet(otherCoder.extensionHostClasses));
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.protoMessageClass, this.extensionHostClasses);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        ProtobufUtil.verifyDeterministic(this);
    }

    public @UnknownKeyFor @NonNull @Initialized Class<T> getMessageType() {
        return this.protoMessageClass;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getExtensionHosts() {
        return this.extensionHostClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized ExtensionRegistry getExtensionRegistry() {
        if (this.memoizedExtensionRegistry == null) {
            ProtoCoder protoCoder = this;
            synchronized (protoCoder) {
                if (this.memoizedExtensionRegistry == null) {
                    ExtensionRegistry registry = ExtensionRegistry.newInstance();
                    for (Class<?> extensionHost : this.extensionHostClasses) {
                        try {
                            extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class).invoke(null, registry);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    this.memoizedExtensionRegistry = registry.getUnmodifiable();
                }
            }
        }
        return this.memoizedExtensionRegistry;
    }

    protected ProtoCoder(@UnknownKeyFor @NonNull @Initialized Class<T> protoMessageClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> extensionHostClasses) {
        this.protoMessageClass = protoMessageClass;
        this.extensionHostClasses = extensionHostClasses;
    }

    protected @UnknownKeyFor @NonNull @Initialized Parser<T> getParser() {
        if (this.memoizedParser == null) {
            try {
                Parser tParser;
                if (DynamicMessage.class.equals(this.protoMessageClass)) {
                    throw new IllegalArgumentException("DynamicMessage is not supported by the ProtoCoder, use the DynamicProtoCoder.");
                }
                Message protoMessageInstance = (Message)this.protoMessageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
                this.memoizedParser = tParser = protoMessageInstance.getParserForType();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.memoizedParser;
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return new ProtoCoderProvider();
    }

    private static class ProtoCoderProvider
    extends CoderProvider {
        private ProtoCoderProvider() {
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(MESSAGE_TYPE)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", ProtoCoder.class.getSimpleName(), typeDescriptor, Message.class.getName()));
            }
            TypeDescriptor<T> messageType = typeDescriptor;
            try {
                ProtoCoder<T> coder = ProtoCoder.of(messageType);
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }
}

