/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.EventLogFileReader;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesFileReader;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import org.apache.spark.deploy.history.SingleFileEventLogFileReader;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class EventLogFileReader$
implements Logging {
    public static EventLogFileReader$ MODULE$;
    private final ConcurrentHashMap<String, CompressionCodec> codecMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new EventLogFileReader$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<String, CompressionCodec> codecMap() {
        return this.codecMap;
    }

    public EventLogFileReader apply(FileSystem fs, Path path, Option<Object> lastIndex) {
        Option<Object> option = lastIndex;
        if (option instanceof Some) {
            return new RollingEventLogFilesFileReader(fs, path);
        }
        if (None$.MODULE$.equals(option)) {
            return new SingleFileEventLogFileReader(fs, path);
        }
        throw new MatchError(option);
    }

    public Option<EventLogFileReader> apply(FileSystem fs, Path path) {
        return this.apply(fs, fs.getFileStatus(path));
    }

    public Option<EventLogFileReader> apply(FileSystem fs, FileStatus status2) {
        if (this.isSingleEventLog(status2)) {
            return new Some((Object)new SingleFileEventLogFileReader(fs, status2.getPath(), (Option<FileStatus>)Option$.MODULE$.apply((Object)status2)));
        }
        if (this.isRollingEventLogs(status2)) {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(status2.getPath()))).exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status)))) {
                return new Some((Object)new RollingEventLogFilesFileReader(fs, status2.getPath()));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Rolling event log directory have no event log file at ").append(status2.getPath()).toString());
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public InputStream openEventLog(Path log, FileSystem fs) {
        InputStream inputStream;
        BufferedInputStream in = new BufferedInputStream((InputStream)fs.open(log));
        try {
            Option codec = EventLogFileWriter$.MODULE$.codecName(log).map((Function1 & Serializable & scala.Serializable)c -> MODULE$.codecMap().computeIfAbsent((String)c, x$1 -> CompressionCodec$.MODULE$.createCodec(new SparkConf(), (String)x$1)));
            inputStream = (InputStream)codec.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.compressedContinuousInputStream(in)).getOrElse((Function0 & Serializable & scala.Serializable)() -> in);
        }
        catch (Throwable e) {
            in.close();
            throw e;
        }
        return inputStream;
    }

    private boolean isSingleEventLog(FileStatus status) {
        return !status.isDirectory() && !status.getPath().getName().startsWith(".");
    }

    private boolean isRollingEventLogs(FileStatus status) {
        return RollingEventLogFilesWriter$.MODULE$.isEventLogDir(status);
    }

    private EventLogFileReader$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.codecMap = new ConcurrentHashMap();
    }
}

