/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DriverDescription;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.StandaloneResourceUtils$;
import org.apache.spark.deploy.master.DriverState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.deploy.worker.DriverRunner$;
import org.apache.spark.deploy.worker.ProcessBuilderLike;
import org.apache.spark.deploy.worker.ProcessBuilderLike$;
import org.apache.spark.deploy.worker.Sleeper;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.Worker$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]e!\u0002\u001c8\u0001e\n\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tE\u0002\u0011)\u0019!C\u0001G\"AA\u000e\u0001B\u0001B\u0003%A\r\u0003\u0005n\u0001\t\u0015\r\u0011\"\u0001d\u0011!q\u0007A!A!\u0002\u0013!\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011U\u0004!\u0011!Q\u0001\nED\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\tA\u001e\u0005\t{\u0002\u0011\t\u0011)A\u0005o\"Aa\u0010\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005\u0000\u0001\t\u0005\t\u0015!\u0003W\u0011%\t\t\u0001\u0001BC\u0002\u0013\u0005Q\u000bC\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005-\"Q\u0011Q\u0001\u0001\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005=\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u0019!C\u0001\u0003'A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011\u001d\tI\u0003\u0001C\u0001\u0003WA\u0011\"!\u0012\u0001\u0001\u0004%I!a\u0012\t\u0013\u0005m\u0003\u00011A\u0005\n\u0005u\u0003\u0002CA5\u0001\u0001\u0006K!!\u0013\t\u0013\u0005M\u0004\u00011A\u0005\n\u0005U\u0004\"CA?\u0001\u0001\u0007I\u0011BA@\u0011!\t\u0019\t\u0001Q!\n\u0005]\u0004BCAD\u0001\u0001\u0007I\u0011A\u001c\u0002\n\"Q\u00111\u0017\u0001A\u0002\u0013\u0005q'!.\t\u0011\u0005e\u0006\u0001)Q\u0005\u0003\u0017C!\"!0\u0001\u0001\u0004%\taNA`\u0011)\t)\u000e\u0001a\u0001\n\u00039\u0014q\u001b\u0005\t\u00037\u0004\u0001\u0015)\u0003\u0002B\"I\u0011q\u001c\u0001C\u0002\u0013%\u0011\u0011\u001d\u0005\t\u0003S\u0004\u0001\u0015!\u0003\u0002d\"9\u00111\u001e\u0001\u0005\u0002\u00055\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\n\u0005\u001b\u0001\u0001\u0019!C\u0005\u0005\u001fA\u0011B!\u0005\u0001\u0001\u0004%IAa\u0005\t\u0011\t]\u0001\u0001)Q\u0005\u0003gD\u0011B!\u0007\u0001\u0001\u0004%IAa\u0007\t\u0013\t\u0015\u0002\u00011A\u0005\n\t\u001d\u0002\u0002\u0003B\u0012\u0001\u0001\u0006KA!\b\t\u0011\t-\u0002\u0001\"\u00018\u0005[A\u0001Ba\f\u0001\t\u00039$Q\u0006\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oA\u0001B!\u0010\u0001\t\u00039$q\b\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011!\u0011i\u0006\u0001C\u0001o\t}sA\u0003B<o\u0005\u0005\t\u0012A\u001d\u0003z\u0019IagNA\u0001\u0012\u0003I$1\u0010\u0005\b\u0003S\u0019D\u0011\u0001B?\u0011%\u0011yhMI\u0001\n\u0003\u0011\tI\u0001\u0007Ee&4XM\u001d*v]:,'O\u0003\u00029s\u00051qo\u001c:lKJT!AO\u001e\u0002\r\u0011,\u0007\u000f\\8z\u0015\taT(A\u0003ta\u0006\u00148N\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<7c\u0001\u0001C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\u0004\"!\u0013'\u000e\u0003)S!aS\u001e\u0002\u0011%tG/\u001a:oC2L!!\u0014&\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"!\u0015*\u000e\u0003mJ!aU\u001e\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001\u00033sSZ,'/\u00133\u0016\u0003Y\u0003\"a\u00160\u000f\u0005ac\u0006CA-E\u001b\u0005Q&BA.P\u0003\u0019a$o\\8u}%\u0011Q\fR\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^\t\u0006IAM]5wKJLE\rI\u0001\bo>\u00148\u000eR5s+\u0005!\u0007CA3k\u001b\u00051'BA4i\u0003\tIwNC\u0001j\u0003\u0011Q\u0017M^1\n\u0005-4'\u0001\u0002$jY\u0016\f\u0001b^8sW\u0012K'\u000fI\u0001\ngB\f'o\u001b%p[\u0016\f!b\u001d9be.Du.\\3!\u0003)!'/\u001b<fe\u0012+7oY\u000b\u0002cB\u0011!o]\u0007\u0002s%\u0011A/\u000f\u0002\u0012\tJLg/\u001a:EKN\u001c'/\u001b9uS>t\u0017a\u00033sSZ,'\u000fR3tG\u0002*\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003un\n1A\u001d9d\u0013\ta\u0018P\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\u000f]|'o[3sA\u0005Iqo\u001c:lKJ,&\u000f\\\u0001\u000bo>\u00148.\u001a:Ve2\u0004\u0013AD<pe.,'oV3c+&,&\u000f\\\u0001\u0010o>\u00148.\u001a:XK\n,\u0016.\u0016:mA\u0005y1/Z2ve&$\u00180T1oC\u001e,'/\u0006\u0002\u0002\nA\u0019\u0011+a\u0003\n\u0007\u000551HA\bTK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s\u0003A\u0019XmY;sSRLX*\u00198bO\u0016\u0014\b%A\u0005sKN|WO]2fgV\u0011\u0011Q\u0003\t\u0007/\u0006]a+a\u0007\n\u0007\u0005e\u0001MA\u0002NCB\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CY\u0014\u0001\u0003:fg>,(oY3\n\t\u0005\u0015\u0012q\u0004\u0002\u0014%\u0016\u001cx.\u001e:dK&sgm\u001c:nCRLwN\\\u0001\u000be\u0016\u001cx.\u001e:dKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\f\u0002.\u0005E\u00121GA\u001b\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"!\r\ty\u0003A\u0007\u0002o!)a\n\u0006a\u0001!\")A\u000b\u0006a\u0001-\")!\r\u0006a\u0001I\")Q\u000e\u0006a\u0001I\")q\u000e\u0006a\u0001c\")\u0001\b\u0006a\u0001o\")a\u0010\u0006a\u0001-\"1\u0011\u0011\u0001\u000bA\u0002YCq!!\u0002\u0015\u0001\u0004\tI\u0001C\u0005\u0002\u0012Q\u0001\n\u00111\u0001\u0002\u0016\u00059\u0001O]8dKN\u001cXCAA%!\u0015\u0019\u00151JA(\u0013\r\ti\u0005\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016i\u0003\u0011a\u0017M\\4\n\t\u0005e\u00131\u000b\u0002\b!J|7-Z:t\u0003-\u0001(o\\2fgN|F%Z9\u0015\t\u0005}\u0013Q\r\t\u0004\u0007\u0006\u0005\u0014bAA2\t\n!QK\\5u\u0011%\t9GFA\u0001\u0002\u0004\tI%A\u0002yIE\n\u0001\u0002\u001d:pG\u0016\u001c8\u000f\t\u0015\u0004/\u00055\u0004cA\"\u0002p%\u0019\u0011\u0011\u000f#\u0003\u0011Y|G.\u0019;jY\u0016\faa[5mY\u0016$WCAA<!\r\u0019\u0015\u0011P\u0005\u0004\u0003w\"%a\u0002\"p_2,\u0017M\\\u0001\u000bW&dG.\u001a3`I\u0015\fH\u0003BA0\u0003\u0003C\u0011\"a\u001a\u001a\u0003\u0003\u0005\r!a\u001e\u0002\u000f-LG\u000e\\3eA!\u001a!$!\u001c\u0002\u0015\u0019Lg.\u00197Ti\u0006$X-\u0006\u0002\u0002\fB)1)a\u0013\u0002\u000eB!\u0011qRAW\u001d\u0011\t\t*a*\u000f\t\u0005M\u00151\u0015\b\u0005\u0003+\u000b\tK\u0004\u0003\u0002\u0018\u0006}e\u0002BAM\u0003;s1!WAN\u0013\u0005\u0001\u0015B\u0001 @\u0013\taT(\u0003\u0002;w%\u0019\u0011QU\u001d\u0002\r5\f7\u000f^3s\u0013\u0011\tI+a+\u0002\u0017\u0011\u0013\u0018N^3s'R\fG/\u001a\u0006\u0004\u0003KK\u0014\u0002BAX\u0003c\u00131\u0002\u0012:jm\u0016\u00148\u000b^1uK*!\u0011\u0011VAV\u000391\u0017N\\1m'R\fG/Z0%KF$B!a\u0018\u00028\"I\u0011q\r\u000f\u0002\u0002\u0003\u0007\u00111R\u0001\fM&t\u0017\r\\*uCR,\u0007\u0005K\u0002\u001e\u0003[\naBZ5oC2,\u0005pY3qi&|g.\u0006\u0002\u0002BB)1)a\u0013\u0002DB!\u0011QYAh\u001d\u0011\t9-a3\u000f\u0007e\u000bI-C\u0001F\u0013\r\ti\rR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t.a5\u0003\u0013\u0015C8-\u001a9uS>t'bAAg\t\u0006\u0011b-\u001b8bY\u0016C8-\u001a9uS>tw\fJ3r)\u0011\ty&!7\t\u0013\u0005\u001dt$!AA\u0002\u0005\u0005\u0017a\u00044j]\u0006dW\t_2faRLwN\u001c\u0011)\u0007\u0001\ni'\u0001\ree&4XM\u001d+fe6Lg.\u0019;f)&lWm\\;u\u001bN,\"!a9\u0011\u0007\r\u000b)/C\u0002\u0002h\u0012\u0013A\u0001T8oO\u0006IBM]5wKJ$VM]7j]\u0006$X\rV5nK>,H/T:!\u0003!\u0019X\r^\"m_\u000e\\G\u0003BA0\u0003_Dq!!=$\u0001\u0004\t\u00190\u0001\u0004`G2|7m\u001b\t\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011`\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003{\f9PA\u0003DY>\u001c7.\u0001\u0006tKR\u001cF.Z3qKJ$B!a\u0018\u0003\u0004!9!Q\u0001\u0013A\u0002\t\u001d\u0011\u0001C0tY\u0016,\u0007/\u001a:\u0011\t\u0005=\"\u0011B\u0005\u0004\u0005\u00179$aB*mK\u0016\u0004XM]\u0001\u0006G2|7m[\u000b\u0003\u0003g\f\u0011b\u00197pG.|F%Z9\u0015\t\u0005}#Q\u0003\u0005\n\u0003O2\u0013\u0011!a\u0001\u0003g\faa\u00197pG.\u0004\u0013aB:mK\u0016\u0004XM]\u000b\u0003\u0005;\u0011RAa\bC\u0005\u000f1aA!\t+\u0001\tu!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014\u0001C:mK\u0016\u0004XM\u001d\u0011\u0002\u0017MdW-\u001a9fe~#S-\u001d\u000b\u0005\u0003?\u0012I\u0003C\u0005\u0002h%\n\t\u00111\u0001\u0003\u001e\u0005)1\u000f^1siR\u0011\u0011qL\u0001\u0005W&dG.\u0001\fde\u0016\fG/Z,pe.Lgn\u001a#je\u0016\u001cGo\u001c:z)\u0005!\u0017a\u00043po:dw.\u00193Vg\u0016\u0014(*\u0019:\u0015\u0007Y\u0013I\u0004\u0003\u0004\u0003<9\u0002\r\u0001Z\u0001\nIJLg/\u001a:ESJ\f1\u0003\u001d:fa\u0006\u0014X-\u00118e%VtGI]5wKJ$\"A!\u0011\u0011\u0007\r\u0013\u0019%C\u0002\u0003F\u0011\u00131!\u00138u\u0003%\u0011XO\u001c#sSZ,'\u000f\u0006\u0005\u0003B\t-#Q\u000bB-\u0011\u001d\u0011i\u0005\ra\u0001\u0005\u001f\nqAY;jY\u0012,'\u000f\u0005\u0003\u0002R\tE\u0013\u0002\u0002B*\u0003'\u0012a\u0002\u0015:pG\u0016\u001c8OQ;jY\u0012,'\u000f\u0003\u0004\u0003XA\u0002\r\u0001Z\u0001\bE\u0006\u001cX\rR5s\u0011\u001d\u0011Y\u0006\ra\u0001\u0003o\n\u0011b];qKJ4\u0018n]3\u0002'I,hnQ8n[\u0006tGmV5uQJ+GO]=\u0015\u0011\t\u0005#\u0011\rB6\u0005kBqAa\u00192\u0001\u0004\u0011)'A\u0004d_6l\u0017M\u001c3\u0011\t\u0005=\"qM\u0005\u0004\u0005S:$A\u0005)s_\u000e,7o\u001d\"vS2$WM\u001d'jW\u0016DqA!\u001c2\u0001\u0004\u0011y'\u0001\u0006j]&$\u0018.\u00197ju\u0016\u0004ra\u0011B9\u0003\u001f\ny&C\u0002\u0003t\u0011\u0013\u0011BR;oGRLwN\\\u0019\t\u000f\tm\u0013\u00071\u0001\u0002x\u0005aAI]5wKJ\u0014VO\u001c8feB\u0019\u0011qF\u001a\u0014\u0005M\u0012EC\u0001B=\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa!+\t\u0005U!QQ\u0016\u0003\u0005\u000f\u0003BA!#\u0003\u00146\u0011!1\u0012\u0006\u0005\u0005\u001b\u0013y)A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0013#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0016\n-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DriverRunner
implements Logging {
    private final SparkConf conf;
    private final String driverId;
    private final File workDir;
    private final File sparkHome;
    private final DriverDescription driverDesc;
    private final RpcEndpointRef worker;
    private final String workerUrl;
    private final String workerWebUiUrl;
    private final SecurityManager securityManager;
    private final scala.collection.immutable.Map<String, ResourceInformation> resources;
    private volatile Option<Process> process;
    private volatile boolean org$apache$spark$deploy$worker$DriverRunner$$killed;
    private volatile Option<Enumeration.Value> finalState;
    private volatile Option<Exception> finalException;
    private final long driverTerminateTimeoutMs;
    private Clock clock;
    private Sleeper sleeper;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static scala.collection.immutable.Map<String, ResourceInformation> $lessinit$greater$default$10() {
        return DriverRunner$.MODULE$.$lessinit$greater$default$10();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String driverId() {
        return this.driverId;
    }

    public File workDir() {
        return this.workDir;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public DriverDescription driverDesc() {
        return this.driverDesc;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public String workerWebUiUrl() {
        return this.workerWebUiUrl;
    }

    public SecurityManager securityManager() {
        return this.securityManager;
    }

    public scala.collection.immutable.Map<String, ResourceInformation> resources() {
        return this.resources;
    }

    private Option<Process> process() {
        return this.process;
    }

    private void process_$eq(Option<Process> x$1) {
        this.process = x$1;
    }

    public boolean org$apache$spark$deploy$worker$DriverRunner$$killed() {
        return this.org$apache$spark$deploy$worker$DriverRunner$$killed;
    }

    private void org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(boolean x$1) {
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = x$1;
    }

    public Option<Enumeration.Value> finalState() {
        return this.finalState;
    }

    public void finalState_$eq(Option<Enumeration.Value> x$1) {
        this.finalState = x$1;
    }

    public Option<Exception> finalException() {
        return this.finalException;
    }

    public void finalException_$eq(Option<Exception> x$1) {
        this.finalException = x$1;
    }

    private long driverTerminateTimeoutMs() {
        return this.driverTerminateTimeoutMs;
    }

    public void setClock(Clock _clock) {
        this.clock_$eq(_clock);
    }

    public void setSleeper(Sleeper _sleeper) {
        this.sleeper_$eq(_sleeper);
    }

    private Clock clock() {
        return this.clock;
    }

    private void clock_$eq(Clock x$1) {
        this.clock = x$1;
    }

    private Sleeper sleeper() {
        return this.sleeper;
    }

    private void sleeper_$eq(Sleeper x$1) {
        this.sleeper = x$1;
    }

    public void start() {
        new Thread(this){
            private final /* synthetic */ DriverRunner $outer;

            public void run() {
                Object shutdownHook = null;
                try {
                    try {
                        shutdownHook = ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Worker shutting down, killing driver ").append($this.$outer.driverId()).toString());
                            $this.$outer.kill();
                        });
                        int exitCode = this.$outer.prepareAndRunDriver();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)(exitCode == 0 ? new Some((Object)DriverState$.MODULE$.FINISHED()) : (this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed() ? new Some((Object)DriverState$.MODULE$.KILLED()) : new Some((Object)DriverState$.MODULE$.FAILED()))));
                    }
                    catch (Exception e) {
                        this.$outer.kill();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)new Some((Object)DriverState$.MODULE$.ERROR()));
                        this.$outer.finalException_$eq((Option<Exception>)new Some((Object)e));
                    }
                }
                finally {
                    if (shutdownHook != null) {
                        ShutdownHookManager$.MODULE$.removeShutdownHook(shutdownHook);
                    }
                }
                this.$outer.worker().send(new DeployMessages.DriverStateChanged(this.$outer.driverId(), (Enumeration.Value)this.$outer.finalState().get(), this.$outer.finalException()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(17).append("DriverRunner for ").append($outer.driverId()).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.deploy.worker.DriverRunner$$anon$2 ), $anonfun$run$2(org.apache.spark.deploy.worker.DriverRunner$$anon$2 )}, serializedLambda);
            }
        }.start();
    }

    public void kill() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing driver process!");
        this.org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(true);
        DriverRunner driverRunner = this;
        synchronized (driverRunner) {
            this.process().foreach((Function1 & Serializable & scala.Serializable)p -> {
                DriverRunner.$anonfun$kill$2(this, p);
                return BoxedUnit.UNIT;
            });
        }
    }

    private File createWorkingDirectory() {
        File driverDir = new File(this.workDir(), this.driverId());
        if (!driverDir.exists() && !driverDir.mkdirs()) {
            throw new IOException(new StringBuilder(27).append("Failed to create directory ").append(driverDir).toString());
        }
        return driverDir;
    }

    private String downloadUserJar(File driverDir) {
        String jarFileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new URI(this.driverDesc().jarUrl()).getPath().split("/"))).last();
        File localJarFile = new File(driverDir, jarFileName);
        if (!localJarFile.exists()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Copying user jar ").append(this.driverDesc().jarUrl()).append(" to ").append(localJarFile).toString());
            Utils$.MODULE$.fetchFile(this.driverDesc().jarUrl(), driverDir, this.conf, SparkHadoopUtil$.MODULE$.get().newConfiguration(this.conf), System.currentTimeMillis(), false, Utils$.MODULE$.fetchFile$default$7());
            if (!localJarFile.exists()) {
                throw new IOException(new StringBuilder(60).append("Can not find expected jar ").append(jarFileName).append(" which should have been loaded in ").append(driverDir).toString());
            }
        }
        return localJarFile.getAbsolutePath();
    }

    public int prepareAndRunDriver() {
        Seq javaOpts;
        File driverDir = this.createWorkingDirectory();
        String localJarFilename = this.downloadUserJar(driverDir);
        Option<File> resourceFileOpt = StandaloneResourceUtils$.MODULE$.prepareResourcesFile(package$.MODULE$.SPARK_DRIVER_PREFIX(), this.resources(), driverDir);
        Seq x$1 = javaOpts = (Seq)this.driverDesc().command().javaOpts().$plus$plus((GenTraversableOnce)resourceFileOpt.map((Function1 & Serializable & scala.Serializable)f -> (Seq)new .colon.colon((Object)new StringBuilder(3).append("-D").append(package$.MODULE$.DRIVER_RESOURCES_FILE().key()).append("=").append(f.getAbsolutePath()).toString(), (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        String x$2 = this.driverDesc().command().copy$default$1();
        Seq<String> x$3 = this.driverDesc().command().copy$default$2();
        Map<String, String> x$4 = this.driverDesc().command().copy$default$3();
        Seq<String> x$5 = this.driverDesc().command().copy$default$4();
        Seq<String> x$6 = this.driverDesc().command().copy$default$5();
        ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(this.driverDesc().command().copy(x$2, x$3, x$4, x$5, x$6, (Seq<String>)x$1), this.securityManager(), this.driverDesc().mem(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables$1((String)argument, localJarFilename), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
        boolean reverseProxy = BoxesRunTime.unboxToBoolean((Object)this.conf.get(UI$.MODULE$.UI_REVERSE_PROXY()));
        String workerUrlRef = UIUtils$.MODULE$.makeHref(reverseProxy, this.driverId(), this.workerWebUiUrl());
        builder.environment().put("SPARK_DRIVER_LOG_URL_STDOUT", new StringBuilder(34).append(workerUrlRef).append("/logPage/?driverId=").append(this.driverId()).append("&logType=stdout").toString());
        builder.environment().put("SPARK_DRIVER_LOG_URL_STDERR", new StringBuilder(34).append(workerUrlRef).append("/logPage/?driverId=").append(this.driverId()).append("&logType=stderr").toString());
        return this.runDriver(builder, driverDir, this.driverDesc().supervise());
    }

    private int runDriver(ProcessBuilder builder, File baseDir, boolean supervise) {
        builder.directory(baseDir);
        return this.runCommandWithRetry(ProcessBuilderLike$.MODULE$.apply(builder), (Function1<Process, BoxedUnit>)(Function1 & Serializable & scala.Serializable)process -> {
            this.initialize$1(process, baseDir, builder);
            return BoxedUnit.UNIT;
        }, supervise);
    }

    public int runCommandWithRetry(ProcessBuilderLike command, Function1<Process, BoxedUnit> initialize, boolean supervise) {
        IntRef exitCode = IntRef.create((int)-1);
        IntRef waitSeconds = IntRef.create((int)1);
        int successfulRunDuration = 5;
        boolean keepTrying = !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
        String redactedCommand = Utils$.MODULE$.redactCommandLineArgs(this.conf, command.command()).mkString("\"", "\" \"", "\"");
        while (keepTrying) {
            block7: {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch Command: ").append(redactedCommand).toString());
                DriverRunner driverRunner = this;
                synchronized (driverRunner) {
                    int n;
                    block6: {
                        if (this.org$apache$spark$deploy$worker$DriverRunner$$killed()) {
                            n = exitCode.elem;
                            break block6;
                        }
                        this.process_$eq((Option<Process>)new Some((Object)command.start()));
                        initialize.apply(this.process().get());
                        break block7;
                    }
                    return n;
                }
            }
            long processStart = this.clock().getTimeMillis();
            exitCode.elem = ((Process)this.process().get()).waitFor();
            keepTrying = supervise && exitCode.elem != 0 && !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
            if (!keepTrying) continue;
            if (this.clock().getTimeMillis() - processStart > (long)successfulRunDuration * 1000L) {
                waitSeconds.elem = 1;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Command exited with status ").append(exitCode$1.elem).append(", re-launching after ").append(waitSeconds$1.elem).append(" s.").toString());
            this.sleeper().sleep(waitSeconds.elem);
            waitSeconds.elem *= 2;
        }
        return exitCode.elem;
    }

    public static final /* synthetic */ void $anonfun$kill$2(DriverRunner $this, Process p) {
        Option<Object> exitCode = Utils$.MODULE$.terminateProcess(p, $this.driverTerminateTimeoutMs());
        if (exitCode.isEmpty()) {
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to terminate driver process: ").append(p).append(". This process will likely be orphaned.").toString());
            return;
        }
    }

    private final String substituteVariables$1(String argument, String localJarFilename$1) {
        String string = argument;
        if ("{{WORKER_URL}}".equals(string)) {
            return this.workerUrl();
        }
        if ("{{USER_JAR}}".equals(string)) {
            return localJarFilename$1;
        }
        return string;
    }

    private final void initialize$1(Process process, File baseDir$1, ProcessBuilder builder$1) {
        File stdout = new File(baseDir$1, "stdout");
        CommandUtils$.MODULE$.redirectStream(process.getInputStream(), stdout);
        File stderr = new File(baseDir$1, "stderr");
        String redactedCommand = Utils$.MODULE$.redactCommandLineArgs(this.conf, (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(builder$1.command()).asScala()).toSeq()).mkString("\"", "\" \"", "\"");
        String header = new StringOps(Predef$.MODULE$.augmentString("Launch Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{redactedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
        Files.append((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
        CommandUtils$.MODULE$.redirectStream(process.getErrorStream(), stderr);
    }

    public DriverRunner(SparkConf conf, String driverId, File workDir, File sparkHome, DriverDescription driverDesc, RpcEndpointRef worker, String workerUrl, String workerWebUiUrl, SecurityManager securityManager, scala.collection.immutable.Map<String, ResourceInformation> resources) {
        this.conf = conf;
        this.driverId = driverId;
        this.workDir = workDir;
        this.sparkHome = sparkHome;
        this.driverDesc = driverDesc;
        this.worker = worker;
        this.workerUrl = workerUrl;
        this.workerWebUiUrl = workerWebUiUrl;
        this.securityManager = securityManager;
        this.resources = resources;
        Logging.$init$(this);
        this.process = None$.MODULE$;
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = false;
        this.finalState = None$.MODULE$;
        this.finalException = None$.MODULE$;
        this.driverTerminateTimeoutMs = BoxesRunTime.unboxToLong((Object)conf.get(Worker$.MODULE$.WORKER_DRIVER_TERMINATE_TIMEOUT()));
        this.clock = new SystemClock();
        this.sleeper = new Sleeper(this){
            private final /* synthetic */ DriverRunner $outer;

            public void sleep(int seconds) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), seconds).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> {
                    Thread.sleep(1000L);
                    return !$this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed();
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$sleep$1(org.apache.spark.deploy.worker.DriverRunner$$anon$1 int )}, serializedLambda);
            }
        };
    }
}

