/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.SparkTranslationContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SparkStreamingTranslationContext
extends SparkTranslationContext {
    private final @UnknownKeyFor @NonNull @Initialized JavaStreamingContext streamingContext;
    private final @UnknownKeyFor @NonNull @Initialized Instant firstTimestamp;

    public SparkStreamingTranslationContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        super(jsc, options, jobInfo);
        Duration batchDuration = new Duration(options.getBatchIntervalMillis().longValue());
        this.streamingContext = new JavaStreamingContext(jsc, batchDuration);
        this.firstTimestamp = new Instant();
    }

    public @UnknownKeyFor @NonNull @Initialized JavaStreamingContext getStreamingContext() {
        return this.streamingContext;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getFirstTimestamp() {
        return this.firstTimestamp;
    }
}

