/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hop.core.compress.CompressionPlugin;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.gzip.GzipCompressionInputStream;
import org.apache.hop.core.compress.gzip.GzipCompressionOutputStream;

@CompressionPlugin(id="GZIP", name="GZip", description="GZIP compression")
public class GzipCompressionProvider
implements ICompressionProvider {
    @Override
    public GzipCompressionInputStream createInputStream(InputStream in) throws IOException {
        return new GzipCompressionInputStream(in, this);
    }

    @Override
    public boolean supportsInput() {
        return true;
    }

    @Override
    public GzipCompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new GzipCompressionOutputStream(out, this);
    }

    @Override
    public boolean supportsOutput() {
        return true;
    }

    @Override
    public String getDescription() {
        return "GZIP compression";
    }

    @Override
    public String getName() {
        return "GZip";
    }

    @Override
    public String getDefaultExtension() {
        return "gz";
    }
}

