/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CountingOutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQueryRowWriter<@UnknownKeyFor T>
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryRowWriter.class);
    private @UnknownKeyFor @NonNull @Initialized ResourceId resourceId;
    private @UnknownKeyFor @NonNull @Initialized WritableByteChannel channel;
    private @UnknownKeyFor @NonNull @Initialized CountingOutputStream out;
    private @UnknownKeyFor @NonNull @Initialized boolean isClosed = false;

    BigQueryRowWriter(@UnknownKeyFor @NonNull @Initialized String basename, @UnknownKeyFor @NonNull @Initialized String mimeType) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String uId = UUID.randomUUID().toString();
        this.resourceId = FileSystems.matchNewResource((String)(basename + uId), (boolean)false);
        LOG.info("Opening {} to {}.", (Object)this.getClass().getSimpleName(), (Object)this.resourceId);
        this.channel = FileSystems.create((ResourceId)this.resourceId, (String)mimeType);
        this.out = new CountingOutputStream(Channels.newOutputStream(this.channel));
    }

    protected @UnknownKeyFor @NonNull @Initialized OutputStream getOutputStream() {
        return this.out;
    }

    abstract void write(T var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    @UnknownKeyFor @NonNull @Initialized long getByteSize() {
        return this.out.getCount();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Already closed");
        this.isClosed = true;
        this.channel.close();
    }

    @UnknownKeyFor @NonNull @Initialized Result getResult() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"Not yet closed");
        return new Result(this.resourceId, this.out.getCount());
    }

    static final class Result {
        final @UnknownKeyFor @NonNull @Initialized ResourceId resourceId;
        final @UnknownKeyFor @NonNull @Initialized long byteSize;

        public Result(@UnknownKeyFor @NonNull @Initialized ResourceId resourceId, @UnknownKeyFor @NonNull @Initialized long byteSize) {
            this.resourceId = resourceId;
            this.byteSize = byteSize;
        }
    }
}

