/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.xsdvalidator;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Action(id="XSD_VALIDATOR", name="i18n::XSD_VALIDATOR.Name", description="i18n::XSD_VALIDATOR.Description", image="org/apache/hop/workflow/actions/xml/XSD.svg", categoryDescription="i18n::XSD_VALIDATOR.Category", keywords={"i18n::XsdValidator.keyword"}, documentationUrl="/workflow/actions/xsdvalidator.html")
public class XsdValidator
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = XsdValidator.class;
    public static final String ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION = "ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION";
    public static final String ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION_DEFAULT = "true";
    private static final String YES = "Y";
    public static final String SPECIFY_FILENAME = "filename";
    public static final String NO_NEED = "noneed";
    private String xsdSource;
    private String xmlfilename = null;
    private String xsdfilename = null;
    private boolean allowExternalEntities = Boolean.valueOf(System.getProperties().getProperty("ALLOW_EXTERNAL_ENTITIES_FOR_XSD_VALIDATION", "true"));

    public XsdValidator(String n) {
        super(n, "");
    }

    public XsdValidator() {
        this("");
    }

    public Object clone() {
        XsdValidator je = (XsdValidator)super.clone();
        return je;
    }

    public String getXml() {
        StringBuffer xml = new StringBuffer(50);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"xsdsource", (String)this.xsdSource));
        xml.append("      ").append(XmlHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        xml.append("      ").append(XmlHandler.addTagValue((String)"xsdfilename", (String)this.xsdfilename));
        xml.append("      ").append(XmlHandler.addTagValue((String)"allowExternalEntities", (boolean)this.allowExternalEntities));
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.xsdSource = XmlHandler.getTagValue((Node)entrynode, (String)"xsdsource");
            this.xmlfilename = XmlHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.xsdfilename = XmlHandler.getTagValue((Node)entrynode, (String)"xsdfilename");
            this.allowExternalEntities = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"allowExternalEntities"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load job entry of type 'xsdvalidator' from XML node", (Throwable)xe);
        }
    }

    public String getRealxmlfilename() {
        return this.resolve(this.getxmlFilename());
    }

    public String getRealxsdfilename() {
        return this.resolve(this.getxsdFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        FileObject xmlfile = null;
        FileObject xsdfile = null;
        this.validateNonNullFileName(this.xmlfilename, "ActionXSDValidator.XmlFileNotNull.Label", result);
        try {
            Schema schemaXSD;
            String realxmlfilename = this.getRealxmlfilename();
            xmlfile = this.getFile(realxmlfilename);
            SchemaFactory factorytXSDValidator1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (this.xsdSource.equals(SPECIFY_FILENAME)) {
                this.validateNonNullFileName(this.xsdfilename, "ActionXSDValidator.XsdFileNotNull.Label", result);
                String realXsdFileName = this.getRealxsdfilename();
                xsdfile = this.getFile(realXsdFileName);
                File xsdFile = new File(HopVfs.getFilename((FileObject)xsdfile));
                schemaXSD = factorytXSDValidator1.newSchema(xsdFile);
            } else {
                schemaXSD = factorytXSDValidator1.newSchema();
            }
            Validator xsdValidator = schemaXSD.newValidator();
            if (!this.isAllowExternalEntities()) {
                xsdValidator.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                xsdValidator.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xsdValidator.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                xsdValidator.setProperty("http://apache.org/xml/properties/internal/entity-resolver", xmlResourceIdentifier -> {
                    String message = BaseMessages.getString(PKG, (String)"ActionXSDValidator.Error.DisallowedDocType", (String[])new String[0]);
                    throw new IOException(message);
                });
            }
            File xmlfiletXSDValidator1 = new File(HopVfs.getFilename((FileObject)xmlfile));
            StreamSource sourcetXSDValidator1 = new StreamSource(xmlfiletXSDValidator1);
            xsdValidator.validate(sourcetXSDValidator1);
            result.setResult(true);
        }
        catch (SAXException ex) {
            this.logError("Error :" + ex.getMessage());
            result.setNrErrors(1L);
        }
        catch (IOException | HopFileException e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionXSDValidator.ErrorXSD2.Label", (String[])new String[0]) + e.getMessage());
            result.setNrErrors(1L);
        }
        finally {
            try {
                if (xmlfile != null) {
                    xmlfile.close();
                }
                if (xsdfile != null) {
                    xsdfile.close();
                }
            }
            catch (IOException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionXSDValidator.ErrorCloseFile.Label", (String[])new String[0]) + e.getMessage());
                result.setNrErrors(1L);
            }
        }
        return result;
    }

    private void validateNonNullFileName(String filename, String key, Result result) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            this.logError(BaseMessages.getString(PKG, (String)key, (String[])new String[0]));
            result.setNrErrors(1L);
        }
    }

    private FileObject getFile(String filename) throws HopFileException, FileSystemException {
        FileObject fileObject = HopVfs.getFileObject((String)filename);
        if (!fileObject.exists()) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionXSDValidator.FileDoesNotExist1.Label", (String[])new String[0]) + filename + BaseMessages.getString(PKG, (String)"ActionXSDValidator.FileDoesNotExist2.Label", (String[])new String[0]));
        }
        return fileObject;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public void setxsdFilename(String filename) {
        this.xsdfilename = filename;
    }

    public String getxsdFilename() {
        return this.xsdfilename;
    }

    public boolean isAllowExternalEntities() {
        return this.allowExternalEntities;
    }

    public String getXsdSource() {
        return this.xsdSource;
    }

    public void setXsdSource(String xsdSource) {
        this.xsdSource = xsdSource;
    }

    public void setAllowExternalEntities(boolean allowExternalEntities) {
        this.allowExternalEntities = allowExternalEntities;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.xsdfilename) && !Utils.isEmpty((CharSequence)this.xmlfilename)) {
            String realXmlFileName = this.resolve(this.xmlfilename);
            String realXsdFileName = this.resolve(this.xsdfilename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta jobMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "xsdFilename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "xmlFilename", remarks, ctx);
    }
}

