/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncResultSetImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class AbstractReadContext
implements ReadContext,
AbstractResultSet.Listener,
SessionImpl.SessionTransaction {
    final Object lock = new Object();
    final SessionImpl session;
    final SpannerRpc rpc;
    final ExecutorProvider executorProvider;
    Span span;
    private final int defaultPrefetchChunks;
    private final ExecuteSqlRequest.QueryOptions defaultQueryOptions;
    @GuardedBy(value="lock")
    private boolean isValid = true;
    @GuardedBy(value="lock")
    protected boolean isClosed = false;
    private AtomicLong seqNo = new AtomicLong();
    private static final int MAX_BUFFERED_CHUNKS = 512;
    protected static final String NO_TRANSACTION_RETURNED_MSG = "The statement did not return a transaction even though one was requested";

    private static void assertTimestampAvailable(boolean available) {
        Preconditions.checkState((boolean)available, (Object)"Method can only be called after read has returned data or finished");
    }

    AbstractReadContext(Builder<?, ?> builder) {
        this.session = ((Builder)builder).session;
        this.rpc = ((Builder)builder).rpc;
        this.defaultPrefetchChunks = ((Builder)builder).defaultPrefetchChunks;
        this.defaultQueryOptions = ((Builder)builder).defaultQueryOptions;
        this.span = ((Builder)builder).span;
        this.executorProvider = ((Builder)builder).executorProvider;
    }

    @Override
    public void setSpan(Span span) {
        this.span = span;
    }

    long getSeqNo() {
        return this.seqNo.incrementAndGet();
    }

    protected boolean isRouteToLeader() {
        return false;
    }

    @Override
    public final ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return this.readInternal(table, null, keys, columns, options);
    }

    @Override
    public ListenableAsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        Options readOptions = Options.fromReadOptions(options);
        int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
        return new AsyncResultSetImpl(this.executorProvider, this.readInternal(table, null, keys, columns, options), bufferRows);
    }

    @Override
    public final ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return this.readInternal(table, (String)Preconditions.checkNotNull((Object)index), keys, columns, options);
    }

    @Override
    public ListenableAsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        Options readOptions = Options.fromReadOptions(options);
        int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
        return new AsyncResultSetImpl(this.executorProvider, this.readInternal(table, (String)Preconditions.checkNotNull((Object)index), keys, columns, options), bufferRows);
    }

    @Override
    @Nullable
    public final Struct readRow(String table, Key key, Iterable<String> columns) {
        try (ResultSet resultSet = this.read(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
            Struct struct = this.consumeSingleRow(resultSet);
            return struct;
        }
    }

    @Override
    public final ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
        try (AsyncResultSet resultSet = this.readAsync(table, KeySet.singleKey(key), (Iterable)columns, new Options.ReadOption[0]);){
            ApiFuture<Struct> apiFuture = AbstractReadContext.consumeSingleRowAsync(resultSet);
            return apiFuture;
        }
    }

    @Override
    @Nullable
    public final Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
        try (ResultSet resultSet = this.readUsingIndex(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
            Struct struct = this.consumeSingleRow(resultSet);
            return struct;
        }
    }

    @Override
    public final ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
        try (AsyncResultSet resultSet = this.readUsingIndexAsync(table, index, KeySet.singleKey(key), (Iterable)columns, new Options.ReadOption[0]);){
            ApiFuture<Struct> apiFuture = AbstractReadContext.consumeSingleRowAsync(resultSet);
            return apiFuture;
        }
    }

    @Override
    public final ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
        return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.NORMAL, options);
    }

    @Override
    public ListenableAsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
        Options readOptions = Options.fromQueryOptions(options);
        int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
        return new AsyncResultSetImpl(this.executorProvider, this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.NORMAL, options), bufferRows);
    }

    @Override
    public final ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode readContextQueryMode) {
        switch (readContextQueryMode) {
            case PROFILE: {
                return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.PROFILE, new Options.QueryOption[0]);
            }
            case PLAN: {
                return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.PLAN, new Options.QueryOption[0]);
            }
        }
        throw new IllegalStateException("Unknown value for QueryAnalyzeMode : " + (Object)((Object)readContextQueryMode));
    }

    private ResultSet executeQueryInternal(Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options.QueryOption ... options) {
        Options queryOptions = Options.fromQueryOptions(options);
        return this.executeQueryInternalWithOptions(statement, queryMode, queryOptions, null);
    }

    @VisibleForTesting
    ExecuteSqlRequest.QueryOptions buildQueryOptions(ExecuteSqlRequest.QueryOptions requestOptions) {
        if (this.defaultQueryOptions.equals((Object)ExecuteSqlRequest.QueryOptions.getDefaultInstance()) && requestOptions == null) {
            return ExecuteSqlRequest.QueryOptions.getDefaultInstance();
        }
        ExecuteSqlRequest.QueryOptions.Builder builder = this.defaultQueryOptions.toBuilder();
        if (requestOptions != null) {
            builder.mergeFrom(requestOptions);
        }
        return builder.build();
    }

    RequestOptions buildRequestOptions(Options options) {
        RequestOptions.Builder builder = RequestOptions.newBuilder();
        if (options.hasPriority()) {
            builder.setPriority(options.priority());
        }
        if (options.hasTag()) {
            builder.setRequestTag(options.tag());
        }
        if (this.getTransactionTag() != null) {
            builder.setTransactionTag(this.getTransactionTag());
        }
        return builder.build();
    }

    ExecuteSqlRequest.Builder getExecuteSqlRequestBuilder(Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options options, boolean withTransactionSelector) {
        TransactionSelector selector;
        ExecuteSqlRequest.Builder builder = ExecuteSqlRequest.newBuilder().setSql(statement.getSql()).setQueryMode(queryMode).setSession(this.session.getName());
        Map<String, Value> stmtParameters = statement.getParameters();
        if (!stmtParameters.isEmpty()) {
            Struct.Builder paramsBuilder = builder.getParamsBuilder();
            for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                paramsBuilder.putFields(param.getKey(), Value.toProto(param.getValue()));
                if (param.getValue() == null || param.getValue().getType() == null) continue;
                builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
            }
        }
        if (withTransactionSelector && (selector = this.getTransactionSelector()) != null) {
            builder.setTransaction(selector);
        }
        if (options.hasDataBoostEnabled()) {
            builder.setDataBoostEnabled(options.dataBoostEnabled().booleanValue());
        }
        builder.setSeqno(this.getSeqNo());
        builder.setQueryOptions(this.buildQueryOptions(statement.getQueryOptions()));
        builder.setRequestOptions(this.buildRequestOptions(options));
        return builder;
    }

    ExecuteBatchDmlRequest.Builder getExecuteBatchDmlRequestBuilder(Iterable<Statement> statements, Options options) {
        ExecuteBatchDmlRequest.Builder builder = ExecuteBatchDmlRequest.newBuilder().setSession(this.session.getName());
        int idx = 0;
        for (Statement stmt : statements) {
            builder.addStatementsBuilder();
            builder.getStatementsBuilder(idx).setSql(stmt.getSql());
            Map<String, Value> stmtParameters = stmt.getParameters();
            if (!stmtParameters.isEmpty()) {
                Struct.Builder paramsBuilder = builder.getStatementsBuilder(idx).getParamsBuilder();
                for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                    paramsBuilder.putFields(param.getKey(), Value.toProto(param.getValue()));
                    if (param.getValue() == null || param.getValue().getType() == null) continue;
                    builder.getStatementsBuilder(idx).putParamTypes(param.getKey(), param.getValue().getType().toProto());
                }
            }
            ++idx;
        }
        TransactionSelector selector = this.getTransactionSelector();
        if (selector != null) {
            builder.setTransaction(selector);
        }
        builder.setSeqno(this.getSeqNo());
        builder.setRequestOptions(this.buildRequestOptions(options));
        return builder;
    }

    ResultSet executeQueryInternalWithOptions(final Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options options, final ByteString partitionToken) {
        this.beforeReadOrQuery();
        final int prefetchChunks = options.hasPrefetchChunks() ? options.prefetchChunks() : this.defaultPrefetchChunks;
        final ExecuteSqlRequest.Builder request = this.getExecuteSqlRequestBuilder(statement, queryMode, options, false);
        AbstractResultSet.ResumableStreamIterator stream = new AbstractResultSet.ResumableStreamIterator(512, "CloudSpannerOperation.ExecuteStreamingQuery", this.span){

            @Override
            AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                AbstractResultSet.GrpcStreamIterator stream = new AbstractResultSet.GrpcStreamIterator(statement, prefetchChunks);
                if (partitionToken != null) {
                    request.setPartitionToken(partitionToken);
                }
                TransactionSelector selector = null;
                if (resumeToken != null) {
                    request.setResumeToken(resumeToken);
                    selector = AbstractReadContext.this.getTransactionSelector();
                } else if (!request.hasTransaction()) {
                    selector = AbstractReadContext.this.getTransactionSelector();
                }
                if (selector != null) {
                    request.setTransaction(selector);
                }
                SpannerRpc.StreamingCall call = AbstractReadContext.this.rpc.executeQuery(request.build(), stream.consumer(), AbstractReadContext.this.session.getOptions(), AbstractReadContext.this.isRouteToLeader());
                call.request(prefetchChunks);
                stream.setCall(call, request.getTransaction().hasBegin());
                return stream;
            }
        };
        return new AbstractResultSet.GrpcResultSet(stream, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beforeReadOrQuery() {
        Object object = this.lock;
        synchronized (object) {
            this.beforeReadOrQueryLocked();
        }
    }

    @GuardedBy(value="lock")
    void beforeReadOrQueryLocked() {
        Preconditions.checkState((boolean)this.isValid, (Object)"Context has been invalidated by a new operation on the session");
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Context has been closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.isValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.span.end(TraceUtil.END_SPAN_OPTIONS);
        Object object = this.lock;
        synchronized (object) {
            this.isClosed = true;
        }
    }

    @Nullable
    abstract TransactionSelector getTransactionSelector();

    @Nullable
    String getTransactionTag() {
        return null;
    }

    @Override
    public void onTransactionMetadata(Transaction transaction, boolean shouldIncludeId) {
    }

    @Override
    public SpannerException onError(SpannerException e, boolean withBeginTransaction) {
        return e;
    }

    @Override
    public void onDone(boolean withBeginTransaction) {
    }

    private ResultSet readInternal(String table, @Nullable String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        Options readOptions = Options.fromReadOptions(options);
        return this.readInternalWithOptions(table, index, keys, columns, readOptions, null);
    }

    ResultSet readInternalWithOptions(String table, @Nullable String index, KeySet keys, Iterable<String> columns, final Options readOptions, ByteString partitionToken) {
        this.beforeReadOrQuery();
        final ReadRequest.Builder builder = ReadRequest.newBuilder().setSession(this.session.getName()).setTable((String)Preconditions.checkNotNull((Object)table)).addAllColumns(columns);
        if (readOptions.hasLimit()) {
            builder.setLimit(readOptions.limit());
        }
        keys.appendToProto(builder.getKeySetBuilder());
        if (index != null) {
            builder.setIndex(index);
        }
        if (partitionToken != null) {
            builder.setPartitionToken(partitionToken);
        }
        if (readOptions.hasDataBoostEnabled()) {
            builder.setDataBoostEnabled(readOptions.dataBoostEnabled().booleanValue());
        }
        final int prefetchChunks = readOptions.hasPrefetchChunks() ? readOptions.prefetchChunks() : this.defaultPrefetchChunks;
        AbstractResultSet.ResumableStreamIterator stream = new AbstractResultSet.ResumableStreamIterator(512, "CloudSpannerOperation.ExecuteStreamingRead", this.span){

            @Override
            AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                AbstractResultSet.GrpcStreamIterator stream = new AbstractResultSet.GrpcStreamIterator(prefetchChunks);
                TransactionSelector selector = null;
                if (resumeToken != null) {
                    builder.setResumeToken(resumeToken);
                    selector = AbstractReadContext.this.getTransactionSelector();
                } else if (!builder.hasTransaction()) {
                    selector = AbstractReadContext.this.getTransactionSelector();
                }
                if (selector != null) {
                    builder.setTransaction(selector);
                }
                builder.setRequestOptions(AbstractReadContext.this.buildRequestOptions(readOptions));
                SpannerRpc.StreamingCall call = AbstractReadContext.this.rpc.read(builder.build(), stream.consumer(), AbstractReadContext.this.session.getOptions(), AbstractReadContext.this.isRouteToLeader());
                call.request(prefetchChunks);
                stream.setCall(call, builder.getTransaction().hasBegin());
                return stream;
            }
        };
        return new AbstractResultSet.GrpcResultSet(stream, this);
    }

    private Struct consumeSingleRow(ResultSet resultSet) {
        if (!resultSet.next()) {
            return null;
        }
        Struct row = resultSet.getCurrentRowAsStruct();
        if (resultSet.next()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Multiple rows returned for single key");
        }
        return row;
    }

    static ApiFuture<Struct> consumeSingleRowAsync(AsyncResultSet resultSet) {
        final SettableApiFuture result = SettableApiFuture.create();
        final SettableApiFuture row = SettableApiFuture.create();
        ApiFutures.addCallback(resultSet.setCallback(MoreExecutors.directExecutor(), ConsumeSingleRowCallback.create((SettableApiFuture<Struct>)row)), (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(Void input) {
                try {
                    result.set((Object)((Struct)row.get()));
                }
                catch (Throwable t) {
                    result.setException(t);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    static abstract class Builder<B extends Builder<?, T>, T extends AbstractReadContext> {
        private SessionImpl session;
        private SpannerRpc rpc;
        private Span span = Tracing.getTracer().getCurrentSpan();
        private int defaultPrefetchChunks = 4;
        private ExecuteSqlRequest.QueryOptions defaultQueryOptions = SpannerOptions.Builder.DEFAULT_QUERY_OPTIONS;
        private ExecutorProvider executorProvider;

        Builder() {
        }

        B self() {
            return (B)this;
        }

        B setSession(SessionImpl session) {
            this.session = session;
            return this.self();
        }

        B setRpc(SpannerRpc rpc) {
            this.rpc = rpc;
            return this.self();
        }

        B setSpan(Span span) {
            this.span = span;
            return this.self();
        }

        B setDefaultPrefetchChunks(int defaultPrefetchChunks) {
            this.defaultPrefetchChunks = defaultPrefetchChunks;
            return this.self();
        }

        B setDefaultQueryOptions(ExecuteSqlRequest.QueryOptions defaultQueryOptions) {
            this.defaultQueryOptions = defaultQueryOptions;
            return this.self();
        }

        B setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this.self();
        }

        abstract T build();
    }

    static interface ListenableAsyncResultSet
    extends AsyncResultSet {
        public void addListener(Runnable var1);

        public void removeListener(Runnable var1);
    }

    private static class ConsumeSingleRowCallback
    implements AsyncResultSet.ReadyCallback {
        private final SettableApiFuture<Struct> result;
        private Struct row;

        static ConsumeSingleRowCallback create(SettableApiFuture<Struct> result) {
            return new ConsumeSingleRowCallback(result);
        }

        private ConsumeSingleRowCallback(SettableApiFuture<Struct> result) {
            this.result = result;
        }

        @Override
        public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
            try {
                switch (resultSet.tryNext()) {
                    case DONE: {
                        this.result.set((Object)this.row);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                    case NOT_READY: {
                        return AsyncResultSet.CallbackResponse.CONTINUE;
                    }
                    case OK: {
                        if (this.row != null) {
                            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Multiple rows returned for single key");
                        }
                        this.row = resultSet.getCurrentRowAsStruct();
                        return AsyncResultSet.CallbackResponse.CONTINUE;
                    }
                }
                throw new IllegalStateException();
            }
            catch (Throwable t) {
                this.result.setException(t);
                return AsyncResultSet.CallbackResponse.DONE;
            }
        }
    }

    static class MultiUseReadOnlyTransaction
    extends AbstractReadContext
    implements ReadOnlyTransaction {
        private TimestampBound bound;
        private final Object txnLock = new Object();
        @GuardedBy(value="txnLock")
        private Timestamp timestamp;
        @GuardedBy(value="txnLock")
        private ByteString transactionId;

        static Builder newBuilder() {
            return new Builder();
        }

        MultiUseReadOnlyTransaction(Builder builder) {
            super(builder);
            Preconditions.checkArgument((!(builder.bound != null && builder.transactionId != null || builder.bound == null && builder.transactionId == null) ? 1 : 0) != 0, (Object)"Either TimestampBound or TransactionId must be specified");
            if (builder.bound != null) {
                Preconditions.checkArgument((builder.bound.getMode() != TimestampBound.Mode.MAX_STALENESS && builder.bound.getMode() != TimestampBound.Mode.MIN_READ_TIMESTAMP ? 1 : 0) != 0, (String)"Bounded staleness mode %s is not supported for multi-use read-only transactions. Create a single-use read or read-only transaction instead.", (Object)((Object)builder.bound.getMode()));
                this.bound = builder.bound;
            } else {
                this.timestamp = builder.timestamp;
                this.transactionId = builder.transactionId;
            }
        }

        @Override
        protected boolean isRouteToLeader() {
            return false;
        }

        @Override
        void beforeReadOrQuery() {
            super.beforeReadOrQuery();
            this.initTransaction();
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            TransactionSelector selector = TransactionSelector.newBuilder().setId(this.transactionId).build();
            return selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timestamp getReadTimestamp() {
            Object object = this.txnLock;
            synchronized (object) {
                AbstractReadContext.assertTimestampAvailable(this.timestamp != null);
                return this.timestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteString getTransactionId() {
            Object object = this.txnLock;
            synchronized (object) {
                return this.transactionId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initTransaction() {
            SessionImpl.throwIfTransactionsPending();
            Object object = this.txnLock;
            synchronized (object) {
                if (this.transactionId != null) {
                    return;
                }
                this.span.addAnnotation("Creating Transaction");
                try {
                    TransactionOptions.Builder options = TransactionOptions.newBuilder();
                    this.bound.applyToBuilder(options.getReadOnlyBuilder()).setReturnReadTimestamp(true);
                    BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.session.getName()).setOptions(options).build();
                    Transaction transaction = this.rpc.beginTransaction(request, this.session.getOptions(), this.isRouteToLeader());
                    if (!transaction.hasReadTimestamp()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.read_timestamp metadata field");
                    }
                    if (transaction.getId().isEmpty()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.id metadata field");
                    }
                    try {
                        this.timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)transaction.getReadTimestamp());
                    }
                    catch (IllegalArgumentException e) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Bad value in transaction.read_timestamp metadata field", e);
                    }
                    this.transactionId = transaction.getId();
                    this.span.addAnnotation("Transaction Creation Done", TraceUtil.getTransactionAnnotations(transaction));
                }
                catch (SpannerException e) {
                    this.span.addAnnotation("Transaction Creation Failed", TraceUtil.getExceptionAnnotations(e));
                    throw e;
                }
            }
        }

        static class Builder
        extends com.google.cloud.spanner.AbstractReadContext$Builder<Builder, MultiUseReadOnlyTransaction> {
            private TimestampBound bound;
            private Timestamp timestamp;
            private ByteString transactionId;

            private Builder() {
            }

            Builder setTimestampBound(TimestampBound bound) {
                this.bound = bound;
                return this;
            }

            Builder setTimestamp(Timestamp timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            Builder setTransactionId(ByteString transactionId) {
                this.transactionId = transactionId;
                return this;
            }

            @Override
            MultiUseReadOnlyTransaction build() {
                return new MultiUseReadOnlyTransaction(this);
            }
        }
    }

    static class SingleUseReadOnlyTransaction
    extends SingleReadContext
    implements ReadOnlyTransaction {
        @GuardedBy(value="lock")
        private Timestamp timestamp;

        private SingleUseReadOnlyTransaction(SingleReadContext.Builder builder) {
            super(builder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timestamp getReadTimestamp() {
            Object object = this.lock;
            synchronized (object) {
                AbstractReadContext.assertTimestampAvailable(this.timestamp != null);
                return this.timestamp;
            }
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            TransactionOptions.Builder options = TransactionOptions.newBuilder();
            this.bound.applyToBuilder(options.getReadOnlyBuilder()).setReturnReadTimestamp(true);
            return TransactionSelector.newBuilder().setSingleUse(options).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransactionMetadata(Transaction transaction, boolean shouldIncludeId) {
            Object object = this.lock;
            synchronized (object) {
                if (!transaction.hasReadTimestamp()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.read_timestamp metadata field");
                }
                try {
                    this.timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)transaction.getReadTimestamp());
                }
                catch (IllegalArgumentException e) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Bad value in transaction.read_timestamp metadata field", e);
                }
            }
        }
    }

    static class SingleReadContext
    extends AbstractReadContext {
        final TimestampBound bound;
        @GuardedBy(value="lock")
        private boolean used;

        static Builder newBuilder() {
            return new Builder();
        }

        private SingleReadContext(Builder builder) {
            super(builder);
            this.bound = builder.bound;
        }

        @Override
        protected boolean isRouteToLeader() {
            return false;
        }

        @Override
        @GuardedBy(value="lock")
        void beforeReadOrQueryLocked() {
            super.beforeReadOrQueryLocked();
            Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"Cannot use a single-read ReadContext for multiple reads");
            this.used = true;
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            if (this.bound.getMode() == TimestampBound.Mode.STRONG) {
                return null;
            }
            return TransactionSelector.newBuilder().setSingleUse(TransactionOptions.newBuilder().setReadOnly(this.bound.toProto())).build();
        }

        static class Builder
        extends com.google.cloud.spanner.AbstractReadContext$Builder<Builder, SingleReadContext> {
            private TimestampBound bound;

            private Builder() {
            }

            Builder setTimestampBound(TimestampBound bound) {
                this.bound = bound;
                return (Builder)this.self();
            }

            @Override
            SingleReadContext build() {
                return new SingleReadContext(this);
            }

            SingleUseReadOnlyTransaction buildSingleUseReadOnlyTransaction() {
                return new SingleUseReadOnlyTransaction(this);
            }
        }
    }
}

