/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.math.BigDecimal;
import java.util.List;

class ReplaceableForwardingResultSet
implements ResultSet {
    private ResultSet delegate;
    private boolean closed;

    ReplaceableForwardingResultSet(ResultSet delegate) {
        this.delegate = (ResultSet)Preconditions.checkNotNull((Object)delegate);
    }

    void replaceDelegate(ResultSet delegate) {
        Preconditions.checkNotNull((Object)delegate);
        this.checkClosed();
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.delegate = delegate;
    }

    private void checkClosed() {
        if (this.closed) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "This ResultSet is closed");
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean next() throws SpannerException {
        this.checkClosed();
        return this.delegate.next();
    }

    @Override
    public Struct getCurrentRowAsStruct() {
        this.checkClosed();
        return this.delegate.getCurrentRowAsStruct();
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
        this.closed = true;
    }

    @Override
    public ResultSetStats getStats() {
        this.checkClosed();
        return this.delegate.getStats();
    }

    @Override
    public ResultSetMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public Type getType() {
        this.checkClosed();
        return this.delegate.getType();
    }

    @Override
    public int getColumnCount() {
        this.checkClosed();
        return this.delegate.getColumnCount();
    }

    @Override
    public int getColumnIndex(String columnName) {
        this.checkClosed();
        return this.delegate.getColumnIndex(columnName);
    }

    @Override
    public Type getColumnType(int columnIndex) {
        this.checkClosed();
        return this.delegate.getColumnType(columnIndex);
    }

    @Override
    public Type getColumnType(String columnName) {
        this.checkClosed();
        return this.delegate.getColumnType(columnName);
    }

    @Override
    public boolean isNull(int columnIndex) {
        this.checkClosed();
        return this.delegate.isNull(columnIndex);
    }

    @Override
    public boolean isNull(String columnName) {
        this.checkClosed();
        return this.delegate.isNull(columnName);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) {
        this.checkClosed();
        return this.delegate.getBoolean(columnName);
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkClosed();
        return this.delegate.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnName) {
        this.checkClosed();
        return this.delegate.getLong(columnName);
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkClosed();
        return this.delegate.getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnName) {
        this.checkClosed();
        return this.delegate.getDouble(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        this.checkClosed();
        return this.delegate.getBigDecimal(columnName);
    }

    @Override
    public String getString(int columnIndex) {
        this.checkClosed();
        return this.delegate.getString(columnIndex);
    }

    @Override
    public String getString(String columnName) {
        this.checkClosed();
        return this.delegate.getString(columnName);
    }

    @Override
    public String getJson(int columnIndex) {
        this.checkClosed();
        return this.delegate.getJson(columnIndex);
    }

    @Override
    public String getJson(String columnName) {
        this.checkClosed();
        return this.delegate.getJson(columnName);
    }

    @Override
    public String getPgJsonb(int columnIndex) {
        this.checkClosed();
        return this.delegate.getPgJsonb(columnIndex);
    }

    @Override
    public String getPgJsonb(String columnName) {
        this.checkClosed();
        return this.delegate.getPgJsonb(columnName);
    }

    @Override
    public ByteArray getBytes(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBytes(columnIndex);
    }

    @Override
    public ByteArray getBytes(String columnName) {
        this.checkClosed();
        return this.delegate.getBytes(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        this.checkClosed();
        return this.delegate.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) {
        this.checkClosed();
        return this.delegate.getTimestamp(columnName);
    }

    @Override
    public Date getDate(int columnIndex) {
        this.checkClosed();
        return this.delegate.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName) {
        this.checkClosed();
        return this.delegate.getDate(columnName);
    }

    @Override
    public Value getValue(int columnIndex) {
        this.checkClosed();
        return this.delegate.getValue(columnIndex);
    }

    @Override
    public Value getValue(String columnName) {
        this.checkClosed();
        return this.delegate.getValue(columnName);
    }

    @Override
    public boolean[] getBooleanArray(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBooleanArray(columnIndex);
    }

    @Override
    public boolean[] getBooleanArray(String columnName) {
        this.checkClosed();
        return this.delegate.getBooleanArray(columnName);
    }

    @Override
    public List<Boolean> getBooleanList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBooleanList(columnIndex);
    }

    @Override
    public List<Boolean> getBooleanList(String columnName) {
        this.checkClosed();
        return this.delegate.getBooleanList(columnName);
    }

    @Override
    public long[] getLongArray(int columnIndex) {
        this.checkClosed();
        return this.delegate.getLongArray(columnIndex);
    }

    @Override
    public long[] getLongArray(String columnName) {
        this.checkClosed();
        return this.delegate.getLongArray(columnName);
    }

    @Override
    public List<Long> getLongList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getLongList(columnIndex);
    }

    @Override
    public List<Long> getLongList(String columnName) {
        this.checkClosed();
        return this.delegate.getLongList(columnName);
    }

    @Override
    public double[] getDoubleArray(int columnIndex) {
        this.checkClosed();
        return this.delegate.getDoubleArray(columnIndex);
    }

    @Override
    public double[] getDoubleArray(String columnName) {
        this.checkClosed();
        return this.delegate.getDoubleArray(columnName);
    }

    @Override
    public List<Double> getDoubleList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getDoubleList(columnIndex);
    }

    @Override
    public List<Double> getDoubleList(String columnName) {
        this.checkClosed();
        return this.delegate.getDoubleList(columnName);
    }

    @Override
    public List<BigDecimal> getBigDecimalList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBigDecimalList(columnIndex);
    }

    @Override
    public List<BigDecimal> getBigDecimalList(String columnName) {
        this.checkClosed();
        return this.delegate.getBigDecimalList(columnName);
    }

    @Override
    public List<String> getStringList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getStringList(columnIndex);
    }

    @Override
    public List<String> getStringList(String columnName) {
        this.checkClosed();
        return this.delegate.getStringList(columnName);
    }

    @Override
    public List<String> getJsonList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getJsonList(columnIndex);
    }

    @Override
    public List<String> getJsonList(String columnName) {
        this.checkClosed();
        return this.delegate.getJsonList(columnName);
    }

    @Override
    public List<String> getPgJsonbList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getPgJsonbList(columnIndex);
    }

    @Override
    public List<String> getPgJsonbList(String columnName) {
        this.checkClosed();
        return this.delegate.getPgJsonbList(columnName);
    }

    @Override
    public List<ByteArray> getBytesList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getBytesList(columnIndex);
    }

    @Override
    public List<ByteArray> getBytesList(String columnName) {
        this.checkClosed();
        return this.delegate.getBytesList(columnName);
    }

    @Override
    public List<Timestamp> getTimestampList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getTimestampList(columnIndex);
    }

    @Override
    public List<Timestamp> getTimestampList(String columnName) {
        this.checkClosed();
        return this.delegate.getTimestampList(columnName);
    }

    @Override
    public List<Date> getDateList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getDateList(columnIndex);
    }

    @Override
    public List<Date> getDateList(String columnName) {
        this.checkClosed();
        return this.delegate.getDateList(columnName);
    }

    @Override
    public List<Struct> getStructList(int columnIndex) {
        this.checkClosed();
        return this.delegate.getStructList(columnIndex);
    }

    @Override
    public List<Struct> getStructList(String columnName) {
        this.checkClosed();
        return this.delegate.getStructList(columnName);
    }
}

