/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.veneer.repackaged.io.opencensus.contrib.resource.util;

import com.google.bigtable.veneer.repackaged.io.opencensus.resource.Resource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;

public class ContainerResource {
    public static final String TYPE = "container";
    public static final String NAME_KEY = "container.name";
    public static final String IMAGE_NAME_KEY = "container.image.name";
    public static final String IMAGE_TAG_KEY = "container.image.tag";

    public static Resource create(String name, String imageName, String imageTag) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(NAME_KEY, (String)Preconditions.checkNotNull((Object)name, (Object)"name"));
        labels.put(IMAGE_NAME_KEY, (String)Preconditions.checkNotNull((Object)imageName, (Object)"imageName"));
        labels.put(IMAGE_TAG_KEY, (String)Preconditions.checkNotNull((Object)imageTag, (Object)"imageTag"));
        return Resource.create(TYPE, labels);
    }

    static Resource detect() {
        return ContainerResource.create((String)MoreObjects.firstNonNull((Object)System.getenv("CONTAINER_NAME"), (Object)""), "", "");
    }

    private ContainerResource() {
    }
}

