/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.codec;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class CodecNotFoundException
extends DriverException {
    private final DataType cqlType;
    private final GenericType<?> javaType;

    public CodecNotFoundException(@Nullable DataType cqlType, @Nullable GenericType<?> javaType) {
        this(String.format("Codec not found for requested operation: [%s <-> %s]", cqlType, javaType), null, cqlType, javaType);
    }

    public CodecNotFoundException(@NonNull Throwable cause, @Nullable DataType cqlType, @Nullable GenericType<?> javaType) {
        this(String.format("Error while looking up codec for requested operation: [%s <-> %s]", cqlType, javaType), cause, cqlType, javaType);
    }

    private CodecNotFoundException(String msg, Throwable cause, DataType cqlType, GenericType<?> javaType) {
        super(msg, null, cause, true);
        this.cqlType = cqlType;
        this.javaType = javaType;
    }

    @Nullable
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Nullable
    public GenericType<?> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new CodecNotFoundException(this.getMessage(), this.getCause(), this.getCqlType(), this.getJavaType());
    }
}

