/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.memory;

import java.util.Collection;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.AllocationListener;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.AllocationReservation;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ArrowBuf;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferLedger;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferManager;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ForeignAllocation;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ForeignAllocationManager;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.rounding.DefaultRoundingPolicy;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.rounding.RoundingPolicy;

public interface BufferAllocator
extends AutoCloseable {
    public ArrowBuf buffer(long var1);

    public ArrowBuf buffer(long var1, BufferManager var3);

    public BufferAllocator getRoot();

    public BufferAllocator newChildAllocator(String var1, long var2, long var4);

    public BufferAllocator newChildAllocator(String var1, AllocationListener var2, long var3, long var5);

    @Override
    public void close();

    public long getAllocatedMemory();

    public long getLimit();

    public long getInitReservation();

    public void setLimit(long var1);

    public long getPeakMemoryAllocation();

    public long getHeadroom();

    public boolean forceAllocate(long var1);

    public void releaseBytes(long var1);

    public AllocationListener getListener();

    public BufferAllocator getParentAllocator();

    public Collection<BufferAllocator> getChildAllocators();

    public AllocationReservation newReservation();

    public ArrowBuf getEmpty();

    public String getName();

    public boolean isOverLimit();

    public String toVerboseString();

    public void assertOpen();

    default public RoundingPolicy getRoundingPolicy() {
        return DefaultRoundingPolicy.DEFAULT_ROUNDING_POLICY;
    }

    default public ArrowBuf wrapForeignAllocation(ForeignAllocation allocation) {
        try {
            this.forceAllocate(allocation.getSize());
            ForeignAllocationManager manager = new ForeignAllocationManager(this, allocation);
            BufferLedger ledger = manager.associate(this);
            ArrowBuf buf = new ArrowBuf(ledger, null, allocation.getSize(), allocation.memoryAddress());
            buf.writerIndex(allocation.getSize());
            return buf;
        }
        catch (Throwable t) {
            try {
                allocation.release0();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }
}

