/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class NSSet
extends NSObject {
    private final Set<NSObject> set;
    private boolean ordered = false;

    public NSSet() {
        this.set = new LinkedHashSet<NSObject>();
    }

    public NSSet(boolean ordered) {
        this.ordered = ordered;
        this.set = !ordered ? new LinkedHashSet<NSObject>() : new TreeSet<NSObject>();
    }

    public NSSet(NSObject ... objects) {
        this.set = new LinkedHashSet<NSObject>();
        this.set.addAll(Arrays.asList(objects));
    }

    public NSSet(boolean ordered, NSObject ... objects) {
        this.ordered = ordered;
        this.set = !ordered ? new LinkedHashSet<NSObject>() : new TreeSet<NSObject>();
        this.set.addAll(Arrays.asList(objects));
    }

    public synchronized void addObject(NSObject obj) {
        this.set.add(obj);
    }

    public synchronized void removeObject(NSObject obj) {
        this.set.remove(obj);
    }

    public synchronized NSObject[] allObjects() {
        return this.set.toArray(new NSObject[this.count()]);
    }

    public synchronized NSObject anyObject() {
        if (this.set.isEmpty()) {
            return null;
        }
        return this.set.iterator().next();
    }

    public boolean containsObject(NSObject obj) {
        return this.set.contains(obj);
    }

    public synchronized NSObject member(NSObject obj) {
        for (NSObject o : this.set) {
            if (!o.equals(obj)) continue;
            return o;
        }
        return null;
    }

    public synchronized boolean intersectsSet(NSSet otherSet) {
        for (NSObject o : this.set) {
            if (!otherSet.containsObject(o)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isSubsetOfSet(NSSet otherSet) {
        for (NSObject o : this.set) {
            if (otherSet.containsObject(o)) continue;
            return false;
        }
        return true;
    }

    public synchronized Iterator<NSObject> objectIterator() {
        return this.set.iterator();
    }

    Set<NSObject> getSet() {
        return this.set;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.set != null ? this.set.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NSSet other = (NSSet)obj;
        return Objects.equals(this.set, other.set);
    }

    public synchronized int count() {
        return this.set.size();
    }

    @Override
    public NSSet clone() {
        NSObject[] clonedSet = new NSObject[this.set.size()];
        int i = 0;
        for (NSObject element : this.set) {
            clonedSet[i++] = element != null ? element.clone() : null;
        }
        return new NSSet(this.ordered, clonedSet);
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<array>");
        xml.append(NSObject.NEWLINE);
        for (NSObject o : this.set) {
            o.toXML(xml, level + 1);
            xml.append(NSObject.NEWLINE);
        }
        this.indent(xml, level);
        xml.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        for (NSObject obj : this.set) {
            obj.assignIDs(out);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        if (this.ordered) {
            out.writeIntHeader(11, this.set.size());
        } else {
            out.writeIntHeader(12, this.set.size());
        }
        for (NSObject obj : this.set) {
            out.writeID(out.getID(obj));
        }
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        NSObject[] array = this.allObjects();
        ascii.append('(');
        int indexOfLastNewLine = ascii.lastIndexOf(NEWLINE);
        for (int i = 0; i < array.length; ++i) {
            Class<?> objClass = array[i].getClass();
            if ((objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) && indexOfLastNewLine != ascii.length()) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
                array[i].toASCII(ascii, level + 1);
            } else {
                if (i != 0) {
                    ascii.append(' ');
                }
                array[i].toASCII(ascii, 0);
            }
            if (i != array.length - 1) {
                ascii.append(',');
            }
            if (ascii.length() - indexOfLastNewLine <= 80) continue;
            ascii.append(NEWLINE);
            indexOfLastNewLine = ascii.length();
        }
        ascii.append(')');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        NSObject[] array = this.allObjects();
        ascii.append('(');
        int indexOfLastNewLine = ascii.lastIndexOf(NEWLINE);
        for (int i = 0; i < array.length; ++i) {
            Class<?> objClass = array[i].getClass();
            if ((objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) && indexOfLastNewLine != ascii.length()) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
                array[i].toASCIIGnuStep(ascii, level + 1);
            } else {
                if (i != 0) {
                    ascii.append(' ');
                }
                array[i].toASCIIGnuStep(ascii, 0);
            }
            if (i != array.length - 1) {
                ascii.append(',');
            }
            if (ascii.length() - indexOfLastNewLine <= 80) continue;
            ascii.append(NEWLINE);
            indexOfLastNewLine = ascii.length();
        }
        ascii.append(')');
    }
}

