/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.plugins.Plugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.ISearchableProvider;
import org.apache.hop.core.search.ISearchablesLocation;
import org.apache.hop.core.undo.ChangeAction;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.i18n.LanguageChoice;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.server.HopServer;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEventsHandler;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.HopDescribedVariablesDialog;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.core.widget.svg.SvgLabelFacade;
import org.apache.hop.ui.core.widget.svg.SvgLabelListener;
import org.apache.hop.ui.hopgui.HopGuiEnvironment;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.ISingletonProvider;
import org.apache.hop.ui.hopgui.ImplementationLoader;
import org.apache.hop.ui.hopgui.context.GuiContextUtil;
import org.apache.hop.ui.hopgui.context.IActionContextHandlersProvider;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.context.menu.MenuContextHandler;
import org.apache.hop.ui.hopgui.context.metadata.MetadataContext;
import org.apache.hop.ui.hopgui.delegates.HopGuiAuditDelegate;
import org.apache.hop.ui.hopgui.delegates.HopGuiContextDelegate;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileDelegate;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileRefreshDelegate;
import org.apache.hop.ui.hopgui.delegates.HopGuiUndoDelegate;
import org.apache.hop.ui.hopgui.dialog.AboutDialog;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IGraphSnapAlignDistribute;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.perspective.EmptyHopPerspective;
import org.apache.hop.ui.hopgui.perspective.HopPerspectiveManager;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePluginType;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.configuration.ConfigurationPerspective;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.hopgui.perspective.search.HopSearchPerspective;
import org.apache.hop.ui.hopgui.search.HopGuiSearchLocation;
import org.apache.hop.ui.hopgui.welcome.WelcomeDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="The main hop graphical user interface")
public class HopGui
implements IActionContextHandlersProvider,
ISearchableProvider,
IHasHopMetadataProvider {
    private static final Class<?> PKG = HopGui.class;
    public static final String ID_MAIN_MENU = "HopGui-Menu";
    public static final String ID_MAIN_MENU_FILE = "10000-menu-file";
    public static final String ID_MAIN_MENU_FILE_NEW = "10010-menu-file-new";
    public static final String ID_MAIN_MENU_FILE_OPEN = "10020-menu-file-open";
    public static final String ID_MAIN_MENU_FILE_OPEN_RECENT = "10025-menu-file-open-recent";
    public static final String ID_MAIN_MENU_FILE_SAVE = "10030-menu-file-save";
    public static final String ID_MAIN_MENU_FILE_SAVE_AS = "10040-menu-file-save-as";
    public static final String ID_MAIN_MENU_FILE_EXPORT_TO_SVG = "10050-menu-file-export-to-svg";
    public static final String ID_MAIN_MENU_FILE_CLOSE = "10090-menu-file-close";
    public static final String ID_MAIN_MENU_FILE_CLOSE_ALL = "10100-menu-file-close-all";
    public static final String ID_MAIN_MENU_FILE_EXIT = "10900-menu-file-exit";
    public static final String ID_MAIN_MENU_EDIT_PARENT_ID = "20000-menu-edit";
    public static final String ID_MAIN_MENU_EDIT_UNDO = "20010-menu-edit-undo";
    public static final String ID_MAIN_MENU_EDIT_REDO = "20020-menu-edit-redo";
    public static final String ID_MAIN_MENU_EDIT_SELECT_ALL = "20050-menu-edit-select-all";
    public static final String ID_MAIN_MENU_EDIT_UNSELECT_ALL = "20060-menu-edit-unselect-all";
    public static final String ID_MAIN_MENU_EDIT_FIND = "20070-menu-edit-find";
    public static final String ID_MAIN_MENU_EDIT_COPY = "20080-menu-edit-copy";
    public static final String ID_MAIN_MENU_EDIT_PASTE = "20090-menu-edit-paste";
    public static final String ID_MAIN_MENU_EDIT_CUT = "20100-menu-edit-cut";
    public static final String ID_MAIN_MENU_EDIT_DELETE = "20110-menu-edit-delete";
    public static final String ID_MAIN_MENU_EDIT_SNAP_TO_GRID = "20200-menu-edit-snap-to-grid";
    public static final String ID_MAIN_MENU_EDIT_ALIGN_LEFT = "20210-menu-edit-align-left";
    public static final String ID_MAIN_MENU_EDIT_ALIGN_RIGHT = "20220-menu-edit-align-right";
    public static final String ID_MAIN_MENU_EDIT_ALIGN_TOP = "20230-menu-edit-align-top";
    public static final String ID_MAIN_MENU_EDIT_ALIGN_BOTTOM = "20240-menu-edit-align-bottom";
    public static final String ID_MAIN_MENU_EDIT_DISTRIBUTE_HORIZONTAL = "20300-menu-edit-distribute-horizontal";
    public static final String ID_MAIN_MENU_EDIT_DISTRIBUTE_VERTICAL = "20320-menu-edit-distribute-vertical";
    public static final String ID_MAIN_MENU_EDIT_NAV_PREV = "20400-menu-edit-nav-previous";
    public static final String ID_MAIN_MENU_EDIT_NAV_NEXT = "20410-menu-edit-nav-next";
    public static final String ID_MAIN_MENU_RUN_PARENT_ID = "30000-menu-run";
    public static final String ID_MAIN_MENU_RUN_START = "30010-menu-run-execute";
    public static final String ID_MAIN_MENU_RUN_PAUSE = "30030-menu-run-pause";
    public static final String ID_MAIN_MENU_RUN_RESUME = "30035-menu-run-resume";
    public static final String ID_MAIN_MENU_RUN_STOP = "30040-menu-run-stop";
    public static final String ID_MAIN_MENU_RUN_PREVIEW = "30050-menu-run-preview";
    public static final String ID_MAIN_MENU_RUN_DEBUG = "30060-menu-run-debug";
    public static final String ID_MAIN_MENU_TOOLS_PARENT_ID = "40000-menu-tools";
    public static final String ID_MAIN_MENU_TOOLS_DATABASE_CLEAR_CACHE = "40030-menu-tools-database-clearcache";
    public static final String ID_MAIN_MENU_HELP_PARENT_ID = "90000-menu-help";
    public static final String ID_MAIN_MENU_HELP_ABOUT = "90009-menu-help-about";
    public static final String ID_MAIN_TOOLBAR = "HopGui-Toolbar";
    public static final String ID_MAIN_TOOLBAR_MENU = "toolbar-10000-menu";
    public static final String ID_MAIN_TOOLBAR_NEW = "toolbar-10010-new";
    public static final String ID_MAIN_TOOLBAR_OPEN = "toolbar-10020-open";
    public static final String ID_MAIN_TOOLBAR_SAVE = "toolbar-10040-save";
    public static final String ID_MAIN_TOOLBAR_SAVE_AS = "toolbar-10050-save-as";
    public static final String GUI_PLUGIN_PERSPECTIVES_PARENT_ID = "HopGui-Perspectives";
    public static final String DEFAULT_HOP_GUI_NAMESPACE = "hop-gui";
    public boolean firstShowing = true;
    private static final String UNDO_UNAVAILABLE = BaseMessages.getString(PKG, (String)"HopGui.Menu.Undo.NotAvailable", (String[])new String[0]);
    private static final String REDO_UNAVAILABLE = BaseMessages.getString(PKG, (String)"HopGui.Menu.Redo.NotAvailable", (String[])new String[0]);
    public static final String APP_NAME = "Hop";
    private String id;
    private MultiMetadataProvider metadataProvider;
    private HopGuiEventsHandler eventsHandler;
    private ILoggingObject loggingObject;
    private ILogChannel log;
    private Shell shell;
    private Display display;
    private List<String> commandLineArguments;
    private IVariables variables;
    private PropsUi props;
    private Menu mainMenu;
    private GuiMenuWidgets mainMenuWidgets;
    private Composite mainHopGuiComposite;
    private ToolBar mainToolbar;
    private GuiToolbarWidgets mainToolbarWidgets;
    private ToolBar perspectivesToolbar;
    private Composite mainPerspectivesComposite;
    private HopPerspectiveManager perspectiveManager;
    private IHopPerspective activePerspective;
    private static PrintStream originalSystemOut = System.out;
    private static PrintStream originalSystemErr = System.err;
    public MetadataManager<DatabaseMeta> databaseMetaManager;
    public MetadataManager<HopServer> hopServerManager;
    public MetadataManager<PartitionSchema> partitionManager;
    public HopGuiFileDelegate fileDelegate;
    public HopGuiUndoDelegate undoDelegate;
    public HopGuiContextDelegate contextDelegate;
    public HopGuiAuditDelegate auditDelegate;
    public HopGuiFileRefreshDelegate fileRefreshDelegate;
    private boolean openingLastFiles;
    private boolean reOpeningFiles;
    private static final ISingletonProvider PROVIDER = (ISingletonProvider)ImplementationLoader.newInstance(HopGui.class);

    protected HopGui() {
        this(Display.getCurrent());
    }

    private HopGui(Display display) {
        this.display = display;
        this.id = UUID.randomUUID().toString();
        this.commandLineArguments = new ArrayList<String>();
        this.variables = Variables.getADefaultVariableSpace();
        this.loggingObject = new LoggingObject((Object)APP_NAME);
        this.log = new LogChannel((Object)APP_NAME);
        this.activePerspective = new EmptyHopPerspective();
        this.fileDelegate = new HopGuiFileDelegate(this);
        this.undoDelegate = new HopGuiUndoDelegate(this);
        this.contextDelegate = new HopGuiContextDelegate(this);
        this.auditDelegate = new HopGuiAuditDelegate(this);
        this.fileRefreshDelegate = new HopGuiFileRefreshDelegate(this);
        this.metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)this.variables);
        this.eventsHandler = new HopGuiEventsHandler();
        this.updateMetadataManagers();
        HopNamespace.setNamespace(DEFAULT_HOP_GUI_NAMESPACE);
        this.shell = new Shell(display, 3312);
    }

    private void updateMetadataManagers() {
        this.databaseMetaManager = new MetadataManager<DatabaseMeta>(this.variables, (IHopMetadataProvider)this.metadataProvider, DatabaseMeta.class, this.shell);
        this.hopServerManager = new MetadataManager<HopServer>(this.variables, (IHopMetadataProvider)this.metadataProvider, HopServer.class, this.shell);
        this.partitionManager = new MetadataManager<PartitionSchema>(this.variables, (IHopMetadataProvider)this.metadataProvider, PartitionSchema.class, this.shell);
    }

    public static final HopGui getInstance() {
        return (HopGui)PROVIDER.getInstanceInternal();
    }

    public static void main(String[] arguments) {
        try {
            HopGui.setupConsoleLogging();
            HopEnvironment.init();
            OsHelper.setAppName();
            Display display = HopGui.setupDisplay();
            OsHelper.initOsHandlers(display);
            HopLogStore.init();
            Locale.setDefault(LanguageChoice.getInstance().getDefaultLocale());
            HopGui hopGui = HopGui.getInstance();
            hopGui.getCommandLineArguments().addAll(Arrays.asList(arguments));
            hopGui.setProps(PropsUi.getInstance());
            HopGuiEnvironment.init();
            JarCache.getInstance().clear();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)hopGui.variables, (String)HopExtensionPoint.HopGuiInit.id, (Object)hopGui);
            }
            catch (Exception e) {
                hopGui.getLog().logError("Error calling extension point plugin(s) for HopGuiInit", (Throwable)e);
            }
            boolean errors = false;
            try {
                hopGui.open();
            }
            catch (Throwable e) {
                originalSystemErr.println("Serious error detected in the Hop GUI: " + e.getMessage() + Const.CR + Const.getStackTracker((Throwable)e));
                errors = true;
            }
            System.exit(errors ? 1 : 0);
        }
        catch (Throwable e) {
            originalSystemErr.println("Error starting the Hop GUI: " + e.getMessage());
            e.printStackTrace(originalSystemErr);
            System.exit(1);
        }
    }

    protected void open() {
        this.shell.setImage(GuiResource.getInstance().getImageHopUiTaskbar());
        if (OsHelper.isMac()) {
            this.shell.getShell().addShellListener((ShellListener)new ShellAdapter(){

                public void shellActivated(ShellEvent shellevent) {
                    if (HopGui.this.firstShowing) {
                        HopGui.this.shell.setImage(GuiResource.getInstance().getImageHopUiTaskbar());
                        HopGui.this.firstShowing = false;
                    }
                }
            });
        }
        PropsUi.setLook((Widget)this.shell);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HopGui.Application.Name", (String[])new String[0]));
        this.addMainMenu();
        this.addMainToolbar();
        this.addPerspectivesToolbar();
        this.addMainPerspectivesComposite();
        this.loadPerspectives();
        this.handleFileCapabilities(new EmptyFileType(), false, false, false);
        this.replaceKeyboardShortcutListeners(this);
        this.shell.addListener(21, this::closeEvent);
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.shell.setMaximized(true);
        }
        this.display.asyncExec(() -> {
            this.openingLastFiles = true;
            this.reOpeningFiles = true;
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiStart.id, (Object)this);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error calling extension point '" + HopExtensionPoint.HopGuiStart.id + "'", e);
            }
            if (this.openingLastFiles) {
                this.auditDelegate.openLastFiles();
            }
            this.reOpeningFiles = false;
        });
        boolean doNotShowWelcomeDialog = HopConfig.readOptionBoolean((String)"doNotShowWelcomeDialog", (boolean)false);
        if (!(doNotShowWelcomeDialog |= Const.toBoolean((String)this.variables.getVariable("HOP_NO_WELCOME_DIALOG")))) {
            new WelcomeDialog().open();
        }
        if (EnvironmentUtils.getInstance().isWeb()) {
            return;
        }
        boolean retry = true;
        while (retry) {
            try {
                while (!this.shell.isDisposed()) {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
                retry = false;
            }
            catch (Throwable throwable) {
                System.err.println("Error in the Hop GUI : " + throwable.getMessage() + Const.CR + Const.getClassicStackTrace((Throwable)throwable));
            }
        }
        this.display.dispose();
    }

    private void closeEvent(Event event) {
        event.doit = this.fileDelegate.fileExit();
    }

    private void loadPerspectives() {
        try {
            this.perspectiveManager = new HopPerspectiveManager(this);
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            boolean first = true;
            List perspectivePlugins = pluginRegistry.getPlugins(HopPerspectivePluginType.class);
            Collections.sort(perspectivePlugins, Comparator.comparing(p -> p.getIds()[0]));
            for (Plugin perspectivePlugin : perspectivePlugins) {
                ToolItem item;
                Class perspectiveClass = (Class)pluginRegistry.getClass((IPlugin)perspectivePlugin, IHopPerspective.class);
                IHopPerspective perspective = (IHopPerspective)perspectiveClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                perspective.initialize(this, this.mainPerspectivesComposite);
                this.perspectiveManager.addPerspective(perspective);
                String tooltip = Const.NVL((String)TranslateUtil.translate((String)perspectivePlugin.getName(), (Class)perspectiveClass), (String)perspective.getId());
                Listener listener = event -> this.setActivePerspective(perspective);
                ClassLoader classLoader = pluginRegistry.getClassLoader((IPlugin)perspectivePlugin);
                if (EnvironmentUtils.getInstance().isWeb()) {
                    item = this.addWebToolbarButton(perspectivePlugin.getIds()[0], this.perspectivesToolbar, perspectivePlugin.getImageFile(), tooltip, listener);
                } else {
                    item = new ToolItem(this.perspectivesToolbar, 16);
                    item.setToolTipText(tooltip);
                    item.addListener(13, listener);
                    Image image = GuiResource.getInstance().getImage(perspectivePlugin.getImageFile(), classLoader, 16, 16);
                    if (image != null) {
                        item.setImage(image);
                    }
                }
                item.setData((Object)perspective);
                KeyboardShortcut shortcut = GuiRegistry.getInstance().findKeyboardShortcut(perspectiveClass.getName(), "activate", Const.isOSX());
                if (shortcut != null) {
                    item.setToolTipText(item.getToolTipText() + " (" + shortcut.toString() + ")");
                }
                if (!first) continue;
                first = false;
                item.setSelection(true);
            }
            this.perspectivesToolbar.pack();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error loading perspectives", e);
        }
    }

    private ToolItem addWebToolbarButton(String id, ToolBar toolBar, String filename, String tooltip, Listener listener) {
        ToolItem item = new ToolItem(toolBar, 2);
        Label label = new Label((Composite)toolBar, 0);
        Listener webListener = SvgLabelListener.getInstance();
        label.addListener(3, webListener);
        label.addListener(23, webListener);
        label.addListener(22, webListener);
        label.addListener(3, listener);
        if (StringUtils.isNotEmpty((String)tooltip)) {
            label.setToolTipText(tooltip);
        }
        label.pack();
        int size = (int)(16.0 * PropsUi.getNativeZoomFactor());
        item.setWidth(size + 2);
        item.setControl((Control)label);
        SvgLabelFacade.setData(id, label, filename, size);
        item.setData("id", (Object)id);
        return item;
    }

    private static Display setupDisplay() {
        Display display = new Display();
        PropsUi.getInstance();
        return display;
    }

    private static void setupConsoleLogging() {
        boolean doConsoleRedirect;
        boolean bl = doConsoleRedirect = !Boolean.getBoolean("HopUi.Console.Redirect.Disabled");
        if (doConsoleRedirect) {
            try {
                Path parent = Paths.get(Const.HOP_AUDIT_FOLDER, new String[0]);
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.deleteIfExists(Paths.get(parent.toString(), "hopui.log"));
                Path path = Files.createFile(Paths.get(parent.toString(), "hopui.log"), new FileAttribute[0]);
                System.setProperty("LOG_PATH", path.toString());
                FileOutputStream fos = new FileOutputStream(path.toFile());
                System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)originalSystemOut, (OutputStream)fos)));
                System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)originalSystemErr, (OutputStream)fos)));
                HopLogStore.OriginalSystemOut = System.out;
                HopLogStore.OriginalSystemErr = System.err;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void addMainMenu() {
        this.mainMenuWidgets = new GuiMenuWidgets();
        this.mainMenuWidgets.registerGuiPluginObject(this);
        this.mainMenu = new Menu((Decorations)this.shell, 2);
        this.mainMenuWidgets.createMenuWidgets(ID_MAIN_MENU, this.shell, this.mainMenu);
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mainMenuWidgets.enableMenuItem(ID_MAIN_MENU_FILE_EXIT, false);
        }
        if (this.props.isHidingMenuBar()) {
            return;
        }
        this.shell.setMenuBar(this.mainMenu);
        this.setUndoMenu(null);
    }

    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-10000-menu", image="ui/images/logo_bw.svg", toolTip="i18n::HopGui.Menu")
    public void menu() {
        GuiContextUtil.getInstance().handleActionSelection(this.shell, "Menu actions...", null, new MenuContextHandler(ID_MAIN_MENU, this.mainMenuWidgets));
    }

    @GuiMenuElement(root="HopGui-Menu", id="10000-menu-file", label="i18n::HopGui.Menu.File", parentId="HopGui-Menu")
    public void menuFile() {
    }

    @GuiMenuElement(root="HopGui-Menu", id="10010-menu-file-new", label="i18n::HopGui.Menu.File.New", image="ui/images/add.svg", parentId="10000-menu-file")
    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-10010-new", image="ui/images/add.svg", toolTip="i18n::HopGui.Menu.File.New")
    @GuiKeyboardShortcut(control=true, key=110)
    @GuiOsxKeyboardShortcut(command=true, key=110)
    public void menuFileNew() {
        this.contextDelegate.fileNew();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10020-menu-file-open", label="i18n::HopGui.Menu.File.Open", image="ui/images/open.svg", parentId="10000-menu-file")
    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-10020-open", image="ui/images/open.svg", toolTip="i18n::HopGui.Menu.File.Open", separator=true)
    @GuiKeyboardShortcut(control=true, key=111)
    @GuiOsxKeyboardShortcut(command=true, key=111)
    public void menuFileOpen() {
        this.fileDelegate.fileOpen();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10025-menu-file-open-recent", label="i18n::HopGui.Menu.File.Open.Recent", image="ui/images/open.svg", parentId="10000-menu-file")
    public void menuFileOpenRecent() {
        this.fileDelegate.fileOpenRecent();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10030-menu-file-save", label="i18n::HopGui.Menu.File.Save", image="ui/images/save.svg", parentId="10000-menu-file")
    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-10040-save", image="ui/images/save.svg", toolTip="i18n::HopGui.Menu.File.Save")
    @GuiKeyboardShortcut(control=true, key=115)
    @GuiOsxKeyboardShortcut(command=true, key=115)
    public void menuFileSave() {
        this.fileDelegate.fileSave();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10040-menu-file-save-as", label="i18n::HopGui.Menu.File.SaveAs", image="ui/images/save-as.svg", parentId="10000-menu-file")
    @GuiToolbarElement(root="HopGui-Toolbar", id="toolbar-10050-save-as", image="ui/images/save-as.svg", toolTip="i18n::HopGui.Menu.File.SaveAs")
    @GuiKeyboardShortcut(control=true, shift=true, key=115)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=115)
    public void menuFileSaveAs() {
        this.fileDelegate.fileSaveAs();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10050-menu-file-export-to-svg", separator=true, label="i18n::HopGui.Menu.File.ExportToSVG", image="ui/images/image.svg", parentId="10000-menu-file")
    public void menuFileExportToSvg() {
        this.fileDelegate.exportToSvg();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10090-menu-file-close", label="i18n::HopGui.Menu.File.Close", parentId="10000-menu-file", image="ui/images/close.svg", separator=true)
    @GuiKeyboardShortcut(control=true, key=119)
    @GuiOsxKeyboardShortcut(command=true, key=119)
    public void menuFileClose() {
        this.fileDelegate.fileClose();
    }

    @GuiMenuElement(root="HopGui-Menu", id="10100-menu-file-close-all", label="i18n::HopGui.Menu.File.Close.All", parentId="10000-menu-file", image="ui/images/close.svg")
    @GuiKeyboardShortcut(control=true, shift=true, key=119)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=119)
    public void menuFileCloseAll() {
        if (this.fileDelegate.saveGuardAllFiles()) {
            this.fileDelegate.closeAllFiles();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="10900-menu-file-exit", label="i18n::HopGui.Menu.File.Quit", parentId="10000-menu-file", image="ui/images/shutdown.svg", separator=true)
    @GuiKeyboardShortcut(control=true, key=113)
    @GuiOsxKeyboardShortcut(command=true, key=113)
    public void menuFileExit() {
        if (this.fileDelegate.fileExit()) {
            this.props.setScreen(new WindowProperty(this.shell));
            this.shell.dispose();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20000-menu-edit", label="i18n::HopGui.Menu.Edit", parentId="HopGui-Menu")
    public void menuEdit() {
    }

    @GuiMenuElement(root="HopGui-Menu", id="20010-menu-edit-undo", label="i18n::HopGui.Menu.Edit.Undo", image="ui/images/undo.svg", parentId="20000-menu-edit")
    @GuiKeyboardShortcut(control=true, key=122)
    @GuiOsxKeyboardShortcut(command=true, key=122)
    public void menuEditUndo() {
        this.getActiveFileTypeHandler().undo();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20020-menu-edit-redo", label="i18n::HopGui.Menu.Edit.Redo", image="ui/images/redo.svg", parentId="20000-menu-edit")
    @GuiKeyboardShortcut(control=true, shift=true, key=122)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=122)
    public void menuEditRedo() {
        this.getActiveFileTypeHandler().redo();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20050-menu-edit-select-all", label="i18n::HopGui.Menu.Edit.SelectAll", parentId="20000-menu-edit", image="ui/images/select-all.svg", separator=true)
    @GuiKeyboardShortcut(control=true, key=97)
    @GuiOsxKeyboardShortcut(command=true, key=97)
    public void menuEditSelectAll() {
        this.getActiveFileTypeHandler().selectAll();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20060-menu-edit-unselect-all", label="i18n::HopGui.Menu.Edit.ClearSelection", parentId="20000-menu-edit", image="ui/images/unselect-all.svg")
    @GuiKeyboardShortcut(key=27)
    @GuiOsxKeyboardShortcut(key=27)
    public void menuEditUnselectAll() {
        this.getActiveFileTypeHandler().unselectAll();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20070-menu-edit-find", label="i18n::HopGui.Menu.Edit.Find", image="ui/images/search.svg", parentId="20000-menu-edit")
    @GuiKeyboardShortcut(key=102, control=true)
    @GuiOsxKeyboardShortcut(key=102, command=true)
    public void menuEditFind() {
        IHopPerspective perspective = this.perspectiveManager.findPerspective(HopSearchPerspective.class);
        if (perspective != null) {
            ((HopSearchPerspective)perspective).activate();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20080-menu-edit-copy", label="i18n::HopGui.Menu.Edit.CopyToClipboard", image="ui/images/copy.svg", parentId="20000-menu-edit", separator=true)
    @GuiKeyboardShortcut(control=true, key=99)
    @GuiOsxKeyboardShortcut(command=true, key=99)
    public void menuEditCopySelected() {
        this.getActiveFileTypeHandler().copySelectedToClipboard();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20090-menu-edit-paste", label="i18n::HopGui.Menu.Edit.PasteFromClipboard", image="ui/images/paste.svg", parentId="20000-menu-edit")
    @GuiKeyboardShortcut(control=true, key=118)
    @GuiOsxKeyboardShortcut(command=true, key=118)
    public void menuEditPaste() {
        this.getActiveFileTypeHandler().pasteFromClipboard();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20100-menu-edit-cut", label="i18n::HopGui.Menu.Edit.Cut", image="ui/images/cut.svg", parentId="20000-menu-edit")
    @GuiKeyboardShortcut(control=true, key=120)
    @GuiOsxKeyboardShortcut(command=true, key=120)
    public void menuEditCutSelected() {
        this.getActiveFileTypeHandler().cutSelectedToClipboard();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20110-menu-edit-delete", label="i18n::HopGui.Menu.Edit.Delete", image="ui/images/delete.svg", parentId="20000-menu-edit")
    @GuiKeyboardShortcut(control=false, key=127)
    @GuiOsxKeyboardShortcut(command=false, key=127)
    public void menuEditDeleteSelected() {
        this.getActiveFileTypeHandler().deleteSelected();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20200-menu-edit-snap-to-grid", label="i18n::HopGui.Menu.Edit.SnapToGrid", image="ui/images/snap-to-grid.svg", parentId="20000-menu-edit", separator=true)
    @GuiKeyboardShortcut(control=true, key=0x1000007)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000007)
    public void menuEditSnapToGrid() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).snapToGrid();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20210-menu-edit-align-left", parentId="20000-menu-edit", label="i18n::HopGui.Menu.Edit.AlignLeft", image="ui/images/align-left.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000003)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000003)
    public void menuEditAlignLeft() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).alignLeft();
            activeFileTypeHandler.updateGui();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20220-menu-edit-align-right", parentId="20000-menu-edit", label="i18n::HopGui.Menu.Edit.AlignRight", image="ui/images/align-right.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000004)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000004)
    public void menuEditAlignRight() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).alignRight();
            activeFileTypeHandler.updateGui();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20230-menu-edit-align-top", parentId="20000-menu-edit", label="i18n::HopGui.Menu.Edit.AlignTop", image="ui/images/align-top.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000001)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000001)
    public void menuEditAlignTop() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).alignTop();
            activeFileTypeHandler.updateGui();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20240-menu-edit-align-bottom", parentId="20000-menu-edit", label="i18n::HopGui.Menu.Edit.AlignBottom", image="ui/images/align-bottom.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000002)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000002)
    public void menuEditAlignBottom() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).alignBottom();
            activeFileTypeHandler.updateGui();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20300-menu-edit-distribute-horizontal", parentId="20000-menu-edit", label="i18n::HopGui.Menu.Edit.DistributeHorizontally", image="ui/images/distribute-horizontally.svg")
    @GuiKeyboardShortcut(alt=true, key=0x1000004)
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000004)
    public void menuEditDistributeHorizontal() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).distributeHorizontal();
            activeFileTypeHandler.updateGui();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20320-menu-edit-distribute-vertical", parentId="20000-menu-edit", label="i18n::HopGui.Menu.Edit.DistributeVertically", image="ui/images/distribute-vertically.svg")
    @GuiKeyboardShortcut(alt=true, key=0x1000001)
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000001)
    public void menuEditDistributeVertical() {
        IHopFileTypeHandler activeFileTypeHandler = this.getActiveFileTypeHandler();
        if (activeFileTypeHandler instanceof IGraphSnapAlignDistribute) {
            ((IGraphSnapAlignDistribute)((Object)activeFileTypeHandler)).distributeVertical();
            activeFileTypeHandler.updateGui();
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="20400-menu-edit-nav-previous", label="i18n::HopGui.Menu.Edit.Navigate.Previous", parentId="20000-menu-edit", image="ui/images/arrow-left.svg", separator=true)
    @GuiKeyboardShortcut(alt=true, key=0x1000003)
    public void menuEditNavigatePreviousFile() {
        this.getActivePerspective().navigateToPreviousFile();
    }

    @GuiMenuElement(root="HopGui-Menu", id="20410-menu-edit-nav-next", label="i18n::HopGui.Menu.Edit.Navigate.Next", parentId="20000-menu-edit", image="ui/images/arrow-right.svg")
    @GuiKeyboardShortcut(alt=true, key=0x1000004)
    public void menuEditNavigateNextFile() {
        this.getActivePerspective().navigateToNextFile();
    }

    @GuiMenuElement(root="HopGui-Menu", id="30000-menu-run", label="i18n::HopGui.Menu.Run", parentId="HopGui-Menu")
    public void menuRun() {
    }

    @GuiMenuElement(root="HopGui-Menu", id="30010-menu-run-execute", label="i18n::HopGui.Menu.Run.StartExecution", image="ui/images/run.svg", parentId="30000-menu-run")
    @GuiKeyboardShortcut(key=0x1000011)
    public void menuRunStart() {
        this.getActiveFileTypeHandler().start();
    }

    @GuiMenuElement(root="HopGui-Menu", id="30040-menu-run-stop", label="i18n::HopGui.Menu.Run.StopExecution", image="ui/images/stop.svg", parentId="30000-menu-run")
    public void menuRunStop() {
        this.getActiveFileTypeHandler().stop();
    }

    @GuiMenuElement(root="HopGui-Menu", id="30030-menu-run-pause", label="i18n::HopGui.Menu.Run.PauseExecution", image="ui/images/pause.svg", parentId="30000-menu-run", separator=true)
    public void menuRunPause() {
        this.getActiveFileTypeHandler().pause();
    }

    @GuiMenuElement(root="HopGui-Menu", id="30035-menu-run-resume", label="i18n::HopGui.Menu.Run.ResumeExecution", image="ui/images/run.svg", parentId="30000-menu-run")
    public void menuRunResume() {
        this.getActiveFileTypeHandler().pause();
    }

    @GuiMenuElement(root="HopGui-Menu", id="30050-menu-run-preview", label="i18n::HopGui.Menu.Run.Preview", image="ui/images/preview.svg", parentId="30000-menu-run", separator=true)
    public void menuRunPreview() {
        this.getActiveFileTypeHandler().preview();
    }

    @GuiMenuElement(root="HopGui-Menu", id="30060-menu-run-debug", label="i18n::HopGui.Menu.Run.Debug", image="ui/images/debug.svg", parentId="30000-menu-run")
    public void menuRunDebug() {
        this.getActiveFileTypeHandler().debug();
    }

    @GuiMenuElement(root="HopGui-Menu", id="40000-menu-tools", label="i18n::HopGui.Menu.Tools", parentId="HopGui-Menu")
    public void menuTools() {
    }

    @GuiMenuElement(root="HopGui-Menu", id="40030-menu-tools-database-clearcache", label="i18n::HopGui.Menu.Tools.DatabaseClearCache", parentId="40000-menu-tools", separator=true, image="ui/images/clear.svg")
    public void menuToolsDatabaseClearCache() {
        DbCache.getInstance().clear(null);
    }

    @GuiMenuElement(root="HopGui-Menu", id="90000-menu-help", label="i18n::HopGui.Menu.Help", parentId="HopGui-Menu")
    public void menuHelp() {
    }

    @GuiMenuElement(root="HopGui-Menu", id="90009-menu-help-about", label="i18n::HopGui.Menu.Help.About", parentId="90000-menu-help", image="ui/images/help.svg")
    public void menuHelpAbout() {
        AboutDialog dialog = new AboutDialog(this.getShell());
        dialog.open();
    }

    protected void addMainToolbar() {
        this.mainToolbar = new ToolBar((Composite)this.shell, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        this.mainToolbar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)this.mainToolbar, 5);
        this.mainToolbarWidgets = new GuiToolbarWidgets();
        this.mainToolbarWidgets.registerGuiPluginObject(this);
        this.mainToolbarWidgets.createToolbarWidgets((Composite)this.mainToolbar, ID_MAIN_TOOLBAR);
        this.mainToolbar.pack();
    }

    protected void addPerspectivesToolbar() {
        this.shell.setLayout((Layout)new FormLayout());
        this.mainHopGuiComposite = new Composite((Composite)this.shell, 262144);
        this.mainHopGuiComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.mainToolbar, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.mainHopGuiComposite.setLayoutData((Object)formData);
        this.perspectivesToolbar = new ToolBar(this.mainHopGuiComposite, 131648);
        PropsUi.setLook((Widget)this.perspectivesToolbar, 5);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.bottom = new FormAttachment(100, 0);
        this.perspectivesToolbar.setLayoutData((Object)fdToolBar);
    }

    private void addMainPerspectivesComposite() {
        this.mainPerspectivesComposite = new Composite(this.mainHopGuiComposite, 262144);
        this.mainPerspectivesComposite.setLayout((Layout)new StackLayout());
        FormData fdMain = new FormData();
        fdMain.top = new FormAttachment(0, 0);
        fdMain.left = new FormAttachment((Control)this.perspectivesToolbar, 0);
        fdMain.bottom = new FormAttachment(100, 0);
        fdMain.right = new FormAttachment(100, 0);
        this.mainPerspectivesComposite.setLayoutData((Object)fdMain);
    }

    public void setUndoMenu(IUndo undoInterface) {
        MenuItem undoItem = this.mainMenuWidgets.findMenuItem(ID_MAIN_MENU_EDIT_UNDO);
        MenuItem redoItem = this.mainMenuWidgets.findMenuItem(ID_MAIN_MENU_EDIT_REDO);
        if (undoItem == null || redoItem == null || undoItem.isDisposed() || redoItem.isDisposed()) {
            return;
        }
        ChangeAction prev = null;
        ChangeAction next = null;
        if (undoInterface != null) {
            prev = undoInterface.viewThisUndo();
            next = undoInterface.viewNextUndo();
        }
        undoItem.setEnabled(prev != null);
        if (prev == null) {
            undoItem.setText(UNDO_UNAVAILABLE);
        } else {
            undoItem.setText(BaseMessages.getString(PKG, (String)"HopGui.Menu.Undo.Available", (String[])new String[]{prev.toString()}));
        }
        KeyboardShortcut undoShortcut = this.mainMenuWidgets.findKeyboardShortcut(ID_MAIN_MENU_EDIT_UNDO);
        if (undoShortcut != null) {
            GuiMenuWidgets.appendShortCut(undoItem, undoShortcut);
        }
        redoItem.setEnabled(next != null);
        if (next == null) {
            redoItem.setText(REDO_UNAVAILABLE);
        } else {
            redoItem.setText(BaseMessages.getString(PKG, (String)"HopGui.Menu.Redo.Available", (String[])new String[]{next.toString()}));
        }
        KeyboardShortcut redoShortcut = this.mainMenuWidgets.findKeyboardShortcut(ID_MAIN_MENU_EDIT_REDO);
        if (redoShortcut != null) {
            GuiMenuWidgets.appendShortCut(redoItem, redoShortcut);
        }
    }

    public void handleFileCapabilities(IHopFileType fileType, boolean changed, boolean running, boolean paused) {
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_FILE_SAVE, "Save", changed);
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_FILE_SAVE_AS, "SaveAs");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_FILE_EXPORT_TO_SVG, "ExportToSvg");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_FILE_CLOSE, "Close");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_FILE_CLOSE_ALL, "Close");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_SELECT_ALL, "Select");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_UNSELECT_ALL, "Select");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_COPY, "Copy");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_PASTE, "Paste");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_CUT, "Cut");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_DELETE, "Delete");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_RUN_START, "Start", !running);
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_RUN_STOP, "Stop", running);
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_RUN_PAUSE, "Pause", running && !paused);
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_RUN_RESUME, "Pause", paused);
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_RUN_PREVIEW, "Preview");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_RUN_DEBUG, "Debug");
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_NAV_PREV, "FileHistory", this.getActivePerspective().hasNavigationPreviousFile());
        this.mainMenuWidgets.enableMenuItem(fileType, ID_MAIN_MENU_EDIT_NAV_NEXT, "FileHistory", this.getActivePerspective().hasNavigationNextFile());
        this.mainToolbarWidgets.enableToolbarItem(fileType, ID_MAIN_TOOLBAR_SAVE, "Save", changed);
        this.mainToolbarWidgets.enableToolbarItem(fileType, ID_MAIN_TOOLBAR_SAVE_AS, "SaveAs");
    }

    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return this.getActivePerspective().getActiveFileTypeHandler();
    }

    public void replaceKeyboardShortcutListeners(Object parentObject) {
        HopGuiKeyHandler keyHandler = HopGuiKeyHandler.getInstance();
        keyHandler.addParentObjectToHandle(parentObject);
        this.replaceKeyboardShortcutListeners((Control)this.shell, keyHandler);
    }

    public void replaceKeyboardShortcutListeners(Control control, HopGuiKeyHandler keyHandler) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.removeKeyListener((KeyListener)keyHandler);
        control.addKeyListener((KeyListener)keyHandler);
        if (control instanceof Composite) {
            for (Control child : ((Composite)control).getChildren()) {
                this.replaceKeyboardShortcutListeners(child, keyHandler);
            }
        }
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        this.updateMetadataManagers();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Display getDisplay() {
        return this.display;
    }

    public List<String> getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public void setCommandLineArguments(List<String> commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
    }

    public Composite getMainPerspectivesComposite() {
        return this.mainPerspectivesComposite;
    }

    public void setMainPerspectivesComposite(Composite mainPerspectivesComposite) {
        this.mainPerspectivesComposite = mainPerspectivesComposite;
    }

    public HopPerspectiveManager getPerspectiveManager() {
        return this.perspectiveManager;
    }

    public void setPerspectiveManager(HopPerspectiveManager perspectiveManager) {
        this.perspectiveManager = perspectiveManager;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public PropsUi getProps() {
        return this.props;
    }

    public void setProps(PropsUi props) {
        this.props = props;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public Menu getMainMenu() {
        return this.mainMenu;
    }

    public void setMainMenu(Menu mainMenu) {
        this.mainMenu = mainMenu;
    }

    public ToolBar getMainToolbar() {
        return this.mainToolbar;
    }

    public void setMainToolbar(ToolBar mainToolbar) {
        this.mainToolbar = mainToolbar;
    }

    public ToolBar getPerspectivesToolbar() {
        return this.perspectivesToolbar;
    }

    public void setPerspectivesToolbar(ToolBar perspectivesToolbar) {
        this.perspectivesToolbar = perspectivesToolbar;
    }

    public Composite getMainHopGuiComposite() {
        return this.mainHopGuiComposite;
    }

    public void setMainHopGuiComposite(Composite mainHopGuiComposite) {
        this.mainHopGuiComposite = mainHopGuiComposite;
    }

    public void setActivePerspective(IHopPerspective perspective) {
        if (perspective == null) {
            perspective = HopGui.getDataOrchestrationPerspective();
        }
        this.activePerspective = perspective;
        StackLayout layout = (StackLayout)this.mainPerspectivesComposite.getLayout();
        layout.topControl = perspective.getControl();
        this.mainPerspectivesComposite.layout();
        if (this.perspectivesToolbar != null && !this.perspectivesToolbar.isDisposed()) {
            for (ToolItem item : this.perspectivesToolbar.getItems()) {
                boolean shaded = perspective.equals(item.getData());
                if (EnvironmentUtils.getInstance().isWeb()) {
                    SvgLabelFacade.shadeSvg((Label)item.getControl(), (String)item.getData("id"), shaded);
                    continue;
                }
                item.setSelection(shaded);
            }
        }
        perspective.perspectiveActivated();
        this.perspectiveManager.notifyPerspectiveActiviated(perspective);
    }

    public boolean isActivePerspective(IHopPerspective perspective) {
        if (perspective != null) {
            for (ToolItem item : this.perspectivesToolbar.getItems()) {
                if (!perspective.equals(item.getData())) continue;
                return item.getSelection();
            }
        }
        return false;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        ArrayList<IGuiContextHandler> contextHandlers = new ArrayList<IGuiContextHandler>();
        HopFileTypeRegistry registry = HopFileTypeRegistry.getInstance();
        List<IHopFileType> hopFileTypes = registry.getFileTypes();
        for (IHopFileType hopFileType : hopFileTypes) {
            contextHandlers.addAll(hopFileType.getContextHandlers());
        }
        contextHandlers.addAll(new MetadataContext(this, (IHopMetadataProvider)this.metadataProvider).getContextHandlers());
        return contextHandlers;
    }

    public void setParametersAsVariablesInUI(INamedParameterDefinitions namedParameters, IVariables variables) {
        for (String param : namedParameters.listParameters()) {
            try {
                variables.setVariable(param, Const.NVL((String)variables.getVariable(param), (String)Const.NVL((String)namedParameters.getParameterDefault(param), (String)"")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HopGuiPipelineGraph getActivePipelineGraph() {
        IHopPerspective activePerspective = HopGui.getInstance().getActivePerspective();
        if (!(activePerspective instanceof HopDataOrchestrationPerspective)) {
            return null;
        }
        HopDataOrchestrationPerspective perspective = (HopDataOrchestrationPerspective)activePerspective;
        IHopFileTypeHandler typeHandler = perspective.getActiveFileTypeHandler();
        if (!(typeHandler instanceof HopGuiPipelineGraph)) {
            return null;
        }
        return (HopGuiPipelineGraph)typeHandler;
    }

    public static HopGuiWorkflowGraph getActiveWorkflowGraph() {
        IHopPerspective activePerspective = HopGui.getInstance().getActivePerspective();
        if (!(activePerspective instanceof HopDataOrchestrationPerspective)) {
            return null;
        }
        HopDataOrchestrationPerspective perspective = (HopDataOrchestrationPerspective)activePerspective;
        IHopFileTypeHandler typeHandler = perspective.getActiveFileTypeHandler();
        if (!(typeHandler instanceof HopGuiWorkflowGraph)) {
            return null;
        }
        return (HopGuiWorkflowGraph)typeHandler;
    }

    public static HopDataOrchestrationPerspective getDataOrchestrationPerspective() {
        return (HopDataOrchestrationPerspective)HopGui.getInstance().getPerspectiveManager().findPerspective(HopDataOrchestrationPerspective.class);
    }

    public static MetadataPerspective getMetadataPerspective() {
        return (MetadataPerspective)HopGui.getInstance().getPerspectiveManager().findPerspective(MetadataPerspective.class);
    }

    public static ExecutionPerspective getExecutionPerspective() {
        return (ExecutionPerspective)HopGui.getInstance().getPerspectiveManager().findPerspective(ExecutionPerspective.class);
    }

    public static ExplorerPerspective getExplorerPerspective() {
        return (ExplorerPerspective)HopGui.getInstance().getPerspectiveManager().findPerspective(ExplorerPerspective.class);
    }

    public static ConfigurationPerspective getConfigurationPerspective() {
        return (ConfigurationPerspective)HopGui.getInstance().getPerspectiveManager().findPerspective(ConfigurationPerspective.class);
    }

    public List<ISearchablesLocation> getSearchablesLocations() {
        ArrayList<ISearchablesLocation> locations = new ArrayList<ISearchablesLocation>();
        locations.add(new HopGuiSearchLocation(this));
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiGetSearchablesLocations.name(), locations);
        }
        catch (Exception e) {
            this.log.logError("Error adding to the list of searchables locations", (Throwable)e);
        }
        return locations;
    }

    public static boolean editConfigFile(Shell shell, String configFilename, DescribedVariablesConfigFile variablesConfigFile, String selectedVariable) throws HopException {
        String message = "Editing configuration file: " + configFilename;
        HopDescribedVariablesDialog variablesDialog = new HopDescribedVariablesDialog(shell, message, variablesConfigFile.getDescribedVariables(), selectedVariable);
        List<DescribedVariable> vars = variablesDialog.open();
        if (vars != null) {
            variablesConfigFile.setDescribedVariables(vars);
            variablesConfigFile.saveToFile();
            return true;
        }
        return false;
    }

    @GuiKeyboardShortcut(control=true, shift=true, key=0x1000001)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=0x1000001)
    public void previousPerspective() {
        IHopPerspective perspective = this.getActivePerspective();
        this.getPerspectiveManager().showPreviousPerspective(perspective);
    }

    @GuiKeyboardShortcut(control=true, shift=true, key=0x1000002)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=0x1000002)
    public void nextPerspective() {
        IHopPerspective perspective = this.getActivePerspective();
        this.getPerspectiveManager().showNextPerspective(perspective);
    }

    public MetadataManager<DatabaseMeta> getDatabaseMetaManager() {
        return this.databaseMetaManager;
    }

    public void setDatabaseMetaManager(MetadataManager<DatabaseMeta> databaseMetaManager) {
        this.databaseMetaManager = databaseMetaManager;
    }

    public MetadataManager<PartitionSchema> getPartitionManager() {
        return this.partitionManager;
    }

    public void setPartitionManager(MetadataManager<PartitionSchema> partitionManager) {
        this.partitionManager = partitionManager;
    }

    public HopGuiFileDelegate getFileDelegate() {
        return this.fileDelegate;
    }

    public void setFileDelegate(HopGuiFileDelegate fileDelegate) {
        this.fileDelegate = fileDelegate;
    }

    public HopGuiUndoDelegate getUndoDelegate() {
        return this.undoDelegate;
    }

    public void setUndoDelegate(HopGuiUndoDelegate undoDelegate) {
        this.undoDelegate = undoDelegate;
    }

    public IHopPerspective getActivePerspective() {
        return this.activePerspective;
    }

    public ILoggingObject getLoggingObject() {
        return this.loggingObject;
    }

    public GuiMenuWidgets getMainMenuWidgets() {
        return this.mainMenuWidgets;
    }

    public void setMainMenuWidgets(GuiMenuWidgets mainMenuWidgets) {
        this.mainMenuWidgets = mainMenuWidgets;
    }

    public GuiToolbarWidgets getMainToolbarWidgets() {
        return this.mainToolbarWidgets;
    }

    public void setMainToolbarWidgets(GuiToolbarWidgets mainToolbarWidgets) {
        this.mainToolbarWidgets = mainToolbarWidgets;
    }

    public boolean isOpeningLastFiles() {
        return this.openingLastFiles;
    }

    public void setOpeningLastFiles(boolean openingLastFiles) {
        this.openingLastFiles = openingLastFiles;
    }

    public String getId() {
        return this.id;
    }

    public HopGuiEventsHandler getEventsHandler() {
        return this.eventsHandler;
    }

    public void setEventsHandler(HopGuiEventsHandler eventsHandler) {
        this.eventsHandler = eventsHandler;
    }

    public boolean isReOpeningFiles() {
        return this.reOpeningFiles;
    }

    public void setReOpeningFiles(boolean reOpeningFiles) {
        this.reOpeningFiles = reOpeningFiles;
    }
}

