/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.tab.GuiTabItem;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelinePainter;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.SelectRowDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.CanvasFacade;
import org.apache.hop.ui.hopgui.CanvasListener;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.IExecutionViewer;
import org.apache.hop.ui.hopgui.shared.BaseExecutionViewer;
import org.apache.hop.ui.hopgui.shared.SwtGc;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowPainter;
import org.apache.hop.workflow.action.ActionMeta;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;

@GuiPlugin
public class WorkflowExecutionViewer
extends BaseExecutionViewer
implements IExecutionViewer,
PaintListener,
MouseListener {
    private static final Class<?> PKG = WorkflowExecutionViewer.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "WorkflowExecutionViewer-Toolbar";
    public static final String TOOLBAR_ITEM_REFRESH = "WorkflowExecutionViewer-Toolbar-10100-Refresh";
    public static final String TOOLBAR_ITEM_ZOOM_LEVEL = "WorkflowExecutionViewer-ToolBar-10500-Zoom-Level";
    public static final String TOOLBAR_ITEM_ZOOM_FIT_TO_SCREEN = "WorkflowExecutionViewer-ToolBar-10600-Zoom-Fit-To-Screen";
    public static final String TOOLBAR_ITEM_TO_EDITOR = "WorkflowExecutionViewer-Toolbar-11100-GoToEditor";
    public static final String TOOLBAR_ITEM_DRILL_DOWN = "WorkflowExecutionViewer-Toolbar-11200-DrillDown";
    public static final String TOOLBAR_ITEM_GO_UP = "WorkflowExecutionViewer-Toolbar-11300-GoUp";
    public static final String TOOLBAR_ITEM_VIEW_EXECUTOR = "WorkflowExecutionViewer-Toolbar-12000-ViewExecutor";
    public static final String TOOLBAR_ITEM_VIEW_METADATA = "WorkflowExecutionViewer-Toolbar-12100-ViewMetadata";
    public static final String WORKFLOW_EXECUTION_VIEWER_TABS = "WorkflowExecutionViewer.Tabs.ID";
    protected final WorkflowMeta workflowMeta;
    protected ActionMeta selectedAction;
    protected ExecutionData selectedExecutionData;
    private CTabItem infoTab;
    private TableView infoView;
    private CTabItem logTab;
    private CTabItem dataTab;
    private SashForm dataSash;
    private org.eclipse.swt.widgets.List dataList;
    private TableView dataView;
    private Map<String, List<ExecutionData>> actionExecutions;

    public WorkflowExecutionViewer(Composite parent, HopGui hopGui, WorkflowMeta workflowMeta, String locationName, ExecutionPerspective perspective, Execution execution, ExecutionState executionState) {
        super(parent, hopGui, perspective, locationName, execution, executionState);
        this.workflowMeta = workflowMeta;
        this.actionExecutions = new HashMap<String, List<ExecutionData>>();
        this.maximum = workflowMeta.getMaximum();
        this.addWidgets();
    }

    public void addWidgets() {
        this.setLayout((Layout)new FormLayout());
        this.toolBar = new ToolBar((Composite)this, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)layoutData);
        this.toolBar.pack();
        PropsUi.setLook((Widget)this.toolBar, 5);
        this.sash = new SashForm((Composite)this, 512);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment((Control)this.toolBar, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fdSash);
        this.canvas = new Canvas((Composite)this.sash, 264192);
        Listener listener = CanvasListener.getInstance();
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(4, listener);
        this.canvas.addListener(9, listener);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.canvas.addMouseMoveListener((MouseMoveListener)this);
            this.canvas.addMouseWheelListener(this::mouseScrolled);
        }
        this.tabFolder = new CTabFolder((Composite)this.sash, 2);
        PropsUi.setLook((Widget)this.tabFolder, 4);
        this.addInfoTab();
        this.addLogTab();
        this.addDataTab();
        this.addPluginTabs();
        this.refresh();
        this.hopGui.replaceKeyboardShortcutListeners(this);
        this.tabFolder.setSelection(0);
        this.sash.setWeights(new int[]{60, 40});
    }

    private void addInfoTab() {
        this.infoTab = new CTabItem(this.tabFolder, 0);
        this.infoTab.setFont(GuiResource.getInstance().getFontDefault());
        this.infoTab.setImage(GuiResource.getInstance().getImageInfo());
        this.infoTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionViewer.InfoTab.Title", (String[])new String[0]));
        ColumnInfo[] infoCols = new ColumnInfo[]{new ColumnInfo("Item", 1, false, true), new ColumnInfo("Value", 1, false, true)};
        this.infoView = new TableView(this.hopGui.getVariables(), (Composite)this.tabFolder, 768, infoCols, 1, true, null, this.props);
        PropsUi.setLook((Widget)this.infoView);
        this.infoTab.setControl((Control)this.infoView);
    }

    private void refreshStatus() {
        try {
            this.infoView.clearAll();
            ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
            if (location == null) {
                return;
            }
            IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
            this.executionState = iLocation.getExecutionState(this.execution.getId(), false);
            if (this.executionState == null) {
                return;
            }
            String statusDescription = this.executionState.getStatusDescription();
            if ("Running".equalsIgnoreCase(statusDescription) || "Initializing".equalsIgnoreCase(statusDescription)) {
                long loggingInterval = Const.toLong((String)location.getDataLoggingInterval(), (long)20000L);
                if (System.currentTimeMillis() - this.executionState.getUpdateTime().getTime() > loggingInterval) {
                    TableItem item = this.infoView.add("Update state", "Stale");
                    item.setBackground(GuiResource.getInstance().getColorLightBlue());
                    item.setForeground(GuiResource.getInstance().getColorWhite());
                }
            }
            this.infoView.add("Name", this.execution.getName());
            this.infoView.add("Type", this.execution.getExecutionType().name());
            this.infoView.add("Filename", this.execution.getFilename());
            this.infoView.add("ID", this.execution.getId());
            this.infoView.add("Parent ID", this.execution.getParentId());
            this.infoView.add("Registration", this.formatDate(this.execution.getRegistrationDate()));
            this.infoView.add("Start", this.formatDate(this.execution.getExecutionStartDate()));
            this.infoView.add("Type", this.executionState.getExecutionType().name());
            this.infoView.add("Status", statusDescription);
            this.infoView.add("Status Last updated", this.formatDate(this.executionState.getUpdateTime()));
            this.infoView.add("Container ID", this.executionState.getContainerId());
            this.infoView.optimizeTableView();
            this.actionExecutions.clear();
            List childIds = iLocation.findChildIds(ExecutionType.Workflow, this.execution.getId());
            if (childIds != null) {
                for (String id : childIds) {
                    ExecutionData actionData = iLocation.getExecutionData(this.execution.getId(), id);
                    ExecutionDataSetMeta dataSetMeta = actionData.getDataSetMeta();
                    if (dataSetMeta == null) continue;
                    String actionName = dataSetMeta.getName();
                    List executionDataList = this.actionExecutions.computeIfAbsent(actionName, k -> new ArrayList());
                    executionDataList.add(actionData);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error refreshing pipeline status", e);
        }
    }

    private void addDataTab() {
        this.dataTab = new CTabItem(this.tabFolder, 0);
        this.dataTab.setFont(GuiResource.getInstance().getFontDefault());
        this.dataTab.setImage(GuiResource.getInstance().getImageData());
        this.dataTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionViewer.DataTab.Title", (String[])new String[0]));
        this.dataSash = new SashForm((Composite)this.tabFolder, 256);
        this.dataList = new org.eclipse.swt.widgets.List((Composite)this.dataSash, 17156);
        PropsUi.setLook((Widget)this.dataList);
        this.dataList.addListener(13, e -> this.showDataRows());
        ColumnInfo[] dataColumns = new ColumnInfo[]{};
        this.dataView = new TableView(this.hopGui.getVariables(), (Composite)this.dataSash, 768, dataColumns, 0, true, null, this.props);
        PropsUi.setLook((Widget)this.dataView);
        this.dataView.optimizeTableView();
        this.dataSash.setWeights(new int[]{15, 85});
        this.dataTab.setControl((Control)this.dataSash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDataRows() {
        if (this.selectedExecutionData == null) {
            return;
        }
        int[] weights = this.dataSash.getWeights();
        try {
            String[] selection = this.dataList.getSelection();
            if (selection.length != 1) {
                return;
            }
            String setDescription = selection[0];
            for (ExecutionDataSetMeta setMeta : this.selectedExecutionData.getSetMetaData().values()) {
                if (!setDescription.equals(setMeta.getDescription())) continue;
                RowBuffer rowBuffer = (RowBuffer)this.selectedExecutionData.getDataSets().get(setMeta.getSetKey());
                ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
                IRowMeta rowMeta = rowBuffer.getRowMeta();
                for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
                    ColumnInfo columnInfo = new ColumnInfo(valueMeta.getName(), 1, valueMeta.isNumeric());
                    columnInfo.setValueMeta(valueMeta);
                    columnInfo.setToolTip(valueMeta.toStringMeta());
                    columns.add(columnInfo);
                }
                this.dataView.dispose();
                this.dataView = new TableView(this.hopGui.getVariables(), (Composite)this.dataSash, 768, columns.toArray(new ColumnInfo[0]), rowBuffer.size(), true, null, this.props);
                for (int r = 0; r < rowBuffer.size(); ++r) {
                    Object[] row = (Object[])rowBuffer.getBuffer().get(r);
                    TableItem item = this.dataView.table.getItem(r);
                    item.setText(0, Integer.toString(r + 1));
                    for (int c = 0; c < rowMeta.size(); ++c) {
                        String value = rowMeta.getString(row, c);
                        if (value == null) {
                            value = "";
                        }
                        item.setText(c + 1, value);
                    }
                }
                this.dataView.optWidth(true);
                break;
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error showing transform data rows", e);
        }
        finally {
            this.layout(true, true);
            this.dataSash.setWeights(weights);
        }
        this.redraw();
    }

    private void addLogTab() {
        this.logTab = new CTabItem(this.tabFolder, 0);
        this.logTab.setFont(GuiResource.getInstance().getFontDefault());
        this.logTab.setImage(GuiResource.getInstance().getImageShowLog());
        this.logTab.setText(BaseMessages.getString(PKG, (String)"WorkflowExecutionViewer.LogTab.Title", (String[])new String[0]));
        this.loggingText = new Text((Composite)this.tabFolder, 778);
        PropsUi.setLook((Widget)this.loggingText);
        this.logTab.setControl((Control)this.loggingText);
        this.tabFolder.addListener(13, e -> {
            if (this.tabFolder.getSelection() == this.logTab) {
                this.refreshLoggingText();
            }
        });
    }

    private void addPluginTabs() {
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        List tabsList = (List)guiRegistry.getGuiTabsMap().get(WORKFLOW_EXECUTION_VIEWER_TABS);
        if (tabsList != null) {
            tabsList.sort(Comparator.comparing(GuiTabItem::getId));
            for (GuiTabItem tabItem : tabsList) {
                try {
                    Class<?> pluginTabClass = tabItem.getMethod().getDeclaringClass();
                    boolean showTab = true;
                    try {
                        Method showTabMethod = pluginTabClass.getMethod("showTab", WorkflowExecutionViewer.class);
                        showTab = (Boolean)showTabMethod.invoke(null, this);
                    }
                    catch (NoSuchMethodException showTabMethod) {
                        // empty catch block
                    }
                    if (!showTab) continue;
                    Constructor<?> constructor = pluginTabClass.getConstructor(WorkflowExecutionViewer.class);
                    Object object = constructor.newInstance(this);
                    tabItem.getMethod().invoke(object, this.tabFolder);
                }
                catch (Exception e) {
                    new ErrorDialog(this.hopGui.getDisplay().getActiveShell(), "Error", "Hop was unable to invoke @GuiTab method " + tabItem.getMethod().getName() + " with the parent composite as argument", e);
                }
            }
            this.tabFolder.layout();
        }
    }

    @Override
    public Image getTitleImage() {
        return GuiResource.getInstance().getImageWorkflow();
    }

    @Override
    public String getTitleToolTip() {
        return this.workflowMeta.getDescription();
    }

    public void paintControl(PaintEvent e) {
        Point area = this.getArea();
        if (area.x == 0 || area.y == 0) {
            return;
        }
        boolean needsDoubleBuffering = Const.isWindows() && "GUI".equalsIgnoreCase(Const.getHopPlatformRuntime());
        Image image = null;
        GC swtGc = e.gc;
        if (needsDoubleBuffering) {
            image = new Image((Device)this.hopDisplay(), area.x, area.y);
            swtGc = new GC((Drawable)image);
        }
        this.drawWorkflowImage(swtGc, area.x, area.y, this.magnification);
        if (needsDoubleBuffering) {
            e.gc.drawImage(image, 0, 0);
            swtGc.dispose();
            image.dispose();
        }
        this.setZoomLabel();
    }

    @Override
    public void setZoomLabel() {
        String oldString;
        Combo combo = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (combo == null || combo.isDisposed()) {
            return;
        }
        String newString = Math.round(this.magnification * 100.0f) + "%";
        if (!newString.equals(oldString = combo.getText())) {
            combo.setText(Math.round(this.magnification * 100.0f) + "%");
        }
    }

    @Override
    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-ToolBar-10600-Zoom-Fit-To-Screen", toolTip="i18n::ExecutionViewer.GuiAction.ZoomFitToScreen.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-fit.svg")
    public void zoomFitToScreen() {
        super.zoomFitToScreen();
    }

    @Override
    protected Point getArea() {
        Rectangle rect = this.canvas.getClientArea();
        Point area = new Point(rect.width, rect.height);
        return area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawWorkflowImage(GC swtGc, int width, int height, float magnificationFactor) {
        SwtGc gc = new SwtGc(swtGc, width, height, this.iconSize);
        try {
            PropsUi propsUi = PropsUi.getInstance();
            int gridSize = propsUi.isShowCanvasGridEnabled() ? propsUi.getCanvasGridSize() : 1;
            WorkflowPainter workflowPainter = new WorkflowPainter((IGc)gc, this.hopGui.getVariables(), this.workflowMeta, new Point(width, height), new DPoint(0.0, 0.0), null, null, this.areaOwners, propsUi.getIconSize(), propsUi.getLineWidth(), gridSize, propsUi.getNoteFont().getName(), propsUi.getNoteFont().getHeight(), propsUi.getZoomFactor(), false);
            float correctedMagnification = (float)((double)magnificationFactor * propsUi.getZoomFactor());
            workflowPainter.setMagnification(correctedMagnification);
            workflowPainter.setOffset(this.offset);
            workflowPainter.setMaximum(this.maximum);
            workflowPainter.setShowingNavigationView(true);
            workflowPainter.setScreenMagnification(this.magnification);
            ArrayList<ActionResult> actionResults = new ArrayList<ActionResult>();
            ArrayList<ActionMeta> activeActions = new ArrayList<ActionMeta>();
            if (this.actionExecutions != null) {
                for (String actionName : this.actionExecutions.keySet()) {
                    ActionMeta actionMeta;
                    List<ExecutionData> executionDataList = this.actionExecutions.get(actionName);
                    if (executionDataList == null || executionDataList.isEmpty()) continue;
                    ExecutionData executionData = executionDataList.get(0);
                    RowBuffer rowBuffer = (RowBuffer)executionData.getDataSets().get("result");
                    if (rowBuffer != null) {
                        IRowMeta rowMeta = rowBuffer.getRowMeta();
                        Result result = new Result();
                        for (Object[] row : rowBuffer.getBuffer()) {
                            try {
                                if (rowMeta.getString(row, 0).equals("result?")) {
                                    result.setResult("true".equalsIgnoreCase(rowMeta.getString(row, 1)));
                                }
                                if (rowMeta.getString(row, 0).equals("errors")) {
                                    result.setNrErrors(Long.parseLong(rowMeta.getString(row, 1)));
                                }
                                if (!rowMeta.getString(row, 0).equals("stopped?")) continue;
                                result.setStopped("true".equalsIgnoreCase(rowMeta.getString(row, 1)));
                            }
                            catch (Exception e) {
                                LogChannel.UI.logError("Error getting action result information", (Throwable)e);
                            }
                        }
                        ActionResult actionResult = new ActionResult();
                        actionResult.setResult(result);
                        actionResult.setActionName(actionName);
                        actionResults.add(actionResult);
                    }
                    if (executionData.isFinished() || (actionMeta = this.workflowMeta.findAction(actionName)) == null) continue;
                    activeActions.add(actionMeta);
                }
            }
            workflowPainter.setActionResults(actionResults);
            workflowPainter.setActiveActions(activeActions);
            try {
                workflowPainter.drawWorkflow();
                this.viewPort = workflowPainter.getViewPort();
                this.graphPort = workflowPainter.getGraphPort();
            }
            catch (Exception e) {
                new ErrorDialog(this.hopGui.getDisplay().getActiveShell(), "Error", "Error drawing workflow image", e);
            }
        }
        finally {
            gc.dispose();
        }
        CanvasFacade.setData(this.canvas, this.magnification, this.offset, this.workflowMeta);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-Toolbar-10100-Refresh", toolTip="i18n::WorkflowExecutionViewer.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        this.refreshStatus();
        this.refreshActionData();
        this.setFocus();
    }

    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-ToolBar-10500-Zoom-Level", label="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Zoom", toolTip="i18n::HopGuiPipelineGraph.GuiAction.ZoomInOut.Tooltip", type=GuiToolbarElementType.COMBO, alignRight=true, comboValuesMethod="getZoomLevels")
    public void zoomLevel() {
        this.readMagnification();
        this.redraw();
    }

    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-Toolbar-11100-GoToEditor", toolTip="i18n::WorkflowExecutionViewer.ToolbarElement.NavigateToEditor.Tooltip", image="ui/images/data_orch.svg")
    public void navigateToEditor() {
        try {
            HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
            TabItemHandler item = perspective.findWorkflow(this.execution.getId());
            if (item != null) {
                perspective.switchToTab(item);
                perspective.activate();
                return;
            }
            String filename = this.execution.getFilename();
            if (filename != null) {
                this.hopGui.fileDelegate.fileOpen(filename);
                return;
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error navigating to workflow in Hop GUI", e);
        }
    }

    public List<String> getZoomLevels() {
        return Arrays.asList(PipelinePainter.magnificationDescriptions);
    }

    private void readMagnification() {
        Combo zoomLabel = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (zoomLabel == null) {
            return;
        }
        String possibleText = zoomLabel.getText().replace("%", "");
        try {
            float possibleFloatMagnification;
            this.magnification = possibleFloatMagnification = Float.parseFloat(possibleText) / 100.0f;
            if (zoomLabel.getText().indexOf(37) < 0) {
                zoomLabel.setText(zoomLabel.getText().concat("%"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refresh();
    }

    @Override
    public String getName() {
        return this.workflowMeta.getName();
    }

    @Override
    public String getLogChannelId() {
        return this.execution.getId();
    }

    @Override
    public String getActiveId() {
        if (this.selectedAction != null) {
            if (this.selectedExecutionData.getOwnerId() == null) {
                return this.selectedExecutionData.getParentId();
            }
            return this.selectedExecutionData.getOwnerId();
        }
        return this.getLogChannelId();
    }

    public void mouseDown(MouseEvent e) {
        boolean control;
        this.workflowMeta.unselectAll();
        Point real = this.screen2real(e.x, e.y);
        this.lastClick = new Point(real.x, real.y);
        boolean bl = control = (e.stateMask & SWT.MOD1) != 0;
        if (this.setupDragView(e.button, control, new Point(e.x, e.y))) {
            return;
        }
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner == null) {
            return;
        }
        switch (areaOwner.getAreaType()) {
            case ACTION_ICON: {
                this.selectedAction = (ActionMeta)areaOwner.getOwner();
                this.refreshActionData();
            }
        }
        this.redraw();
    }

    public void refreshActionData() {
        if (this.selectedAction != null) {
            this.showActionData(this.selectedAction);
        }
    }

    private void showActionData(ActionMeta actionMeta) {
        actionMeta.setSelected(true);
        String previousListSelection = null;
        if (this.dataList.getSelectionCount() == 1) {
            previousListSelection = this.dataList.getSelection()[0];
        }
        this.dataList.removeAll();
        try {
            List<ExecutionData> executionDataList = this.actionExecutions.get(actionMeta.getName());
            if (executionDataList == null || executionDataList.isEmpty()) {
                return;
            }
            this.selectedExecutionData = executionDataList.get(0);
            Map setMetaData = this.selectedExecutionData.getSetMetaData();
            ArrayList<String> items = new ArrayList<String>();
            for (String key : setMetaData.keySet()) {
                ExecutionDataSetMeta setMeta = (ExecutionDataSetMeta)setMetaData.get(key);
                if (!actionMeta.getName().equals(setMeta.getName())) continue;
                items.add(setMeta.getDescription());
            }
            Collections.sort(items);
            this.dataList.setItems(items.toArray(new String[0]));
            this.tabFolder.setSelection(this.dataTab);
            if (previousListSelection != null && items.contains(previousListSelection)) {
                this.dataList.setSelection(items.indexOf(previousListSelection));
            } else {
                this.dataList.setSelection(0);
            }
            this.showDataRows();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error showing transform data", e);
        }
    }

    @Override
    public void drillDownOnLocation(Point location) {
        if (location == null) {
            return;
        }
        AreaOwner areaOwner = this.getVisibleAreaOwner(location.x, location.y);
        if (areaOwner == null) {
            return;
        }
        if (areaOwner.getAreaType() == AreaOwner.AreaType.ACTION_ICON) {
            this.selectedAction = (ActionMeta)areaOwner.getOwner();
            this.refreshActionData();
            this.drillDown();
        }
    }

    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-Toolbar-11200-DrillDown", toolTip="i18n::WorkflowExecutionViewer.ToolbarElement.DrillDown.Tooltip", image="ui/images/down.svg")
    public void drillDown() {
        if (this.selectedExecutionData == null) {
            return;
        }
        ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
        if (location == null) {
            return;
        }
        IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
        try {
            Execution child;
            String id = this.selectedExecutionData.getOwnerId();
            List childExecutions = iLocation.findExecutions(id);
            if (childExecutions.isEmpty()) {
                return;
            }
            if (childExecutions.size() == 1) {
                child = (Execution)childExecutions.get(0);
            } else {
                IRowMeta rowMeta = new RowMetaBuilder().addString("Name").addString("Type").addDate("Start date").build();
                ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
                for (Execution childExecution : childExecutions) {
                    rows.add(new RowMetaAndData(rowMeta, new Object[]{childExecution.getName(), childExecution.getExecutionType().name(), childExecution.getExecutionStartDate()}));
                }
                SelectRowDialog dialog = new SelectRowDialog(this.getShell(), this.hopGui.getVariables(), 772, rows);
                RowMetaAndData selectedRow = dialog.open();
                if (selectedRow == null) {
                    return;
                }
                int index = rows.indexOf(selectedRow);
                if (index < 0) {
                    return;
                }
                child = (Execution)childExecutions.get(index);
            }
            ExecutionState state = iLocation.getExecutionState(child.getId(), false);
            this.perspective.createExecutionViewer(this.locationName, child, state);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error drilling down into selected action", e);
        }
    }

    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-Toolbar-11300-GoUp", toolTip="i18n::WorkflowExecutionViewer.ToolbarElement.GoUp.Tooltip", image="ui/images/up.svg")
    public void goUp() {
        try {
            String parentId = this.execution.getParentId();
            if (parentId == null) {
                return;
            }
            ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
            if (location == null) {
                return;
            }
            IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
            String grandParentId = iLocation.findParentId(parentId);
            if (grandParentId == null) {
                return;
            }
            Execution grandParent = iLocation.getExecution(grandParentId);
            ExecutionState state = iLocation.getExecutionState(grandParent.getId(), false);
            this.perspective.createExecutionViewer(this.locationName, grandParent, state);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error navigating up to parent execution", e);
        }
    }

    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-Toolbar-12000-ViewExecutor", toolTip="i18n::WorkflowExecutionViewer.ToolbarElement.ViewExecutor.Tooltip", image="ui/images/view.svg", separator=true)
    public void viewExecutor() {
        try {
            String workflowXml = this.execution.getExecutorXml();
            Node workflowNode = XmlHandler.loadXmlString((String)workflowXml, (String)"workflow");
            String metadataJson = this.execution.getMetadataJson();
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metadataJson);
            IVariables variables = Variables.getADefaultVariableSpace();
            variables.setVariables(this.execution.getVariableValues());
            variables.setVariables(this.execution.getParameterValues());
            WorkflowMeta workflowMeta = new WorkflowMeta(workflowNode, (IHopMetadataProvider)metadataProvider, variables);
            HopDataOrchestrationPerspective p = HopGui.getDataOrchestrationPerspective();
            HopGuiWorkflowGraph graph = (HopGuiWorkflowGraph)p.addWorkflow(this.hopGui, workflowMeta, new HopWorkflowFileType());
            graph.setVariables(variables);
            p.activate();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error viewing the executor", e);
        }
    }

    @GuiToolbarElement(root="WorkflowExecutionViewer-Toolbar", id="WorkflowExecutionViewer-Toolbar-12100-ViewMetadata", toolTip="i18n::WorkflowExecutionViewer.ToolbarElement.ViewMetadata.Tooltip", image="ui/images/metadata.svg")
    public void viewMetadata() {
        super.viewMetadata(this.execution);
    }
}

