/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ParDoTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;

public class WriteFilesTranslation {
    public static final String CUSTOM_JAVA_FILE_BASED_SINK_URN = "beam:file_based_sink:javasdk:0.1";

    @VisibleForTesting
    static RunnerApi.WriteFilesPayload payloadForWriteFiles(final WriteFiles<?, ?, ?> transform, SdkComponents components) throws IOException {
        return WriteFilesTranslation.payloadForWriteFilesLike(new WriteFilesLike(){

            @Override
            public RunnerApi.FunctionSpec translateSink(SdkComponents newComponents) {
                return WriteFilesTranslation.toProto(transform.getSink());
            }

            @Override
            public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView view : transform.getSink().getDynamicDestinations().getSideInputs()) {
                    sideInputs.put(view.getTagInternal().getId(), ParDoTranslation.translateView(view, components));
                }
                return sideInputs;
            }

            @Override
            public boolean isWindowedWrites() {
                return transform.getWindowedWrites();
            }

            @Override
            public boolean isRunnerDeterminedSharding() {
                return transform.getNumShardsProvider() == null && transform.getComputeNumShards() == null;
            }
        }, components);
    }

    private static RunnerApi.FunctionSpec toProto(FileBasedSink<?, ?, ?> sink) {
        return WriteFilesTranslation.toProto(CUSTOM_JAVA_FILE_BASED_SINK_URN, sink);
    }

    private static RunnerApi.FunctionSpec toProto(String urn, Serializable serializable) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(urn).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)serializable))).build();
    }

    @VisibleForTesting
    static FileBasedSink<?, ?, ?> sinkFromProto(RunnerApi.FunctionSpec sinkProto) throws IOException {
        Preconditions.checkArgument((boolean)sinkProto.getUrn().equals(CUSTOM_JAVA_FILE_BASED_SINK_URN), (String)"Cannot extract %s instance from %s with URN %s", (Object)FileBasedSink.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)sinkProto.getUrn());
        byte[] serializedSink = sinkProto.getPayload().toByteArray();
        return (FileBasedSink)SerializableUtils.deserializeFromByteArray((byte[])serializedSink, (String)FileBasedSink.class.getSimpleName());
    }

    public static <UserT, DestinationT, OutputT> FileBasedSink<UserT, DestinationT, OutputT> getSink(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.sinkFromProto(WriteFilesTranslation.getWriteFilesPayload(transform).getSink());
    }

    public static <UserT, DestinationT> List<PCollectionView<?>> getDynamicDestinationSideInputs(AppliedPTransform<PCollection<UserT>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create(transform.getPipeline().getOptions());
        RunnerApi.PTransform transformProto = PTransformTranslation.toProto(transform, sdkComponents);
        ArrayList views = Lists.newArrayList();
        Map sideInputs = WriteFilesTranslation.getWriteFilesPayload(transform).getSideInputsMap();
        for (Map.Entry entry : sideInputs.entrySet()) {
            PCollection originalPCollection = (PCollection)Preconditions.checkNotNull((Object)((PCollection)transform.getInputs().get(new TupleTag((String)entry.getKey()))), (String)"no input with tag %s", entry.getKey());
            views.add(PCollectionViewTranslation.viewFromProto((RunnerApi.SideInput)entry.getValue(), (String)entry.getKey(), originalPCollection, transformProto, RehydratedComponents.forComponents(sdkComponents.toComponents())));
        }
        return views;
    }

    public static <T, DestinationT> boolean isWindowedWrites(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getWindowedWrites();
    }

    public static <T, DestinationT> boolean isRunnerDeterminedSharding(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        return WriteFilesTranslation.getWriteFilesPayload(transform).getRunnerDeterminedSharding();
    }

    private static <T, DestinationT> RunnerApi.WriteFilesPayload getWriteFilesPayload(AppliedPTransform<PCollection<T>, WriteFilesResult<DestinationT>, ? extends PTransform<PCollection<T>, WriteFilesResult<DestinationT>>> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        return RunnerApi.WriteFilesPayload.parseFrom((ByteString)PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    public static RunnerApi.WriteFilesPayload payloadForWriteFilesLike(WriteFilesLike writeFiles, SdkComponents components) throws IOException {
        return RunnerApi.WriteFilesPayload.newBuilder().setSink(writeFiles.translateSink(components)).putAllSideInputs(writeFiles.translateSideInputs(components)).setWindowedWrites(writeFiles.isWindowedWrites()).setRunnerDeterminedSharding(writeFiles.isRunnerDeterminedSharding()).build();
    }

    private static interface WriteFilesLike {
        public RunnerApi.FunctionSpec translateSink(SdkComponents var1);

        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents var1);

        public boolean isWindowedWrites();

        public boolean isRunnerDeterminedSharding();
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<Class<? extends PTransform>, PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(WriteFiles.CONCRETE_CLASS, new WriteFilesTranslator());
        }
    }

    static class WriteFilesTranslator
    implements PTransformTranslation.TransformPayloadTranslator<WriteFiles<?, ?, ?>> {
        WriteFilesTranslator() {
        }

        @Override
        public String getUrn(WriteFiles<?, ?, ?> transform) {
            return "beam:transform:write_files:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, WriteFiles<?, ?, ?>> transform, SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((WriteFiles)transform.getTransform())).setPayload(WriteFilesTranslation.payloadForWriteFiles((WriteFiles)transform.getTransform(), components).toByteString()).build();
        }
    }

    static class RawWriteFiles
    extends PTransformTranslation.RawPTransform<PInput, POutput>
    implements WriteFilesLike {
        private final RunnerApi.PTransform protoTransform;
        private final transient RehydratedComponents rehydratedComponents;
        private final RunnerApi.FunctionSpec spec;
        private final RunnerApi.WriteFilesPayload payload;

        public RawWriteFiles(RunnerApi.PTransform protoTransform, RehydratedComponents rehydratedComponents) throws IOException {
            this.rehydratedComponents = rehydratedComponents;
            this.protoTransform = protoTransform;
            this.spec = protoTransform.getSpec();
            this.payload = RunnerApi.WriteFilesPayload.parseFrom((ByteString)this.spec.getPayload());
        }

        @Override
        public RunnerApi.FunctionSpec getSpec() {
            return this.spec;
        }

        @Override
        public RunnerApi.FunctionSpec migrate(SdkComponents components) throws IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:write_files:v1").setPayload(WriteFilesTranslation.payloadForWriteFilesLike(this, components).toByteString()).build();
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            HashMap additionalInputs = new HashMap();
            for (Map.Entry sideInputEntry : this.payload.getSideInputsMap().entrySet()) {
                try {
                    additionalInputs.put((TupleTag<?>)new TupleTag((String)sideInputEntry.getKey()), (PValue)this.rehydratedComponents.getPCollection(this.protoTransform.getInputsOrThrow((String)sideInputEntry.getKey())));
                }
                catch (IOException exc) {
                    throw new IllegalStateException(String.format("Could not find input with name %s for %s transform", sideInputEntry.getKey(), WriteFiles.class.getSimpleName()));
                }
            }
            return additionalInputs;
        }

        @Override
        public RunnerApi.FunctionSpec translateSink(SdkComponents newComponents) {
            return this.payload.getSink();
        }

        @Override
        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
            return (Map)MoreObjects.firstNonNull((Object)this.payload.getSideInputsMap(), Collections.emptyMap());
        }

        @Override
        public boolean isWindowedWrites() {
            return this.payload.getWindowedWrites();
        }

        @Override
        public boolean isRunnerDeterminedSharding() {
            return this.payload.getRunnerDeterminedSharding();
        }
    }
}

