/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class AfterEachStateMachine
extends TriggerStateMachine {
    private AfterEachStateMachine(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TriggerStateMachine> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument((subTriggers.size() > 1 ? 1 : 0) != 0);
    }

    @Override
    public void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnElement(c.forTrigger(subTrigger));
        }
    }

    @SafeVarargs
    public static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine inOrder(TriggerStateMachine ... triggers) {
        return new AfterEachStateMachine(Arrays.asList(triggers));
    }

    public static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine inOrder(@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TriggerStateMachine> triggers) {
        return new AfterEachStateMachine((List<TriggerStateMachine>)ImmutableList.copyOf(triggers));
    }

    @Override
    public void onElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (!c.trigger().isMerging()) {
            c.trigger().firstUnfinishedSubTrigger().invokeOnElement(c);
        } else {
            for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
                subTrigger.invokeOnElement(c);
            }
        }
    }

    @Override
    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnMerge(c.forTrigger(subTrigger));
        }
    }

    @Override
    public void onMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        boolean priorTriggersAllFinished = true;
        for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
            if (priorTriggersAllFinished) {
                subTrigger.invokeOnMerge(context);
                priorTriggersAllFinished &= context.forTrigger(subTrigger).trigger().isFinished();
                continue;
            }
            subTrigger.invokeClear(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    public void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchShouldFire(c.forTrigger(subTrigger));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ExecutableTriggerStateMachine firstUnfinished = context.trigger().firstUnfinishedSubTrigger();
        return firstUnfinished.invokeShouldFire(context);
    }

    @Override
    public void onFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        context.trigger().firstUnfinishedSubTrigger().invokeOnFire(context);
        if (context.trigger().isMerging()) {
            for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
                subTrigger.invokeClear(context);
            }
        }
        this.updateFinishedState(context);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterEach.inOrder(");
        Joiner.on((String)", ").appendTo(builder, (Iterable)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }

    private void updateFinishedState(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) {
        context.trigger().setFinished(context.trigger().firstUnfinishedSubTrigger() == null);
    }
}

