/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Collections;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

class ImpulseEvaluatorFactory
implements TransformEvaluatorFactory {
    private final EvaluationContext ctxt;

    ImpulseEvaluatorFactory(EvaluationContext ctxt) {
        this.ctxt = ctxt;
    }

    @Override
    public <InputT> @Nullable TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) {
        return new ImpulseEvaluator(this.ctxt, application);
    }

    @Override
    public void cleanup() {
    }

    @VisibleForTesting
    static class ImpulseShard {
        ImpulseShard() {
        }
    }

    static class ImpulseRootProvider
    implements RootInputProvider<byte[], ImpulseShard, PBegin> {
        private final EvaluationContext ctxt;

        ImpulseRootProvider(EvaluationContext ctxt) {
            this.ctxt = ctxt;
        }

        @Override
        public Collection<CommittedBundle<ImpulseShard>> getInitialInputs(AppliedPTransform<PBegin, PCollection<byte[]>, PTransform<PBegin, PCollection<byte[]>>> transform, int targetParallelism) {
            return Collections.singleton(this.ctxt.createRootBundle().add(WindowedValue.valueInGlobalWindow((Object)new ImpulseShard())).commit(BoundedWindow.TIMESTAMP_MIN_VALUE));
        }
    }

    private static class ImpulseEvaluator
    implements TransformEvaluator<ImpulseShard> {
        private final EvaluationContext ctxt;
        private final AppliedPTransform<?, PCollection<byte[]>, Impulse> transform;
        private final StepTransformResult.Builder<ImpulseShard> result;

        private ImpulseEvaluator(EvaluationContext ctxt, AppliedPTransform<?, PCollection<byte[]>, Impulse> transform) {
            this.ctxt = ctxt;
            this.transform = transform;
            this.result = StepTransformResult.withoutHold(transform);
        }

        @Override
        public void processElement(WindowedValue<ImpulseShard> element) throws Exception {
            PCollection outputPCollection = (PCollection)Iterables.getOnlyElement(this.transform.getOutputs().values());
            this.result.addOutput(this.ctxt.createBundle(outputPCollection).add(WindowedValue.valueInGlobalWindow((Object)new byte[0])), new UncommittedBundle[0]);
        }

        @Override
        public TransformResult<ImpulseShard> finishBundle() throws Exception {
            return this.result.build();
        }
    }
}

