/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalytics.model.transform.S3ConfigurationMarshaller;
import java.io.Serializable;

public class S3Configuration
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleARN;
    private String bucketARN;
    private String fileKey;

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public S3Configuration withRoleARN(String roleARN) {
        this.setRoleARN(roleARN);
        return this;
    }

    public void setBucketARN(String bucketARN) {
        this.bucketARN = bucketARN;
    }

    public String getBucketARN() {
        return this.bucketARN;
    }

    public S3Configuration withBucketARN(String bucketARN) {
        this.setBucketARN(bucketARN);
        return this;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public S3Configuration withFileKey(String fileKey) {
        this.setFileKey(fileKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleARN() != null) {
            sb.append("RoleARN: ").append(this.getRoleARN()).append(",");
        }
        if (this.getBucketARN() != null) {
            sb.append("BucketARN: ").append(this.getBucketARN()).append(",");
        }
        if (this.getFileKey() != null) {
            sb.append("FileKey: ").append(this.getFileKey());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Configuration)) {
            return false;
        }
        S3Configuration other = (S3Configuration)obj;
        if (other.getRoleARN() == null ^ this.getRoleARN() == null) {
            return false;
        }
        if (other.getRoleARN() != null && !other.getRoleARN().equals(this.getRoleARN())) {
            return false;
        }
        if (other.getBucketARN() == null ^ this.getBucketARN() == null) {
            return false;
        }
        if (other.getBucketARN() != null && !other.getBucketARN().equals(this.getBucketARN())) {
            return false;
        }
        if (other.getFileKey() == null ^ this.getFileKey() == null) {
            return false;
        }
        return other.getFileKey() == null || other.getFileKey().equals(this.getFileKey());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleARN() == null ? 0 : this.getRoleARN().hashCode());
        hashCode = 31 * hashCode + (this.getBucketARN() == null ? 0 : this.getBucketARN().hashCode());
        hashCode = 31 * hashCode + (this.getFileKey() == null ? 0 : this.getFileKey().hashCode());
        return hashCode;
    }

    public S3Configuration clone() {
        try {
            return (S3Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

