/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import org.apache.beam.sdk.io.gcp.pubsub.PubsubWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_PubsubWriteSchemaTransformConfiguration
extends PubsubWriteSchemaTransformConfiguration {
    private final String format;
    private final String topic;

    private AutoValue_PubsubWriteSchemaTransformConfiguration(String format, String topic) {
        this.format = format;
        this.topic = topic;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub. Valid options are: AVRO,JSON")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="The name of the topic to write data to. Format: projects/${PROJECT}/topics/${TOPIC}")
    public String getTopic() {
        return this.topic;
    }

    public String toString() {
        return "PubsubWriteSchemaTransformConfiguration{format=" + this.format + ", topic=" + this.topic + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubWriteSchemaTransformConfiguration) {
            PubsubWriteSchemaTransformConfiguration that = (PubsubWriteSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && this.topic.equals(that.getTopic());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        return h$ ^= this.topic.hashCode();
    }

    static final class Builder
    extends PubsubWriteSchemaTransformConfiguration.Builder {
        private String format;
        private String topic;

        Builder() {
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public PubsubWriteSchemaTransformConfiguration build() {
            if (this.format == null || this.topic == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.topic == null) {
                    missing.append(" topic");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubWriteSchemaTransformConfiguration(this.format, this.topic);
        }
    }
}

