/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.LateDataUtils;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.TimerInternalsFactory;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.core.construction.graph.UserStateReference;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageContextFactory;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.utils.FlinkPortableRunnerUtils;
import org.apache.beam.runners.flink.translation.utils.Locker;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingDoFnRunner;
import org.apache.beam.runners.flink.translation.wrappers.streaming.state.FlinkStateInternals;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandler;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandlers;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandler;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandlers;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.runners.fnexecution.translation.StreamingSideInputHandlerFactory;
import org.apache.beam.runners.fnexecution.wire.ByteStringCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class ExecutableStageDoFnOperator<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends DoFnOperator<InputT, OutputT> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ExecutableStageDoFnOperator.class);
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload payload;
    private final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
    private final @UnknownKeyFor @NonNull @Initialized FlinkExecutableStageContextFactory contextFactory;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputMap;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputIds;
    private final @UnknownKeyFor @NonNull @Initialized ReentrantLock stateBackendLock;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized boolean isStateful;
    private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputCoder;
    private transient @UnknownKeyFor @NonNull @Initialized ExecutableStageContext stageContext;
    private transient @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler;
    private transient @UnknownKeyFor @NonNull @Initialized BundleProgressHandler progressHandler;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BundleFinalizationHandlers.InMemoryFinalizer finalizationHandler;
    private transient @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler checkpointHandler;
    private transient @UnknownKeyFor @NonNull @Initialized boolean hasSdfProcessFn;
    private transient @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory;
    private transient @UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage;
    private transient @UnknownKeyFor @NonNull @Initialized SdkHarnessDoFnRunner<InputT, OutputT> sdkHarnessRunner;
    private transient @UnknownKeyFor @NonNull @Initialized long minEventTimeTimerTimestampInLastBundle;
    private transient @UnknownKeyFor @NonNull @Initialized long minEventTimeTimerTimestampInCurrentBundle;
    private @UnknownKeyFor @NonNull @Initialized long inputWatermarkBeforeBundleStart = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
    private transient @UnknownKeyFor @NonNull @Initialized boolean closed;

    public ExecutableStageDoFnOperator(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> windowedInputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized DoFnOperator.OutputManagerFactory<OutputT> outputManagerFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputTagMapping, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputIds, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload payload, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo, @UnknownKeyFor @NonNull @Initialized FlinkExecutableStageContextFactory contextFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputMap, @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy, @UnknownKeyFor @NonNull @Initialized Coder keyCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KeySelector<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keySelector) {
        super(FlinkPortableRunnerUtils.requiresStableInput(payload) ? new StableNoOpDoFn() : new NoOpDoFn(), stepName, windowedInputCoder, outputCoders, mainOutputTag, additionalOutputTags, outputManagerFactory, windowingStrategy, sideInputTagMapping, sideInputs, options, keyCoder, keySelector, DoFnSchemaInformation.create(), Collections.emptyMap());
        this.isStateful = payload.getUserStatesCount() > 0 || payload.getTimersCount() > 0;
        this.payload = payload;
        this.jobInfo = jobInfo;
        this.contextFactory = contextFactory;
        this.outputMap = outputMap;
        this.sideInputIds = sideInputIds;
        this.stateBackendLock = new ReentrantLock();
        this.windowCoder = windowingStrategy.getWindowFn().windowCoder();
        this.inputCoder = windowedInputCoder;
        this.pipelineOptions = new SerializablePipelineOptions(options);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!windowedInputCoder.getCoderArguments().isEmpty() ? 1 : 0) != 0, (String)"Empty arguments for WindowedValue Coder %s", windowedInputCoder);
    }

    @Override
    <K> @Nullable @UnknownKeyFor @Initialized KeyedStateBackend<K> getBufferingKeyedStateBackend() {
        return this.isStateful ? super.getKeyedStateBackend() : null;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Lock getLockToAcquireForStateAccessDuringBundles() {
        return this.stateBackendLock;
    }

    @Override
    public void open() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.executableStage = ExecutableStage.fromPayload((RunnerApi.ExecutableStagePayload)this.payload);
        this.hasSdfProcessFn = this.hasSDF(this.executableStage);
        ExecutableStageDoFnOperator.initializeUserState(this.executableStage, this.getKeyedStateBackend(), this.pipelineOptions);
        this.stageContext = this.contextFactory.get(this.jobInfo);
        this.stageBundleFactory = this.stageContext.getStageBundleFactory(this.executableStage);
        this.stateRequestHandler = this.getStateRequestHandler(this.executableStage);
        this.progressHandler = new BundleProgressHandler(){

            public void onProgress(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleProgressResponse progress) {
                if (ExecutableStageDoFnOperator.this.flinkMetricContainer != null) {
                    ExecutableStageDoFnOperator.this.flinkMetricContainer.updateMetrics(ExecutableStageDoFnOperator.this.stepName, progress.getMonitoringInfosList());
                }
            }

            public void onCompleted(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleResponse response) {
                if (ExecutableStageDoFnOperator.this.flinkMetricContainer != null) {
                    ExecutableStageDoFnOperator.this.flinkMetricContainer.updateMetrics(ExecutableStageDoFnOperator.this.stepName, response.getMonitoringInfosList());
                }
            }
        };
        this.finalizationHandler = BundleFinalizationHandlers.inMemoryFinalizer((InstructionRequestHandler)this.stageBundleFactory.getInstructionRequestHandler());
        this.checkpointHandler = this.getBundleCheckpointHandler(this.hasSdfProcessFn);
        this.minEventTimeTimerTimestampInCurrentBundle = Long.MAX_VALUE;
        this.minEventTimeTimerTimestampInLastBundle = Long.MAX_VALUE;
        super.setPreBundleCallback(this::preBundleStartCallback);
        super.setBundleFinishedCallback(this::finishBundleCallback);
        super.open();
    }

    @Override
    public final void notifyCheckpointComplete(@UnknownKeyFor @NonNull @Initialized long checkpointId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.finalizationHandler.finalizeAllOutstandingBundles();
    }

    private @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler getBundleCheckpointHandler(@UnknownKeyFor @NonNull @Initialized boolean hasSDF) {
        if (!hasSDF) {
            return response -> {
                throw new UnsupportedOperationException("Self-checkpoint is only supported on splittable DoFn.");
            };
        }
        return new BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler((TimerInternalsFactory)new SdfFlinkTimerInternalsFactory(), (StateInternalsFactory)new SdfFlinkStateInternalsFactory(), this.inputCoder, this.windowCoder);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasSDF(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
        return executableStage.getTransforms().stream().anyMatch(pTransformNode -> pTransformNode.getTransform().getSpec().getUrn().equals("beam:transform:sdf_process_sized_element_and_restrictions:v1"));
    }

    private @UnknownKeyFor @NonNull @Initialized StateRequestHandler getStateRequestHandler(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage) {
        StateRequestHandler userStateRequestHandler;
        StateRequestHandler sideInputStateHandler;
        if (executableStage.getSideInputs().size() > 0) {
            Preconditions.checkNotNull((Object)this.sideInputHandler);
            StateRequestHandlers.SideInputHandlerFactory sideInputHandlerFactory = (StateRequestHandlers.SideInputHandlerFactory)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)StreamingSideInputHandlerFactory.forStage((ExecutableStage)executableStage, this.sideInputIds, (SideInputHandler)this.sideInputHandler));
            try {
                sideInputStateHandler = StateRequestHandlers.forSideInputHandlerFactory((Map)ProcessBundleDescriptors.getSideInputs((ExecutableStage)executableStage), (StateRequestHandlers.SideInputHandlerFactory)sideInputHandlerFactory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize SideInputHandler", e);
            }
        } else {
            sideInputStateHandler = StateRequestHandler.unsupported();
        }
        if (!executableStage.getUserStates().isEmpty()) {
            if (this.keyedStateInternals == null) {
                throw new IllegalStateException("Input must be keyed when user state is used");
            }
            userStateRequestHandler = StateRequestHandlers.forBagUserStateHandlerFactory((ProcessBundleDescriptors.ExecutableProcessBundleDescriptor)this.stageBundleFactory.getProcessBundleDescriptor(), new BagUserStateFactory(this.keyedStateInternals, (KeyedStateBackend<ByteBuffer>)this.getKeyedStateBackend(), this.stateBackendLock, this.keyCoder));
        } else {
            userStateRequestHandler = StateRequestHandler.unsupported();
        }
        EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler> handlerMap = new EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler>(BeamFnApi.StateKey.TypeCase.class);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.ITERABLE_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_KEYS_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.BAG_USER_STATE, userStateRequestHandler);
        return StateRequestHandlers.delegateBasedUponType(handlerMap);
    }

    public void setKeyContextElement1(@UnknownKeyFor @NonNull @Initialized StreamRecord record) {
    }

    public void setCurrentKey(@UnknownKeyFor @NonNull @Initialized Object key) {
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer getCurrentKey() {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.stateBackendLock.isLocked(), (Object)"State backend must be locked when retrieving the current key.");
        return (ByteBuffer)this.getKeyedStateBackend().getCurrentKey();
    }

    void setTimer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> timerElement, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        try {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.sdkHarnessRunner.isBundleInProgress(), (Object)"Bundle was expected to be in progress!!");
            LOG.debug("Setting timer: {} {}", timerElement, (Object)timerData);
            ByteBuffer encodedKey = (ByteBuffer)this.keySelector.getKey((Object)WindowedValue.valueInGlobalWindow((Object)KV.of((Object)timerElement.getUserKey(), null)));
            try (Locker locker = Locker.locked(this.stateBackendLock);){
                this.getKeyedStateBackend().setCurrentKey((Object)encodedKey);
                if (timerElement.getClearBit()) {
                    this.timerInternals.deleteTimer(timerData);
                } else {
                    this.timerInternals.setTimer(timerData);
                    if (!timerData.getTimerId().equals("__StatefulParDoGcTimerId")) {
                        this.minEventTimeTimerTimestampInCurrentBundle = Math.min(this.minEventTimeTimerTimestampInCurrentBundle, ExecutableStageDoFnOperator.adjustTimestampForFlink(timerData.getTimestamp().getMillis()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't set timer", e);
        }
    }

    @Override
    protected void fireTimerInternal(@UnknownKeyFor @NonNull @Initialized ByteBuffer key, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
        try (Locker locker = Locker.locked(this.stateBackendLock);){
            this.getKeyedStateBackend().setCurrentKey((Object)key);
            this.fireTimer(timer);
        }
    }

    @Override
    public void flushData() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.closed = true;
        this.processWatermark1(Watermark.MAX_WATERMARK);
        while (this.getCurrentOutputWatermark() < Watermark.MAX_WATERMARK.getTimestamp()) {
            this.invokeFinishBundle();
            if (!this.hasSdfProcessFn || this.numProcessingTimeTimers() <= 0) continue;
            this.timerInternals.processPendingProcessingTimeTimers();
        }
        super.flushData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.stageContext != null) {
            try (StageBundleFactory bundleFactoryCloser = this.stageBundleFactory;
                 ExecutableStageContext closable = this.stageContext;){
                super.cleanUp();
            }
            finally {
                this.stageContext = null;
            }
        }
    }

    @Override
    protected void addSideInputValue(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized RawUnionValue> streamRecord) {
        WindowedValue value = (WindowedValue)((RawUnionValue)streamRecord.getValue()).getValue();
        PCollectionView sideInput = (PCollectionView)this.sideInputTagMapping.get(((RawUnionValue)streamRecord.getValue()).getUnionTag());
        this.sideInputHandler.addSideInputValue(sideInput, value.withValue((Object)((Iterable)((KV)value.getValue()).getValue())));
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> createBufferingDoFnRunnerIfNeeded(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> wrappedRunner) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.requiresStableInput) {
            KeyedStateBackend keyedBufferingBackend = this.getBufferingKeyedStateBackend();
            this.bufferingDoFnRunner = BufferingDoFnRunner.create(wrappedRunner, "stable-input-buffer", this.windowedInputCoder, this.windowingStrategy.getWindowFn().windowCoder(), this.getOperatorStateBackend(), keyedBufferingBackend, this.numConcurrentCheckpoints, this.serializedOptions, keyedBufferingBackend != null ? () -> Locker.locked(this.stateBackendLock) : null, keyedBufferingBackend != null ? input -> FlinkKeyUtils.encodeKey(((KV)input).getKey(), this.keyCoder) : null, () -> this.sdkHarnessRunner.emitResults());
            return this.bufferingDoFnRunner;
        }
        return wrappedRunner;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> createWrappingDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> wrappedRunner, @UnknownKeyFor @NonNull @Initialized StepContext stepContext) {
        this.sdkHarnessRunner = new SdkHarnessDoFnRunner(wrappedRunner.getFn(), this.stageBundleFactory, this.stateRequestHandler, this.progressHandler, (BundleFinalizationHandler)this.finalizationHandler, this.checkpointHandler, this.outputManager, this.outputMap, (Coder<BoundedWindow>)this.windowCoder, this.inputCoder, this::setTimer, () -> FlinkKeyUtils.decodeKey(this.getCurrentKey(), this.keyCoder), this.keyedStateInternals);
        return this.ensureStateDoFnRunner(this.sdkHarnessRunner, this.payload, stepContext);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long applyInputWatermarkHold(@UnknownKeyFor @NonNull @Initialized long inputWatermark) {
        if (this.sdkHarnessRunner.isBundleInProgress()) {
            return this.inputWatermarkBeforeBundleStart;
        }
        return inputWatermark;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long applyOutputWatermarkHold(@UnknownKeyFor @NonNull @Initialized long currentOutputWatermark, @UnknownKeyFor @NonNull @Initialized long potentialOutputWatermark) {
        potentialOutputWatermark = super.applyOutputWatermarkHold(currentOutputWatermark, potentialOutputWatermark);
        if (this.sdkHarnessRunner.isBundleInProgress()) {
            if (this.minEventTimeTimerTimestampInLastBundle < Long.MAX_VALUE) {
                return Math.min(this.minEventTimeTimerTimestampInLastBundle - 1L, potentialOutputWatermark);
            }
            return currentOutputWatermark;
        }
        return potentialOutputWatermark;
    }

    private void preBundleStartCallback() {
        this.inputWatermarkBeforeBundleStart = this.getEffectiveInputWatermark();
    }

    private void finishBundleCallback() {
        this.minEventTimeTimerTimestampInLastBundle = this.minEventTimeTimerTimestampInCurrentBundle;
        this.minEventTimeTimerTimestampInCurrentBundle = Long.MAX_VALUE;
        try {
            if (!this.closed && this.minEventTimeTimerTimestampInLastBundle < Long.MAX_VALUE && this.minEventTimeTimerTimestampInLastBundle <= this.getEffectiveInputWatermark()) {
                this.scheduleForCurrentProcessingTime(ts -> this.processWatermark1(new Watermark(this.getEffectiveInputWatermark())));
            } else {
                this.processWatermark1(new Watermark(this.getEffectiveInputWatermark()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to progress watermark to " + this.getEffectiveInputWatermark(), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> ensureStateDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> sdkHarnessRunner, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload payload, @UnknownKeyFor @NonNull @Initialized StepContext stepContext) {
        if (!this.isStateful) {
            return sdkHarnessRunner;
        }
        Coder windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
        CleanupTimer cleanupTimer = new CleanupTimer(this.timerInternals, this.stateBackendLock, this.windowingStrategy, this.keyCoder, windowCoder, (KeyedStateBackend<ByteBuffer>)this.getKeyedStateBackend());
        List<String> userStates = this.executableStage.getUserStates().stream().map(UserStateReference::localName).collect(Collectors.toList());
        final KeyedStateBackend stateBackend = this.getKeyedStateBackend();
        final StateCleaner stateCleaner = new StateCleaner(userStates, windowCoder, () -> ((KeyedStateBackend)stateBackend).getCurrentKey(), (ThrowingFunction<Long, Boolean>)((ThrowingFunction)this.timerInternals::hasPendingEventTimeTimers), cleanupTimer);
        return new StatefulDoFnRunner<InputT, OutputT, BoundedWindow>(sdkHarnessRunner, this.getInputCoder(), stepContext, this.windowingStrategy, cleanupTimer, stateCleaner, FlinkPortableRunnerUtils.requiresTimeSortedInput(payload, true)){

            public void finishBundle() {
                super.finishBundle();
                if (!stateCleaner.cleanupQueue.isEmpty()) {
                    try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                        stateCleaner.cleanupState(ExecutableStageDoFnOperator.this.keyedStateInternals, arg_0 -> ((KeyedStateBackend)stateBackend).setCurrentKey(arg_0));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to cleanup state.", e);
                    }
                }
            }
        };
    }

    private static void initializeUserState(@UnknownKeyFor @NonNull @Initialized ExecutableStage executableStage, @Nullable @UnknownKeyFor @Initialized KeyedStateBackend keyedStateBackend, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
        executableStage.getUserStates().forEach(ref -> {
            try {
                keyedStateBackend.getOrCreateKeyedState((TypeSerializer)StringSerializer.INSTANCE, (StateDescriptor)new ListStateDescriptor(ref.localName(), new CoderTypeSerializer(ByteStringCoder.of(), pipelineOptions)));
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't initialize user states.", e);
            }
        });
    }

    private static class StableNoOpDoFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends DoFn<InputT, OutputT> {
        private StableNoOpDoFn() {
        }

        @DoFn.RequiresStableInput
        @DoFn.ProcessElement
        public void doNothing(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
        }
    }

    private static class NoOpDoFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends DoFn<InputT, OutputT> {
        private NoOpDoFn() {
        }

        @DoFn.ProcessElement
        public void doNothing(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
        }
    }

    static class StateCleaner
    implements StatefulDoFnRunner.StateCleaner<BoundedWindow> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> userStateNames;
        private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized ArrayDeque<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteBuffer, @UnknownKeyFor @NonNull @Initialized BoundedWindow>> cleanupQueue;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ByteBuffer> currentKeySupplier;
        private final @UnknownKeyFor @NonNull @Initialized ThrowingFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Boolean> hasPendingEventTimeTimers;
        private final @UnknownKeyFor @NonNull @Initialized CleanupTimer cleanupTimer;

        StateCleaner(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> userStateNames, @UnknownKeyFor @NonNull @Initialized Coder windowCoder, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ByteBuffer> currentKeySupplier, @UnknownKeyFor @NonNull @Initialized ThrowingFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Boolean> hasPendingEventTimeTimers, @UnknownKeyFor @NonNull @Initialized CleanupTimer cleanupTimer) {
            this.userStateNames = userStateNames;
            this.windowCoder = windowCoder;
            this.currentKeySupplier = currentKeySupplier;
            this.hasPendingEventTimeTimers = hasPendingEventTimeTimers;
            this.cleanupTimer = cleanupTimer;
            this.cleanupQueue = new ArrayDeque();
        }

        public void clearForWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            this.cleanupQueue.add((KV<ByteBuffer, BoundedWindow>)KV.of((Object)this.currentKeySupplier.get(), (Object)window));
        }

        void cleanupState(@UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized ByteBuffer> keyContextConsumer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            while (!this.cleanupQueue.isEmpty()) {
                KV kv = (KV)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(this.cleanupQueue.remove());
                BoundedWindow window = (BoundedWindow)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((BoundedWindow)kv.getValue()));
                keyContextConsumer.accept((ByteBuffer)kv.getKey());
                if (((Boolean)this.hasPendingEventTimeTimers.apply((Object)window.maxTimestamp().getMillis())).booleanValue()) {
                    this.cleanupTimer.setCleanupTimer(window);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("State cleanup for {} {}", (Object)Arrays.toString(((ByteBuffer)kv.getKey()).array()), (Object)window);
                }
                for (String userState : this.userStateNames) {
                    StateNamespace namespace = StateNamespaces.window((Coder)this.windowCoder, (BoundedWindow)window);
                    StateTag bagStateStateTag = StateTags.bag((String)userState, (Coder)VoidCoder.of());
                    BagState state = (BagState)stateInternals.state(namespace, bagStateStateTag);
                    state.clear();
                }
            }
        }
    }

    static class CleanupTimer<@UnknownKeyFor InputT>
    implements StatefulDoFnRunner.CleanupTimer<InputT> {
        private static final @UnknownKeyFor @NonNull @Initialized String GC_TIMER_ID = "__user-state-cleanup__";
        private final @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals;
        private final @UnknownKeyFor @NonNull @Initialized Lock stateBackendLock;
        private final @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized Coder keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<@UnknownKeyFor @NonNull @Initialized ByteBuffer> keyedStateBackend;

        CleanupTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals, @UnknownKeyFor @NonNull @Initialized Lock stateBackendLock, @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy, @UnknownKeyFor @NonNull @Initialized Coder keyCoder, @UnknownKeyFor @NonNull @Initialized Coder windowCoder, @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<@UnknownKeyFor @NonNull @Initialized ByteBuffer> keyedStateBackend) {
            this.timerInternals = timerInternals;
            this.stateBackendLock = stateBackendLock;
            this.windowingStrategy = windowingStrategy;
            this.keyCoder = keyCoder;
            this.windowCoder = windowCoder;
            this.keyedStateBackend = keyedStateBackend;
        }

        public void setForWindow(InputT input, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(input, (Object)"Null input passed to CleanupTimer");
            if (window.equals(GlobalWindow.INSTANCE)) {
                return;
            }
            ByteBuffer key = FlinkKeyUtils.encodeKey(((KV)input).getKey(), this.keyCoder);
            try (Locker locker = Locker.locked(this.stateBackendLock);){
                this.keyedStateBackend.setCurrentKey((Object)key);
                this.setCleanupTimer(window);
            }
        }

        void setCleanupTimer(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            Instant gcTime = LateDataUtils.garbageCollectionTime((BoundedWindow)window, (WindowingStrategy)this.windowingStrategy).plus((ReadableDuration)Duration.millis((long)1L));
            this.timerInternals.setTimer(StateNamespaces.window((Coder)this.windowCoder, (BoundedWindow)window), GC_TIMER_ID, "", gcTime, window.maxTimestamp(), TimeDomain.EVENT_TIME);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isForWindow(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            boolean isEventTimer = timeDomain.equals((Object)TimeDomain.EVENT_TIME);
            Instant gcTime = LateDataUtils.garbageCollectionTime((BoundedWindow)window, (WindowingStrategy)this.windowingStrategy).plus((ReadableDuration)Duration.millis((long)1L));
            return isEventTimer && GC_TIMER_ID.equals(timerId) && gcTime.equals((Object)timestamp);
        }
    }

    private static class SdkHarnessDoFnRunner<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements DoFnRunner<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
        private final @UnknownKeyFor @NonNull @Initialized LinkedBlockingQueue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, OutputT>> outputQueue;
        private final @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory;
        private final @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler;
        private final @UnknownKeyFor @NonNull @Initialized BundleProgressHandler progressHandler;
        private final @UnknownKeyFor @NonNull @Initialized BundleFinalizationHandler finalizationHandler;
        private final @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler checkpointHandler;
        private final @UnknownKeyFor @NonNull @Initialized DoFnOperator.BufferedOutputManager<OutputT> outputManager;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputMap;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FlinkStateInternals<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyedStateInternals;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> residualCoder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerRegistration;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Object> keyForTimer;
        private volatile @UnknownKeyFor @NonNull @Initialized RemoteBundle remoteBundle;
        private volatile /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> mainInputReceiver;

        public SdkHarnessDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized StageBundleFactory stageBundleFactory, @UnknownKeyFor @NonNull @Initialized StateRequestHandler stateRequestHandler, @UnknownKeyFor @NonNull @Initialized BundleProgressHandler progressHandler, @UnknownKeyFor @NonNull @Initialized BundleFinalizationHandler finalizationHandler, @UnknownKeyFor @NonNull @Initialized BundleCheckpointHandler checkpointHandler, @UnknownKeyFor @NonNull @Initialized DoFnOperator.BufferedOutputManager<OutputT> outputManager, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputMap, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> residualCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerRegistration, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Object> keyForTimer, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FlinkStateInternals<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyedStateInternals) {
            this.doFn = doFn;
            this.stageBundleFactory = stageBundleFactory;
            this.stateRequestHandler = stateRequestHandler;
            this.progressHandler = progressHandler;
            this.finalizationHandler = finalizationHandler;
            this.checkpointHandler = checkpointHandler;
            this.outputManager = outputManager;
            this.outputMap = outputMap;
            this.timerRegistration = timerRegistration;
            this.keyForTimer = keyForTimer;
            this.windowCoder = windowCoder;
            this.residualCoder = residualCoder;
            this.outputQueue = new LinkedBlockingQueue();
            this.keyedStateInternals = keyedStateInternals;
        }

        public void startBundle() {
            OutputReceiverFactory receiverFactory = new OutputReceiverFactory(){

                public @UnknownKeyFor @NonNull @Initialized FnDataReceiver<OutputT> create(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
                    return receivedElement -> outputQueue.put(KV.of((Object)pCollectionId, (Object)receivedElement));
                }
            };
            TimerReceiverFactory timerReceiverFactory = new TimerReceiverFactory(this.stageBundleFactory, this.timerRegistration, this.windowCoder);
            try {
                this.remoteBundle = this.stageBundleFactory.getBundle(receiverFactory, timerReceiverFactory, this.stateRequestHandler, this.progressHandler, this.finalizationHandler, this.checkpointHandler);
                this.mainInputReceiver = (FnDataReceiver)Iterables.getOnlyElement(this.remoteBundle.getInputReceivers().values());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start remote bundle", e);
            }
        }

        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element) {
            try {
                LOG.debug("Processing value: {}", element);
                this.mainInputReceiver.accept(element);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to process element with SDK harness.", e);
            }
            this.emitResults();
        }

        public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            Object timerKey = this.keyForTimer.get();
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)timerKey, (Object)"Key for timer needs to be set before calling onTimer");
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)this.remoteBundle, (Object)"Call to onTimer outside of a bundle");
            if (BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler.isSdfTimer((String)timerId)) {
                StateNamespace namespace = StateNamespaces.window(this.windowCoder, (BoundedWindow)window);
                WindowedValue stateValue = (WindowedValue)((ValueState)this.keyedStateInternals.state(namespace, StateTags.value((String)timerId, this.residualCoder))).read();
                this.processElement(stateValue);
            } else {
                KV transformAndTimerFamilyId = TimerReceiverFactory.decodeTimerDataTimerId((String)timerFamilyId);
                LOG.debug("timer callback: {} {} {} {} {}", new Object[]{transformAndTimerFamilyId.getKey(), transformAndTimerFamilyId.getValue(), window, timestamp, timeDomain});
                FnDataReceiver timerReceiver = (FnDataReceiver)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((FnDataReceiver)this.remoteBundle.getTimerReceivers().get(transformAndTimerFamilyId)), (String)"No receiver found for timer %s %s", (Object)transformAndTimerFamilyId.getKey(), (Object)transformAndTimerFamilyId.getValue());
                Timer timerValue = Timer.of((Object)timerKey, (String)timerId, Collections.singletonList(window), (Instant)timestamp, (Instant)outputTimestamp, (PaneInfo)PaneInfo.NO_FIRING);
                try {
                    timerReceiver.accept((Object)timerValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to process timer %s", timerReceiver), e);
                }
            }
        }

        public void finishBundle() {
            try {
                this.remoteBundle.close();
                this.emitResults();
            }
            catch (Exception e) {
                if (e.getCause() instanceof StatusRuntimeException) {
                    throw new RuntimeException("SDK Harness connection lost.", e);
                }
                throw new RuntimeException("Failed to finish remote bundle", e);
            }
            finally {
                this.remoteBundle = null;
            }
        }

        public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        }

        @UnknownKeyFor @NonNull @Initialized boolean isBundleInProgress() {
            return this.remoteBundle != null;
        }

        private void emitResults() {
            KV<String, OutputT> result;
            while ((result = this.outputQueue.poll()) != null) {
                String outputPCollectionId = (String)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((String)result.getKey()));
                TupleTag<?> tag = this.outputMap.get(outputPCollectionId);
                WindowedValue windowedValue = (WindowedValue)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((WindowedValue)result.getValue()), (String)"Received a null value from the SDK harness for %s", (Object)outputPCollectionId);
                if (tag == null) {
                    throw new IllegalStateException(String.format("Received output for unknown PCollection %s", outputPCollectionId));
                }
                this.outputManager.output(tag, windowedValue);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
            return this.doFn;
        }
    }

    class SdfFlinkStateInternals
    implements StateInternals {
        private final @UnknownKeyFor @NonNull @Initialized ByteBuffer key;

        SdfFlinkStateInternals(ByteBuffer key) {
            this.key = key;
        }

        public @UnknownKeyFor @NonNull @Initialized Object getKey() {
            return this.key;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T extends State> T state(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<T> address, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
            try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                ExecutableStageDoFnOperator.this.getKeyedStateBackend().setCurrentKey((Object)this.key);
                State state = ExecutableStageDoFnOperator.this.keyedStateInternals.state(namespace, address);
                return (T)state;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't set state", e);
            }
        }
    }

    class SdfFlinkStateInternalsFactory
    implements StateInternalsFactory<InputT> {
        SdfFlinkStateInternalsFactory() {
        }

        public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternalsForKey(InputT key) {
            try {
                ByteBuffer encodedKey = (ByteBuffer)ExecutableStageDoFnOperator.this.keySelector.getKey((Object)WindowedValue.valueInGlobalWindow(key));
                return new SdfFlinkStateInternals(encodedKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get a state internals", e);
            }
        }
    }

    class SdfFlinkTimerInternals
    implements TimerInternals {
        private final @UnknownKeyFor @NonNull @Initialized ByteBuffer key;

        SdfFlinkTimerInternals(ByteBuffer key) {
            this.key = key;
        }

        public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            this.setTimer(TimerInternals.TimerData.of((String)timerId, (String)timerFamilyId, (StateNamespace)namespace, (Instant)target, (Instant)outputTimestamp, (TimeDomain)timeDomain));
        }

        public void setTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
            try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                ExecutableStageDoFnOperator.this.getKeyedStateBackend().setCurrentKey((Object)this.key);
                ExecutableStageDoFnOperator.this.timerInternals.setTimer(timerData);
                ExecutableStageDoFnOperator.this.minEventTimeTimerTimestampInCurrentBundle = Math.min(ExecutableStageDoFnOperator.this.minEventTimeTimerTimestampInCurrentBundle, DoFnOperator.adjustTimestampForFlink(timerData.getOutputTimestamp().getMillis()));
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't set timer", e);
            }
        }

        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            throw new UnsupportedOperationException("It is not expected to use SdfFlinkTimerInternals to delete a timer");
        }

        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
            throw new UnsupportedOperationException("It is not expected to use SdfFlinkTimerInternals to delete a timer");
        }

        public void deleteTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerKey) {
            throw new UnsupportedOperationException("It is not expected to use SdfFlinkTimerInternals to delete a timer");
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentProcessingTime();
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentSynchronizedProcessingTime();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentInputWatermarkTime();
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentOutputWatermarkTime();
        }
    }

    class SdfFlinkTimerInternalsFactory
    implements TimerInternalsFactory<InputT> {
        SdfFlinkTimerInternalsFactory() {
        }

        public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternalsForKey(InputT key) {
            try {
                ByteBuffer encodedKey = (ByteBuffer)ExecutableStageDoFnOperator.this.keySelector.getKey((Object)WindowedValue.valueInGlobalWindow(key));
                return new SdfFlinkTimerInternals(encodedKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get a timer internals", e);
            }
        }
    }

    static class BagUserStateFactory<@UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    implements StateRequestHandlers.BagUserStateHandlerFactory<ByteString, V, W> {
        private final @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals;
        private final @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<@UnknownKeyFor @NonNull @Initialized ByteBuffer> keyedStateBackend;
        private final @UnknownKeyFor @NonNull @Initialized Lock stateBackendLock;
        private final @Nullable @UnknownKeyFor @Initialized Coder runnerKeyCoder;
        private final @Nullable @UnknownKeyFor @Initialized AbstractKeyedStateBackend<@UnknownKeyFor @NonNull @Initialized ByteBuffer> keyStateBackendWithKeyGroupInfo;

        BagUserStateFactory(@UnknownKeyFor @NonNull @Initialized StateInternals stateInternals, @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<@UnknownKeyFor @NonNull @Initialized ByteBuffer> keyedStateBackend, @UnknownKeyFor @NonNull @Initialized Lock stateBackendLock, @Nullable @UnknownKeyFor @Initialized Coder runnerKeyCoder) {
            this.stateInternals = stateInternals;
            this.keyedStateBackend = keyedStateBackend;
            this.stateBackendLock = stateBackendLock;
            this.keyStateBackendWithKeyGroupInfo = keyedStateBackend instanceof AbstractKeyedStateBackend ? (AbstractKeyedStateBackend)keyedStateBackend : null;
            this.runnerKeyCoder = runnerKeyCoder;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized StateRequestHandlers.BagUserStateHandler<@UnknownKeyFor @NonNull @Initialized ByteString, V, W> forUserState(final @UnknownKeyFor @NonNull @Initialized String pTransformId, final @UnknownKeyFor @NonNull @Initialized String userStateId, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ByteString> keyCoder, final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
            return new StateRequestHandlers.BagUserStateHandler<ByteString, V, W>(){

                public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(@UnknownKeyFor @NonNull @Initialized ByteString key, W window) {
                    try (Locker locker = Locker.locked(stateBackendLock);){
                        this.prepareStateBackend(key);
                        StateNamespace namespace = StateNamespaces.window((Coder)windowCoder, window);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("State get for {} {} {} {}", new Object[]{pTransformId, userStateId, Arrays.toString(((ByteBuffer)keyedStateBackend.getCurrentKey()).array()), window});
                        }
                        BagState bagState = (BagState)stateInternals.state(namespace, StateTags.bag((String)userStateId, (Coder)valueCoder));
                        Iterable iterable = bagState.read();
                        return iterable;
                    }
                }

                public void append(@UnknownKeyFor @NonNull @Initialized ByteString key, W window, @UnknownKeyFor @NonNull @Initialized Iterator<V> values) {
                    try (Locker locker = Locker.locked(stateBackendLock);){
                        this.prepareStateBackend(key);
                        StateNamespace namespace = StateNamespaces.window((Coder)windowCoder, window);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("State append for {} {} {} {}", new Object[]{pTransformId, userStateId, Arrays.toString(((ByteBuffer)keyedStateBackend.getCurrentKey()).array()), window});
                        }
                        BagState bagState = (BagState)stateInternals.state(namespace, StateTags.bag((String)userStateId, (Coder)valueCoder));
                        while (values.hasNext()) {
                            bagState.add(values.next());
                        }
                    }
                }

                public void clear(@UnknownKeyFor @NonNull @Initialized ByteString key, W window) {
                    try (Locker locker = Locker.locked(stateBackendLock);){
                        this.prepareStateBackend(key);
                        StateNamespace namespace = StateNamespaces.window((Coder)windowCoder, window);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("State clear for {} {} {} {}", new Object[]{pTransformId, userStateId, Arrays.toString(((ByteBuffer)keyedStateBackend.getCurrentKey()).array()), window});
                        }
                        BagState bagState = (BagState)stateInternals.state(namespace, StateTags.bag((String)userStateId, (Coder)valueCoder));
                        bagState.clear();
                    }
                }

                private void prepareStateBackend(@UnknownKeyFor @NonNull @Initialized ByteString key) {
                    ByteBuffer encodedKey = FlinkKeyUtils.fromEncodedKey(key);
                    keyedStateBackend.setCurrentKey((Object)encodedKey);
                    if (keyStateBackendWithKeyGroupInfo != null) {
                        int currentKeyGroupIndex = keyStateBackendWithKeyGroupInfo.getCurrentKeyGroupIndex();
                        KeyGroupRange keyGroupRange = keyStateBackendWithKeyGroupInfo.getKeyGroupRange();
                        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)keyGroupRange.contains(currentKeyGroupIndex), (String)"The current key '%s' with key group index '%s' does not belong to the key group range '%s'. Runner keyCoder: %s. Ptransformid: %s Userstateid: %s", (Object[])new Object[]{Arrays.toString(key.toByteArray()), currentKeyGroupIndex, keyGroupRange, runnerKeyCoder, pTransformId, userStateId});
                    }
                }
            };
        }
    }
}

