/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import net.jpountz.xxhash.XXHashFactory;
import org.caffinitas.ohc.HashAlgorithm;

abstract class Hasher {
    Hasher() {
    }

    static Hasher create(HashAlgorithm hashAlgorithm) {
        String cls = Hasher.forAlg(hashAlgorithm);
        try {
            return (Hasher)Class.forName(cls).newInstance();
        }
        catch (ClassNotFoundException e) {
            if (hashAlgorithm == HashAlgorithm.XX) {
                cls = Hasher.forAlg(HashAlgorithm.CRC32);
                try {
                    return (Hasher)Class.forName(cls).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String forAlg(HashAlgorithm hashAlgorithm) {
        return Hasher.class.getName() + '$' + hashAlgorithm.name().substring(0, 1) + hashAlgorithm.name().substring(1).toLowerCase() + "Hash";
    }

    abstract long hash(ByteBuffer var1);

    static final class XxHash
    extends Hasher {
        private static final XXHashFactory xx = XXHashFactory.fastestInstance();

        XxHash() {
        }

        @Override
        long hash(ByteBuffer buffer) {
            return xx.hash64().hash(buffer, 0L);
        }
    }

    static final class Murmur3Hash
    extends Hasher {
        static final long C1 = -8663945395140668459L;
        static final long C2 = 5545529020109919103L;

        Murmur3Hash() {
        }

        @Override
        long hash(ByteBuffer buffer) {
            long k2;
            long k1;
            long h1 = 0L;
            long h2 = 0L;
            long length = buffer.remaining();
            while (buffer.remaining() >= 16) {
                k1 = Murmur3Hash.getLong(buffer);
                k2 = Murmur3Hash.getLong(buffer);
                h1 ^= Murmur3Hash.mixK1(k1);
                h1 = Long.rotateLeft(h1, 27);
                h1 += h2;
                h1 = h1 * 5L + 1390208809L;
                h2 ^= Murmur3Hash.mixK2(k2);
                h2 = Long.rotateLeft(h2, 31);
                h2 += h1;
                h2 = h2 * 5L + 944331445L;
            }
            int r = buffer.remaining();
            if (r > 0) {
                k1 = 0L;
                k2 = 0L;
                int p = buffer.position();
                switch (r) {
                    case 15: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 14)) << 48;
                    }
                    case 14: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 13)) << 40;
                    }
                    case 13: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 12)) << 32;
                    }
                    case 12: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 11)) << 24;
                    }
                    case 11: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 10)) << 16;
                    }
                    case 10: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 9)) << 8;
                    }
                    case 9: {
                        k2 ^= Murmur3Hash.toLong(buffer.get(p + 8));
                    }
                    case 8: {
                        k1 ^= Murmur3Hash.getLong(buffer);
                        break;
                    }
                    case 7: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p + 6)) << 48;
                    }
                    case 6: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p + 5)) << 40;
                    }
                    case 5: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p + 4)) << 32;
                    }
                    case 4: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p + 3)) << 24;
                    }
                    case 3: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p + 2)) << 16;
                    }
                    case 2: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p + 1)) << 8;
                    }
                    case 1: {
                        k1 ^= Murmur3Hash.toLong(buffer.get(p));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Should never get here.");
                    }
                }
                buffer.position(p + r);
                h1 ^= Murmur3Hash.mixK1(k1);
                h2 ^= Murmur3Hash.mixK2(k2);
            }
            h1 ^= length;
            h1 += (h2 ^= length);
            h2 += h1;
            h1 = Murmur3Hash.fmix64(h1);
            h2 = Murmur3Hash.fmix64(h2);
            return h1 += h2;
        }

        private static long getLong(ByteBuffer buffer) {
            int o = buffer.position();
            long l = Murmur3Hash.toLong(buffer.get(o + 7)) << 56;
            l |= Murmur3Hash.toLong(buffer.get(o + 6)) << 48;
            l |= Murmur3Hash.toLong(buffer.get(o + 5)) << 40;
            l |= Murmur3Hash.toLong(buffer.get(o + 4)) << 32;
            l |= Murmur3Hash.toLong(buffer.get(o + 3)) << 24;
            l |= Murmur3Hash.toLong(buffer.get(o + 2)) << 16;
            l |= Murmur3Hash.toLong(buffer.get(o + 1)) << 8;
            buffer.position(o + 8);
            return l |= Murmur3Hash.toLong(buffer.get(o));
        }

        static long fmix64(long k) {
            k ^= k >>> 33;
            k *= -49064778989728563L;
            k ^= k >>> 33;
            k *= -4265267296055464877L;
            k ^= k >>> 33;
            return k;
        }

        static long mixK1(long k1) {
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            return k1 *= 5545529020109919103L;
        }

        static long mixK2(long k2) {
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            return k2 *= -8663945395140668459L;
        }

        static long toLong(byte value) {
            return value & 0xFF;
        }
    }

    static final class Crc32Hash
    extends Hasher {
        Crc32Hash() {
        }

        @Override
        long hash(ByteBuffer buffer) {
            CRC32 crc = new CRC32();
            crc.update(buffer);
            return crc.getValue();
        }
    }
}

