/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextWriterBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

class HTMLWriter
extends StyledTextWriterBase {
    public HTMLWriter(StyledText styledText, int start, int length) {
        super(styledText, start, length);
        this.writeHeader();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.write("</div>");
            this.write("</div>");
            super.close();
        }
    }

    @Override
    void writeHeader() {
        StringBuilder outerDivStyle = new StringBuilder();
        StringBuilder innerDivStyle = new StringBuilder();
        HTMLWriter.appendStyle(outerDivStyle, "background-color:", this.styledText.getMarginColor(), ";");
        HTMLWriter.appendStyle(innerDivStyle, "color:", this.styledText.getForeground(), ";");
        HTMLWriter.appendStyle(innerDivStyle, "background-color:", this.styledText.getBackground(), ";");
        HTMLWriter.appendStyle(outerDivStyle, "padding:" + this.styledText.getTopMargin() + "px " + this.styledText.getRightMargin() + "px " + this.styledText.getBottomMargin() + "px " + this.styledText.getLeftMargin() + "px;");
        String language = HTMLWriter.appendFont(innerDivStyle, this.styledText.getFont(), 0);
        int indent = this.styledText.getIndent();
        if (indent != 0) {
            HTMLWriter.appendStyle(innerDivStyle, "text-indent:", indent, "px;");
        }
        if (this.styledText.getWordWrap()) {
            HTMLWriter.appendStyle(innerDivStyle, "white-space:pre-wrap;");
        } else {
            HTMLWriter.appendStyle(innerDivStyle, "white-space:pre;");
        }
        HTMLWriter.appendAlignAndJustify(innerDivStyle, this.styledText.getAlignment(), this.styledText.getJustify());
        if (this.styledText.getOrientation() == 0x4000000 || this.styledText.getTextDirection() == 0x4000000) {
            HTMLWriter.appendStyle(innerDivStyle, "direction:rtl;");
        }
        this.write("<div style='" + outerDivStyle + "'>");
        if (language == null || language.isEmpty()) {
            this.write("<div style='" + innerDivStyle + "'>");
        } else {
            this.write("<div lang='" + language + "' style='" + innerDivStyle + "'>");
        }
    }

    @Override
    public void writeLineDelimiter(String lineDelimiter) {
        if (this.isClosed()) {
            SWT.error(39);
        }
    }

    @Override
    String writeLineStart(Color lineBackground, int indent, int verticalIndent, int alignment, boolean justify) {
        StringBuilder paragraphStyle = new StringBuilder();
        HTMLWriter.appendAlignAndJustify(paragraphStyle, alignment, justify);
        HTMLWriter.appendStyle(paragraphStyle, "background-color:", lineBackground, ";");
        if (indent != 0) {
            HTMLWriter.appendStyle(paragraphStyle, "text-indent:", indent, "px;");
        }
        if (verticalIndent == 0) {
            HTMLWriter.appendStyle(paragraphStyle, "margin:0;");
        } else {
            HTMLWriter.appendStyle(paragraphStyle, "margin:", verticalIndent, " 0 0 0;");
        }
        if (paragraphStyle.length() == 0) {
            this.write("<p>");
        } else {
            this.write("<p style='" + paragraphStyle + "'>");
        }
        return "</p>";
    }

    @Override
    void writeEmptyLine() {
        this.write("<br>");
    }

    @Override
    String writeSpanStart(StyleRange style) {
        StringBuilder spanStyle2;
        StringBuilder spanStyle = new StringBuilder();
        HTMLWriter.appendStyle(spanStyle, "color:", style.foreground, ";");
        HTMLWriter.appendStyle(spanStyle, "background-color:", style.background, ";");
        HTMLWriter.appendFont(spanStyle, style.font, style.fontStyle);
        if (style.rise != 0) {
            HTMLWriter.appendStyle(spanStyle, "position:relative;bottom:", style.rise, "pt;");
        }
        String borderColor = style.borderColor != null ? " " + HTMLWriter.colorToHex(style.borderColor) : "";
        switch (style.borderStyle) {
            case 1: 
            case 2048: {
                HTMLWriter.appendStyle(spanStyle, "border:solid 1pt", borderColor, ";");
                break;
            }
            case 2: {
                HTMLWriter.appendStyle(spanStyle, "border:dashed 1pt", borderColor, ";");
                break;
            }
            case 4: {
                HTMLWriter.appendStyle(spanStyle, "border:dotted 1pt", borderColor, ";");
                break;
            }
        }
        if (style.underline) {
            HTMLWriter.appendStyle(spanStyle, "text-decoration:underline;");
            HTMLWriter.appendStyle(spanStyle, "text-decoration-color:", style.underlineColor, ";");
            switch (style.underlineStyle) {
                case 0: {
                    HTMLWriter.appendStyle(spanStyle, "text-decoration-style:solid;");
                    break;
                }
                case 1: {
                    HTMLWriter.appendStyle(spanStyle, "text-decoration-style:double;");
                    break;
                }
                case 2: {
                    HTMLWriter.appendStyle(spanStyle, "text-decoration-style:wavy;");
                    break;
                }
                case 3: {
                    HTMLWriter.appendStyle(spanStyle, "text-decoration-style:wavy;");
                    break;
                }
                case 4: {
                    HTMLWriter.appendStyle(spanStyle, "text-decoration-style:solid;");
                    if (style.underlineColor == null) {
                        HTMLWriter.appendStyle(spanStyle, "text-decoration-color:#0066cc;");
                    }
                    if (style.foreground != null) break;
                    HTMLWriter.appendStyle(spanStyle, "color:#0066cc;");
                    break;
                }
            }
        }
        if (style.strikeout) {
            spanStyle2 = new StringBuilder();
            HTMLWriter.appendStyle(spanStyle2, "text-decoration:line-through;");
            HTMLWriter.appendStyle(spanStyle2, "text-decoration-color:", style.strikeoutColor, ";");
        } else {
            spanStyle2 = null;
        }
        if (spanStyle.length() != 0) {
            this.write("<span style='" + spanStyle + "'>");
        }
        if (spanStyle2 != null) {
            this.write("<span style='" + spanStyle2 + "'>");
        }
        StringBuilder toCloseSpan = new StringBuilder();
        if (spanStyle2 != null) {
            toCloseSpan.append("</span>");
        }
        if (spanStyle.length() != 0) {
            toCloseSpan.append("</span>");
        }
        return toCloseSpan.toString();
    }

    @Override
    String escapeText(String string) {
        StringBuilder result = new StringBuilder(string.length());
        string.chars().forEach(ch -> {
            switch (ch) {
                case 38: {
                    result.append("&amp;");
                    break;
                }
                case 34: {
                    result.append("&quot;");
                    break;
                }
                case 60: {
                    result.append("&lt;");
                    break;
                }
                case 62: {
                    result.append("&gt;");
                    break;
                }
                default: {
                    result.append((char)ch);
                }
            }
        });
        return result.toString();
    }

    private static String colorToHex(Color color) {
        if (color == null) {
            return null;
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static void appendStyle(StringBuilder buffer, String value) {
        buffer.append(value);
    }

    private static void appendStyle(StringBuilder buffer, String prefix, String value, String postfix) {
        buffer.append(prefix);
        buffer.append(value);
        buffer.append(postfix);
    }

    private static void appendStyle(StringBuilder buffer, String prefix, int value, String postfix) {
        buffer.append(prefix);
        buffer.append(value);
        buffer.append(postfix);
    }

    private static void appendStyle(StringBuilder buffer, String prefix, Color value, String postfix) {
        if (value != null) {
            buffer.append(prefix);
            buffer.append(HTMLWriter.colorToHex(value));
            buffer.append(postfix);
        }
    }

    private static String appendFont(StringBuilder buffer, Font font, int fontStyle) {
        FontData[] fd;
        String language = null;
        if (font != null && (fd = font.getFontData()) != null && fd.length > 0) {
            FontData fdata = fd[0];
            String name = fdata.getName();
            if (name != null && !name.isEmpty()) {
                HTMLWriter.appendStyle(buffer, "font-family:\"", fdata.getName(), "\";");
            }
            HTMLWriter.appendStyle(buffer, "font-size:", fdata.getHeight(), "pt;");
            language = fdata.getLocale();
            fontStyle = fdata.getStyle();
        }
        if (fontStyle != 0) {
            if ((fontStyle & 2) == 2) {
                HTMLWriter.appendStyle(buffer, "font-style:italic;");
            }
            if ((fontStyle & 1) == 1) {
                HTMLWriter.appendStyle(buffer, "font-weight:bold;");
            }
        }
        return language;
    }

    private static void appendAlignAndJustify(StringBuilder buffer, int alignment, boolean justify) {
        String textAlignKey;
        if (justify) {
            HTMLWriter.appendStyle(buffer, "text-align:justify;");
            textAlignKey = "text-align-last:";
        } else {
            textAlignKey = "text-align:";
        }
        switch (alignment) {
            case 16384: {
                break;
            }
            case 0x1000000: {
                HTMLWriter.appendStyle(buffer, textAlignKey, "center", ";");
                break;
            }
            case 131072: {
                HTMLWriter.appendStyle(buffer, textAlignKey, "right", ";");
                break;
            }
        }
    }
}

