/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sql;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.sql.ActionSql;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionSqlDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionSql.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionSQL.Filetype.Sql", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSQL.Filetype.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSQL.Filetype.All", (String[])new String[0])};
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Button wUseSubs;
    private Button wSqlFromFile;
    private Label wlSql;
    private StyledTextComp wSql;
    private Label wlPosition;
    private ActionSql action;
    private Button wSendOneStatement;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;

    public ActionSqlDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionSql)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionSQL.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSQL.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionSQL.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        DatabaseMeta databaseMeta = this.workflowMeta.findDatabase(this.action.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, databaseMeta, null);
        Label wlSqlFromFile = new Label((Composite)this.shell, 131072);
        wlSqlFromFile.setText(BaseMessages.getString(PKG, (String)"ActionSQL.SQLFromFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSqlFromFile);
        FormData fdlSqlFromFile = new FormData();
        fdlSqlFromFile.left = new FormAttachment(0, 0);
        fdlSqlFromFile.top = new FormAttachment(this.wConnection, 2 * margin);
        fdlSqlFromFile.right = new FormAttachment(middle, -margin);
        wlSqlFromFile.setLayoutData((Object)fdlSqlFromFile);
        this.wSqlFromFile = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSqlFromFile);
        this.wSqlFromFile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSQL.SQLFromFile.Tooltip", (String[])new String[0]));
        FormData fdSqlFromFile = new FormData();
        fdSqlFromFile.left = new FormAttachment(middle, 0);
        fdSqlFromFile.top = new FormAttachment((Control)wlSqlFromFile, 0, 0x1000000);
        fdSqlFromFile.right = new FormAttachment(100, 0);
        this.wSqlFromFile.setLayoutData((Object)fdSqlFromFile);
        this.wSqlFromFile.addListener(13, e -> {
            this.activeSqlFromFile();
            this.action.setChanged();
        });
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionSQL.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wlSqlFromFile, 2 * margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSQL.Filename.Tooltip", (String[])new String[0]));
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        this.wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.sql", "*.txt", "*"}, (String[])FILETYPES, (boolean)true));
        Label wlUseOneStatement = new Label((Composite)this.shell, 131072);
        wlUseOneStatement.setText(BaseMessages.getString(PKG, (String)"ActionSQL.SendOneStatement.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseOneStatement);
        FormData fdlUseOneStatement = new FormData();
        fdlUseOneStatement.left = new FormAttachment(0, 0);
        fdlUseOneStatement.top = new FormAttachment((Control)this.wbFilename, margin);
        fdlUseOneStatement.right = new FormAttachment(middle, -margin);
        wlUseOneStatement.setLayoutData((Object)fdlUseOneStatement);
        this.wSendOneStatement = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSendOneStatement);
        this.wSendOneStatement.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSQL.SendOneStatement.Tooltip", (String[])new String[0]));
        FormData fdUseOneStatement = new FormData();
        fdUseOneStatement.left = new FormAttachment(middle, 0);
        fdUseOneStatement.top = new FormAttachment((Control)wlUseOneStatement, 0, 0x1000000);
        fdUseOneStatement.right = new FormAttachment(100, 0);
        this.wSendOneStatement.setLayoutData((Object)fdUseOneStatement);
        this.wSendOneStatement.addListener(13, e -> this.action.setChanged());
        Label wlUseSubs = new Label((Composite)this.shell, 131072);
        wlUseSubs.setText(BaseMessages.getString(PKG, (String)"ActionSQL.UseVariableSubst.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseSubs);
        FormData fdlUseSubs = new FormData();
        fdlUseSubs.left = new FormAttachment(0, 0);
        fdlUseSubs.top = new FormAttachment((Control)wlUseOneStatement, 2 * margin);
        fdlUseSubs.right = new FormAttachment(middle, -margin);
        wlUseSubs.setLayoutData((Object)fdlUseSubs);
        this.wUseSubs = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wUseSubs);
        this.wUseSubs.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSQL.UseVariableSubst.Tooltip", (String[])new String[0]));
        FormData fdUseSubs = new FormData();
        fdUseSubs.left = new FormAttachment(middle, 0);
        fdUseSubs.top = new FormAttachment((Control)wlUseSubs, 0, 0x1000000);
        fdUseSubs.right = new FormAttachment(100, 0);
        this.wUseSubs.setLayoutData((Object)fdUseSubs);
        this.wUseSubs.addListener(13, e -> {
            this.action.setUseVariableSubstitution(!this.action.isUseVariableSubstitution());
            this.action.setChanged();
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ActionSQL.LineNr.Label", (String[])new String[]{"0"}));
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.right = new FormAttachment(100, 0);
        fdlPosition.bottom = new FormAttachment((Control)wOk, -margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        this.wlSql = new Label((Composite)this.shell, 0);
        this.wlSql.setText(BaseMessages.getString(PKG, (String)"ActionSQL.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment((Control)this.wUseSubs, margin);
        this.wlSql.setLayoutData((Object)fdlSql);
        this.wSql = new StyledTextComp((IVariables)this.action, (Composite)this.shell, 19202);
        PropsUi.setLook((Widget)this.wSql, (int)1);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)this.wlSql, margin);
        fdSql.right = new FormAttachment(100, -20);
        fdSql.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSql.setLayoutData((Object)fdSql);
        this.wSql.addListener(24, e -> this.setPosition());
        this.wSql.addListener(1, e -> this.setPosition());
        this.wSql.addListener(2, e -> this.setPosition());
        this.wSql.addListener(15, e -> this.setPosition());
        this.wSql.addListener(16, e -> this.setPosition());
        this.wSql.addListener(8, e -> this.setPosition());
        this.wSql.addListener(3, e -> this.setPosition());
        this.wSql.addListener(4, e -> this.setPosition());
        this.getData();
        this.activeSqlFromFile();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ActionSQL.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wSql.setText(Const.nullToEmpty((String)this.action.getSql()));
        this.wConnection.setText(Const.nullToEmpty((String)this.action.getConnection()));
        this.wUseSubs.setSelection(this.action.isUseVariableSubstitution());
        this.wSqlFromFile.setSelection(this.action.isSqlFromFile());
        this.wSendOneStatement.setSelection(this.action.isSendOneStatement());
        this.wFilename.setText(Const.nullToEmpty((String)this.action.getSqlFilename()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void activeSqlFromFile() {
        this.wlFilename.setEnabled(this.wSqlFromFile.getSelection());
        this.wFilename.setEnabled(this.wSqlFromFile.getSelection());
        this.wbFilename.setEnabled(this.wSqlFromFile.getSelection());
        this.wSql.setEnabled(!this.wSqlFromFile.getSelection());
        this.wlSql.setEnabled(!this.wSqlFromFile.getSelection());
        this.wlPosition.setEnabled(!this.wSqlFromFile.getSelection());
    }

    private void cancel() {
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setConnection(this.wConnection.getText());
        this.action.setSql(this.wSql.getText());
        this.action.setUseVariableSubstitution(this.wUseSubs.getSelection());
        this.action.setSqlFromFile(this.wSqlFromFile.getSelection());
        this.action.setSqlFilename(this.wFilename.getText());
        this.action.setSendOneStatement(this.wSendOneStatement.getSelection());
        this.action.setChanged();
        this.dispose();
    }
}

