/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.ods;

import java.sql.Date;
import java.util.TimeZone;
import org.apache.hop.core.spreadsheet.IKCell;
import org.apache.hop.core.spreadsheet.KCellType;
import org.apache.hop.core.util.Utils;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;

public class OdfCell
implements IKCell {
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_CURRENCY = "currency";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_PERCENTAGE = "percentage";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_TIME = "time";
    private OdfTableCell cell;

    public OdfCell(OdfTableCell cell) {
        this.cell = cell;
    }

    public KCellType getType() {
        String type = this.cell.getValueType();
        if (Utils.isEmpty((CharSequence)type)) {
            return KCellType.EMPTY;
        }
        if (TYPE_BOOLEAN.equals(type)) {
            if (Utils.isEmpty((CharSequence)this.cell.getFormula())) {
                return KCellType.BOOLEAN;
            }
            return KCellType.BOOLEAN_FORMULA;
        }
        if (TYPE_CURRENCY.equals(type) || TYPE_FLOAT.equals(type) || TYPE_PERCENTAGE.equals(type)) {
            if (Utils.isEmpty((CharSequence)this.cell.getFormula())) {
                return KCellType.NUMBER;
            }
            return KCellType.NUMBER_FORMULA;
        }
        if (TYPE_DATE.equals(type) || TYPE_TIME.equals(type)) {
            if (Utils.isEmpty((CharSequence)this.cell.getFormula())) {
                return KCellType.DATE;
            }
            return KCellType.DATE_FORMULA;
        }
        if (TYPE_STRING.equals(type)) {
            if (Utils.isEmpty((CharSequence)this.cell.getFormula())) {
                return KCellType.LABEL;
            }
            return KCellType.STRING_FORMULA;
        }
        return null;
    }

    public Object getValue() {
        try {
            switch (this.getType()) {
                case BOOLEAN_FORMULA: 
                case BOOLEAN: {
                    return this.cell.getBooleanValue();
                }
                case DATE_FORMULA: 
                case DATE: {
                    long time = this.cell.getDateValue().getTime().getTime();
                    long tzOffset = TimeZone.getDefault().getOffset(time);
                    return new Date(time + tzOffset);
                }
                case NUMBER_FORMULA: 
                case NUMBER: {
                    return (double)this.cell.getDoubleValue();
                }
                case STRING_FORMULA: 
                case LABEL: {
                    return this.cell.getStringValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public String getContents() {
        try {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get string content of cell (" + this.cell.getColumnIndex() + ", " + this.cell.getRowIndex() + ")", e);
        }
    }

    public int getRow() {
        return this.cell.getRowIndex();
    }
}

