/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;

public class CollectCoordinationRequest
implements CoordinationRequest {
    private static final long serialVersionUID = 1L;
    private static final TypeSerializer<String> versionSerializer = StringSerializer.INSTANCE;
    private static final TypeSerializer<Long> offsetSerializer = LongSerializer.INSTANCE;
    private final String version;
    private final long offset;

    public CollectCoordinationRequest(String version, long offset) {
        this.version = version;
        this.offset = offset;
    }

    public CollectCoordinationRequest(DataInputView inView) throws IOException {
        this.version = (String)versionSerializer.deserialize(inView);
        this.offset = (Long)offsetSerializer.deserialize(inView);
    }

    public String getVersion() {
        return this.version;
    }

    public long getOffset() {
        return this.offset;
    }

    public void serialize(DataOutputView outView) throws IOException {
        versionSerializer.serialize((Object)this.version, outView);
        offsetSerializer.serialize((Object)this.offset, outView);
    }
}

