/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLTimestamp;
import java.io.CharConversionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLTime
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int timeFormat_;
    private int hour_ = 0;
    private int minute_ = 0;
    private int second_ = 0;

    SQLTime(SQLConversionSettings settings, int timeFormat) {
        super(settings);
        this.timeFormat_ = timeFormat;
    }

    @Override
    public Object clone() {
        return new SQLTime(this.settings_, this.timeFormat_);
    }

    public static Time stringToTime(String s, SQLConversionSettings settings, Calendar calendar) throws SQLException {
        try {
            if (s.trim().length() == 0) {
                return new Time(0L);
            }
            if (calendar == null) {
                calendar = AS400Calendar.getGregorianInstance();
                calendar.setLenient(false);
            } else {
                calendar = AS400Calendar.getConversionCalendar(calendar);
            }
            switch (settings.getTimeFormat()) {
                case 1: {
                    int hour = Integer.parseInt(s.substring(0, 2));
                    char amPm = s.charAt(6);
                    if (hour == 12) {
                        if (amPm == 'A') {
                            hour = 0;
                        }
                    } else if (amPm == 'P') {
                        hour += 12;
                    }
                    calendar.set(11, hour);
                    calendar.set(12, Integer.parseInt(s.substring(3, 5)));
                    calendar.set(13, 0);
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: {
                    calendar.set(11, Integer.parseInt(s.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(s.substring(3, 5)));
                    calendar.set(13, Integer.parseInt(s.substring(6, 8)));
                }
            }
        }
        catch (NumberFormatException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing time " + s, e);
            }
            if (s.length() >= 19 && s.charAt(4) == '-' && s.charAt(7) == '-') {
                try {
                    Timestamp ts = SQLTimestamp.stringToTimestamp(s, calendar);
                    calendar.set(11, ts.getHours());
                    calendar.set(12, ts.getMinutes());
                    calendar.set(13, ts.getSeconds());
                }
                catch (Exception e2) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(null, "Error parsing time as timestamp" + s, e2);
                    }
                    JDError.throwSQLException(null, "07006", e, s);
                }
            } else {
                JDError.throwSQLException(null, "07006", e, s);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing time " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
        try {
            long millis = calendar.getTimeInMillis();
            return new Time(millis);
        }
        catch (Exception e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing time " + s, e);
            }
            JDError.throwSQLException("07006", s);
            return null;
        }
    }

    public static String timeToString(Time t, SQLConversionSettings dataFormat, Calendar calendar) {
        return SQLTime.timeToString(t, dataFormat, calendar, -1);
    }

    private static String timeToString(Time t, SQLConversionSettings dataFormat, Calendar calendar, int hourIn) {
        StringBuffer buffer = new StringBuffer();
        String separator = dataFormat.getTimeSeparator();
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.setTime(t);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = 0;
        switch (dataFormat.getTimeFormat()) {
            case 1: {
                char amPm;
                if (hour > 12) {
                    hour -= 12;
                    amPm = 'P';
                } else if (hour == 12) {
                    amPm = 'P';
                } else if (hour > 0 && hour < 12) {
                    amPm = 'A';
                } else if (minute == 0 && second == 0) {
                    if (hourIn == 24) {
                        hour = 12;
                    }
                    amPm = 'A';
                } else {
                    hour = 12;
                    amPm = 'A';
                }
                buffer.append(JDUtilities.padZeros(hour, 2));
                buffer.append(':');
                buffer.append(JDUtilities.padZeros(minute, 2));
                buffer.append(' ');
                buffer.append(amPm);
                buffer.append('M');
                break;
            }
            case 2: 
            case 3: {
                second = calendar.get(13);
                buffer.append(JDUtilities.padZeros(hour, 2));
                buffer.append('.');
                buffer.append(JDUtilities.padZeros(minute, 2));
                buffer.append('.');
                buffer.append(JDUtilities.padZeros(second, 2));
                break;
            }
            case 4: {
                second = calendar.get(13);
                buffer.append(JDUtilities.padZeros(hour, 2));
                buffer.append(':');
                buffer.append(JDUtilities.padZeros(minute, 2));
                buffer.append(':');
                buffer.append(JDUtilities.padZeros(second, 2));
                break;
            }
            case 0: {
                second = calendar.get(13);
                buffer.append(JDUtilities.padZeros(hour, 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(minute, 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(second, 2));
            }
        }
        if (hourIn == 24 && hour == 0 && minute == 0 && second == 0) {
            buffer.setCharAt(0, '2');
            buffer.setCharAt(1, '4');
        }
        return buffer.toString();
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int connectionTimeFormat = this.settings_.getTimeFormat();
        switch (this.timeFormat_ != -1 && this.timeFormat_ != connectionTimeFormat ? this.timeFormat_ : connectionTimeFormat) {
            case 1: {
                this.hour_ = (rawBytes[offset] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF);
                this.minute_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF);
                this.second_ = 0;
                if ((rawBytes[offset + 6] != -41 || this.hour_ >= 12) && (rawBytes[offset + 6] != -63 || this.hour_ != 12)) break;
                this.hour_ += 12;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.hour_ = (rawBytes[offset] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF);
                this.minute_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF);
                this.second_ = (rawBytes[offset + 6] & 0xF) * 10 + (rawBytes[offset + 7] & 0xF);
                break;
            }
        }
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        StringBuffer buffer = new StringBuffer(8);
        buffer.append(JDUtilities.padZeros(this.hour_, 2));
        buffer.append('.');
        buffer.append(JDUtilities.padZeros(this.minute_, 2));
        buffer.append('.');
        buffer.append(JDUtilities.padZeros(this.second_, 2));
        try {
            ccsidConverter.stringToByteArray(buffer.toString(), rawBytes, offset);
        }
        catch (CharConversionException e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        if (object instanceof String) {
            SQLTime.stringToTime((String)object, this.settings_, calendar);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
        } else if (object instanceof Time) {
            calendar.setTime((Time)object);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    @Override
    public int getSQLType() {
        return 27;
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 8;
    }

    @Override
    public String getJavaClassName() {
        return "java.sql.Time";
    }

    @Override
    public String getLiteralPrefix() {
        return "'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "TIME";
    }

    @Override
    public int getMaximumPrecision() {
        return 8;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 388;
    }

    @Override
    public int getPrecision() {
        return 8;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 92;
    }

    @Override
    public String getTypeName() {
        return "TIME";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return 8;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        return new Time(millis);
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        Time t = new Time(millis);
        return SQLTime.timeToString(t, this.settings_, calendar, this.hour_);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        return new Time(millis);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(0);
        return ts;
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(1970, 0, 1, this.hour_, this.minute_, this.second_);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        Time t = new Time(millis);
        return SQLTime.timeToString(t, this.settings_, calendar, this.hour_);
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() throws SQLException {
        this.savedValue_ = this.getObject();
    }
}

