/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.NPCPMsgHandle;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueImplRemote;
import com.ibm.as400.access.PrintObjectImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class SpooledFileImplRemote
extends PrintObjectImplRemote
implements SpooledFileImpl {
    private static final NPCPAttributeIDList attrsToRetrieve_ = new NPCPAttributeIDList();
    private static boolean fAttrIDsToRtvBuilt_ = false;
    private static final int CMD_SEND_NET = 1;
    private static final int CMD_SEND_TCP = 2;
    transient NPCPMsgHandle cpMsgHandle_ = null;
    transient boolean fMsgRetrieved_ = false;

    SpooledFileImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void answerMessage(String reply) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        SpooledFileImplRemote spooledFileImplRemote = this;
        synchronized (spooledFileImplRemote) {
            if (reply == null) {
                Trace.log(2, "Parameter 'reply' is null.");
                throw new NullPointerException("reply");
            }
            if (!this.fMsgRetrieved_) {
                this.retrieveMessage(null, null);
            }
            NPDataStream sendDS = new NPDataStream(1);
            NPDataStream returnDS = new NPDataStream(1);
            NPSystem npSystem = NPSystem.getSystem(this.getSystem());
            NPCPAttribute cpCPFMessage = new NPCPAttribute();
            NPCPAttribute cpMsgReply = new NPCPAttribute();
            sendDS.setAction(18);
            sendDS.addCodePoint(this.cpMsgHandle_);
            cpMsgReply.setAttrValue(130, reply);
            sendDS.addCodePoint(cpMsgReply);
            returnDS.addCodePoint(cpCPFMessage);
            int rc = npSystem.makeRequest(sendDS, returnDS);
            switch (rc) {
                case 0: {
                    this.fMsgRetrieved_ = false;
                    this.updateAttrs(this.getAttrIDsToRetrieve());
                    break;
                }
                case 14: {
                    Trace.log(2, "No spooled file message waiting.");
                    throw new ErrorCompletingRequestException(12);
                }
                default: {
                    Trace.log(2, "Unexpected Error.");
                    throw new InternalErrorException(6);
                }
            }
        }
    }

    private synchronized void buildAttrIDsToRtv() {
        if (!fAttrIDsToRtvBuilt_) {
            fAttrIDsToRtvBuilt_ = true;
            attrsToRetrieve_.addAttrID(287);
            attrsToRetrieve_.addAttrID(265);
            attrsToRetrieve_.addAttrID(10);
            attrsToRetrieve_.addAttrID(282);
            attrsToRetrieve_.addAttrID(11);
            attrsToRetrieve_.addAttrID(296);
            attrsToRetrieve_.addAttrID(266);
            attrsToRetrieve_.addAttrID(252);
            attrsToRetrieve_.addAttrID(283);
            attrsToRetrieve_.addAttrID(17);
            attrsToRetrieve_.addAttrID(18);
            attrsToRetrieve_.addAttrID(22);
            attrsToRetrieve_.addAttrID(21);
            attrsToRetrieve_.addAttrID(20);
            attrsToRetrieve_.addAttrID(19);
            attrsToRetrieve_.addAttrID(55);
            attrsToRetrieve_.addAttrID(300);
            attrsToRetrieve_.addAttrID(316);
            attrsToRetrieve_.addAttrID(308);
            attrsToRetrieve_.addAttrID(307);
            attrsToRetrieve_.addAttrID(312);
            attrsToRetrieve_.addAttrID(26);
            attrsToRetrieve_.addAttrID(24);
            attrsToRetrieve_.addAttrID(281);
            attrsToRetrieve_.addAttrID(25);
            attrsToRetrieve_.addAttrID(280);
            attrsToRetrieve_.addAttrID(279);
            attrsToRetrieve_.addAttrID(306);
            attrsToRetrieve_.addAttrID(284);
            attrsToRetrieve_.addAttrID(270);
            attrsToRetrieve_.addAttrID(196);
            attrsToRetrieve_.addAttrID(247);
            attrsToRetrieve_.addAttrID(28);
            attrsToRetrieve_.addAttrID(29);
            attrsToRetrieve_.addAttrID(248);
            attrsToRetrieve_.addAttrID(23);
            attrsToRetrieve_.addAttrID(301);
            attrsToRetrieve_.addAttrID(30);
            attrsToRetrieve_.addAttrID(34);
            attrsToRetrieve_.addAttrID(269);
            attrsToRetrieve_.addAttrID(234);
            attrsToRetrieve_.addAttrID(235);
            attrsToRetrieve_.addAttrID(275);
            attrsToRetrieve_.addAttrID(274);
            attrsToRetrieve_.addAttrID(276);
            attrsToRetrieve_.addAttrID(156);
            attrsToRetrieve_.addAttrID(153);
            attrsToRetrieve_.addAttrID(154);
            attrsToRetrieve_.addAttrID(155);
            attrsToRetrieve_.addAttrID(157);
            attrsToRetrieve_.addAttrID(285);
            attrsToRetrieve_.addAttrID(268);
            attrsToRetrieve_.addAttrID(286);
            attrsToRetrieve_.addAttrID(302);
            attrsToRetrieve_.addAttrID(85);
            attrsToRetrieve_.addAttrID(240);
            attrsToRetrieve_.addAttrID(238);
            attrsToRetrieve_.addAttrID(239);
            attrsToRetrieve_.addAttrID(43);
            attrsToRetrieve_.addAttrID(321);
            attrsToRetrieve_.addAttrID(84);
            attrsToRetrieve_.addAttrID(288);
            attrsToRetrieve_.addAttrID(44);
            attrsToRetrieve_.addAttrID(45);
            attrsToRetrieve_.addAttrID(303);
            attrsToRetrieve_.addAttrID(46);
            attrsToRetrieve_.addAttrID(267);
            attrsToRetrieve_.addAttrID(182);
            attrsToRetrieve_.addAttrID(183);
            attrsToRetrieve_.addAttrID(47);
            attrsToRetrieve_.addAttrID(48);
            attrsToRetrieve_.addAttrID(49);
            attrsToRetrieve_.addAttrID(50);
            attrsToRetrieve_.addAttrID(54);
            attrsToRetrieve_.addAttrID(53);
            attrsToRetrieve_.addAttrID(52);
            attrsToRetrieve_.addAttrID(51);
            attrsToRetrieve_.addAttrID(289);
            attrsToRetrieve_.addAttrID(290);
            attrsToRetrieve_.addAttrID(291);
            attrsToRetrieve_.addAttrID(292);
            attrsToRetrieve_.addAttrID(57);
            attrsToRetrieve_.addAttrID(278);
            attrsToRetrieve_.addAttrID(225);
            attrsToRetrieve_.addAttrID(250);
            attrsToRetrieve_.addAttrID(228);
            attrsToRetrieve_.addAttrID(230);
            attrsToRetrieve_.addAttrID(231);
            attrsToRetrieve_.addAttrID(232);
            attrsToRetrieve_.addAttrID(233);
            attrsToRetrieve_.addAttrID(229);
            attrsToRetrieve_.addAttrID(334);
            attrsToRetrieve_.addAttrID(59);
            attrsToRetrieve_.addAttrID(60);
            attrsToRetrieve_.addAttrID(251);
            attrsToRetrieve_.addAttrID(62);
            attrsToRetrieve_.addAttrID(56);
            attrsToRetrieve_.addAttrID(63);
            attrsToRetrieve_.addAttrID(195);
            attrsToRetrieve_.addAttrID(64);
            attrsToRetrieve_.addAttrID(304);
            attrsToRetrieve_.addAttrID(66);
            attrsToRetrieve_.addAttrID(79);
            attrsToRetrieve_.addAttrID(82);
            attrsToRetrieve_.addAttrID(189);
            attrsToRetrieve_.addAttrID(217);
            attrsToRetrieve_.addAttrID(313);
            attrsToRetrieve_.addAttrID(293);
            attrsToRetrieve_.addAttrID(309);
            attrsToRetrieve_.addAttrID(72);
            attrsToRetrieve_.addAttrID(192);
            attrsToRetrieve_.addAttrID(74);
            attrsToRetrieve_.addAttrID(73);
            attrsToRetrieve_.addAttrID(76);
            attrsToRetrieve_.addAttrID(246);
            attrsToRetrieve_.addAttrID(245);
            attrsToRetrieve_.addAttrID(294);
            attrsToRetrieve_.addAttrID(298);
            attrsToRetrieve_.addAttrID(78);
            attrsToRetrieve_.addAttrID(295);
            attrsToRetrieve_.addAttrID(111);
            attrsToRetrieve_.addAttrID(218);
            attrsToRetrieve_.addAttrID(81);
            attrsToRetrieve_.addAttrID(36);
            attrsToRetrieve_.addAttrID(272);
            attrsToRetrieve_.addAttrID(271);
            attrsToRetrieve_.addAttrID(83);
            attrsToRetrieve_.addAttrID(89);
            attrsToRetrieve_.addAttrID(186);
            attrsToRetrieve_.addAttrID(90);
            attrsToRetrieve_.addAttrID(92);
            attrsToRetrieve_.addAttrID(91);
            attrsToRetrieve_.addAttrID(86);
            attrsToRetrieve_.addAttrID(88);
            attrsToRetrieve_.addAttrID(297);
            attrsToRetrieve_.addAttrID(95);
            attrsToRetrieve_.addAttrID(194);
            attrsToRetrieve_.addAttrID(99);
            attrsToRetrieve_.addAttrID(98);
            attrsToRetrieve_.addAttrID(97);
            attrsToRetrieve_.addAttrID(249);
            attrsToRetrieve_.addAttrID(174);
            attrsToRetrieve_.addAttrID(175);
            attrsToRetrieve_.addAttrID(176);
            attrsToRetrieve_.addAttrID(243);
            attrsToRetrieve_.addAttrID(242);
            attrsToRetrieve_.addAttrID(100);
            attrsToRetrieve_.addAttrID(322);
            attrsToRetrieve_.addAttrID(323);
            attrsToRetrieve_.addAttrID(325);
            attrsToRetrieve_.addAttrID(324);
            attrsToRetrieve_.addAttrID(326);
            attrsToRetrieve_.addAttrID(327);
            attrsToRetrieve_.addAttrID(328);
            attrsToRetrieve_.addAttrID(329);
            attrsToRetrieve_.addAttrID(107);
            attrsToRetrieve_.addAttrID(227);
            attrsToRetrieve_.addAttrID(314);
            attrsToRetrieve_.addAttrID(330);
            attrsToRetrieve_.addAttrID(331);
            attrsToRetrieve_.addAttrID(332);
            attrsToRetrieve_.addAttrID(333);
            attrsToRetrieve_.addAttrID(226);
            attrsToRetrieve_.addAttrID(310);
            attrsToRetrieve_.addAttrID(311);
            attrsToRetrieve_.addAttrID(105);
            attrsToRetrieve_.addAttrID(106);
            attrsToRetrieve_.addAttrID(104);
            attrsToRetrieve_.addAttrID(102);
            attrsToRetrieve_.addAttrID(108);
            attrsToRetrieve_.addAttrID(188);
            attrsToRetrieve_.addAttrID(110);
            attrsToRetrieve_.addAttrID(236);
            attrsToRetrieve_.addAttrID(237);
            attrsToRetrieve_.addAttrID(299);
            attrsToRetrieve_.addAttrID(114);
            attrsToRetrieve_.addAttrID(277);
            attrsToRetrieve_.addAttrID(115);
            attrsToRetrieve_.addAttrID(116);
            attrsToRetrieve_.addAttrID(273);
            attrsToRetrieve_.addAttrID(162);
            attrsToRetrieve_.addAttrID(198);
            attrsToRetrieve_.addAttrID(165);
            attrsToRetrieve_.addAttrID(164);
            attrsToRetrieve_.addAttrID(166);
            attrsToRetrieve_.addAttrID(163);
        }
    }

    @Override
    public NPCPIDSplF copy(OutputQueueImpl outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPIDOutQ tgtOutQID = (NPCPIDOutQ)((OutputQueueImplRemote)outputQueue).getIDCodePoint();
        sendDS.setAction(27);
        sendDS.addCodePoint(this.getIDCodePoint());
        sendDS.addCodePoint(tgtOutQID);
        NPCPIDSplF splfID = new NPCPIDSplF();
        returnDS.addCodePoint(splfID);
        returnDS.addCodePoint(cpCPFMessage);
        int rc = npSystem.makeRequest(sendDS, returnDS);
        if (rc == 0) {
            return splfID;
        }
        NPConversation conversation = npSystem.getConversation();
        String curLevel = conversation.getAttribute(141);
        npSystem.returnConversation(conversation);
        switch (rc) {
            case 4: {
                throw new RequestNotSupportedException(curLevel, 1);
            }
        }
        Trace.log(2, "SpooledFileImplRemote::copy - An exception was thrown attempting to copy the spooled file. RC = " + rc);
        return null;
    }

    @Override
    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(10);
        sendDS.addCodePoint(this.getIDCodePoint());
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
    }

    synchronized void generateMsgHandle() {
        if (this.cpMsgHandle_ == null) {
            this.cpMsgHandle_ = new NPCPMsgHandle();
        }
    }

    @Override
    NPCPAttributeIDList getAttrIDsToRetrieve(int attrToRtv) {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(attrToRtv);
        }
        return attrsToRetrieve_;
    }

    @Override
    NPCPAttributeIDList getAttrIDsToRetrieve() {
        if (!fAttrIDsToRtvBuilt_) {
            this.buildAttrIDsToRtv();
        }
        return attrsToRetrieve_;
    }

    @Override
    public boolean getFMsgRetrieved() {
        return this.fMsgRetrieved_;
    }

    @Override
    public AS400Message getMessage() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        AS400Message msg = null;
        NPCPAttributeIDList cpAttrsToRetrieve = new NPCPAttributeIDList();
        NPCPAttribute cpMessage = new NPCPAttribute();
        cpAttrsToRetrieve.addAttrID(128);
        cpAttrsToRetrieve.addAttrID(142);
        cpAttrsToRetrieve.addAttrID(129);
        cpAttrsToRetrieve.addAttrID(130);
        cpAttrsToRetrieve.addAttrID(147);
        cpAttrsToRetrieve.addAttrID(159);
        cpAttrsToRetrieve.addAttrID(34);
        cpAttrsToRetrieve.addAttrID(110);
        this.retrieveMessage(cpAttrsToRetrieve, cpMessage);
        msg = new AS400Message(cpMessage.getStringValue(147), cpMessage.getStringValue(128));
        msg.setDate(cpMessage.getStringValue(34), cpMessage.getStringValue(110));
        msg.setDefaultReply(cpMessage.getStringValue(130));
        msg.setHelp(cpMessage.getStringValue(129));
        msg.setSeverity(cpMessage.getIntValue(159));
        msg.setType(Integer.parseInt(cpMessage.getStringValue(142)));
        return msg;
    }

    @Override
    public void hold(String holdType) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(6);
        sendDS.addCodePoint(this.getIDCodePoint());
        if (holdType != null) {
            NPCPAttribute cpAttr = new NPCPAttribute();
            cpAttr.setAttrValue(158, holdType);
            sendDS.addCodePoint(cpAttr);
        }
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    @Override
    public void move(SpooledFileImpl targetSpooledFile) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPIDSplF tgtSplfID = new NPCPIDSplF((NPCPIDSplF)((SpooledFileImplRemote)targetSpooledFile).getIDCodePoint());
        tgtSplfID.setID(11);
        sendDS.setAction(11);
        sendDS.addCodePoint(this.getIDCodePoint());
        sendDS.addCodePoint(tgtSplfID);
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    @Override
    public void move(OutputQueueImpl targetOutputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPIDOutQ tgtOutQID = (NPCPIDOutQ)((OutputQueueImplRemote)targetOutputQueue).getIDCodePoint();
        sendDS.setAction(11);
        sendDS.addCodePoint(this.getIDCodePoint());
        sendDS.addCodePoint(tgtOutQID);
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    @Override
    public void moveToTop() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(11);
        sendDS.addCodePoint(this.getIDCodePoint());
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    @Override
    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(7);
        sendDS.addCodePoint(this.getIDCodePoint());
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        this.updateAttrs(this.getAttrIDsToRetrieve());
    }

    synchronized void retrieveMessage(NPCPAttributeIDList cpAttrsToRetrieve, NPCPAttribute cpMessage) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        if (cpMessage == null) {
            cpMessage = new NPCPAttribute();
        }
        this.generateMsgHandle();
        sendDS.setAction(17);
        sendDS.addCodePoint(this.getIDCodePoint());
        if (cpAttrsToRetrieve == null) {
            NPCPAttributeIDList cpGenAttrsToRetrieve = new NPCPAttributeIDList();
            cpGenAttrsToRetrieve.addAttrID(128);
            cpGenAttrsToRetrieve.addAttrID(142);
            cpGenAttrsToRetrieve.addAttrID(129);
            cpGenAttrsToRetrieve.addAttrID(130);
            cpGenAttrsToRetrieve.addAttrID(147);
            cpGenAttrsToRetrieve.addAttrID(159);
            cpGenAttrsToRetrieve.addAttrID(34);
            cpGenAttrsToRetrieve.addAttrID(110);
            sendDS.addCodePoint(cpGenAttrsToRetrieve);
        } else {
            sendDS.addCodePoint(cpAttrsToRetrieve);
        }
        returnDS.addCodePoint(cpMessage);
        returnDS.addCodePoint(this.cpMsgHandle_);
        int rc = npSystem.makeRequest(sendDS, returnDS);
        switch (rc) {
            case 0: {
                this.fMsgRetrieved_ = true;
                break;
            }
            case 14: {
                Trace.log(2, "No spooled file message waiting.");
                throw new ErrorCompletingRequestException(12);
            }
            default: {
                Trace.log(2, "Unexpected Error.");
                throw new InternalErrorException(6);
            }
        }
    }

    @Override
    public void sendNet(PrintParameterList sendOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPAttribute cpSendOptions = sendOptions != null ? sendOptions.getAttrCodePoint() : new NPCPAttribute();
        cpSendOptions.setAttrValue(146, 1);
        sendDS.setAction(12);
        sendDS.addCodePoint(this.getIDCodePoint());
        sendDS.addCodePoint(cpSendOptions);
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
    }

    @Override
    public void sendTCP(PrintParameterList sendOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPAttribute cpSendOptions = sendOptions != null ? sendOptions.getAttrCodePoint() : new NPCPAttribute();
        cpSendOptions.setAttrValue(146, 2);
        sendDS.setAction(12);
        sendDS.addCodePoint(this.getIDCodePoint());
        sendDS.addCodePoint(cpSendOptions);
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
    }

    @Override
    public void setAttributes(PrintParameterList attributes) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (attributes == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        NPDataStream sendDS = new NPDataStream(1);
        NPDataStream returnDS = new NPDataStream(1);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPAttribute cpNewAttrs = attributes.getAttrCodePoint();
        sendDS.setAction(14);
        sendDS.addCodePoint(this.getIDCodePoint());
        sendDS.addCodePoint(cpNewAttrs);
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
        if (this.attrs == null) {
            this.attrs = new NPCPAttribute();
        }
        this.attrs.addUpdateAttributes(cpNewAttrs);
    }
}

