/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTagElement;

public class HTMLTableHeader
extends HTMLTableCell {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6954665365850223957L;
    private boolean useFO_ = false;
    private int borderWidth_ = 1;
    private int cellPadding_ = 1;

    public HTMLTableHeader() {
    }

    public HTMLTableHeader(HTMLTagElement element) {
        super(element);
    }

    @Override
    public String getTag() {
        return this.getTag(this.getElement());
    }

    @Override
    public String getFOTag() {
        return this.getFOTag(this.getElement());
    }

    @Override
    public String getFOTag(HTMLTagElement element) {
        String align;
        int rowSpan;
        int columnSpan;
        int width;
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (element == null) {
            throw new NullPointerException("element");
        }
        StringBuffer tag = new StringBuffer("<fo:table-cell border-style='solid' border-width='");
        tag.append(this.borderWidth_);
        tag.append("px'");
        tag.append(" padding='");
        tag.append(this.cellPadding_);
        tag.append("px'");
        int height = this.getHeight();
        if (height > 1) {
            tag.append(" height='");
            tag.append(height);
            if (this.isHeightInPercent()) {
                tag.append("%");
            }
            tag.append("'");
        }
        if ((width = this.getWidth()) > 1) {
            tag.append(" width='");
            tag.append(width);
            if (this.isWidthInPercent()) {
                tag.append("%");
            }
            tag.append("'");
        }
        if ((columnSpan = this.getColumnSpan()) > 1) {
            tag.append(" number-columns-spanned='");
            tag.append(columnSpan);
            tag.append("'");
        }
        if ((rowSpan = this.getRowSpan()) > 1) {
            tag.append(" number-rows-spanned='");
            tag.append(rowSpan);
            tag.append("'");
        }
        tag.append(">\n");
        tag.append("<fo:block font-weight='bold'");
        String dir = this.getDirection();
        if (dir != null && dir.length() > 0) {
            if (dir.equals("rtl")) {
                tag.append(" writing-mode='rl'");
            } else {
                tag.append(" writing-mode='lr'");
            }
        }
        if ((align = this.getHorizontalAlignment()) != null) {
            tag.append(" text-align='");
            if (align.equals("center")) {
                tag.append("center");
            } else if (align.equals("left")) {
                tag.append("start");
            } else if (align.equals("right")) {
                tag.append("end");
            }
            tag.append("'");
        }
        tag.append(">");
        tag.append(element.getFOTag());
        tag.append("</fo:block>\n");
        tag.append("</fo:table-cell>\n");
        this.setUseFO(useFO);
        return tag.toString();
    }

    @Override
    public String getTag(HTMLTagElement element) {
        if (this.useFO_) {
            return this.getFOTag(element);
        }
        if (element == null) {
            throw new NullPointerException("element");
        }
        StringBuffer tag = new StringBuffer("<th");
        tag.append(this.getAttributeTag());
        tag.append(element.getTag());
        tag.append("</th>\n");
        return tag.toString();
    }

    @Override
    public boolean isUseFO() {
        return this.useFO_;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        Integer oldWidth = this.borderWidth_;
        Integer newWidth = borderWidth;
        this.borderWidth_ = borderWidth;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", oldWidth, newWidth);
        }
    }

    @Override
    public void setCellPadding(int cellPadding) {
        Integer oldPadding = this.cellPadding_;
        Integer newPadding = cellPadding;
        this.cellPadding_ = cellPadding;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", oldPadding, newPadding);
        }
    }

    @Override
    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    @Override
    public String toString() {
        return this.getTag();
    }
}

