/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.cassandra.db.guardrails.Guardrail;
import org.apache.cassandra.service.ClientState;

public class DisableFlag
extends Guardrail {
    private final Predicate<ClientState> disabled;
    private final String what;

    public DisableFlag(String name, Predicate<ClientState> disabled, String what) {
        super(name);
        this.disabled = disabled;
        this.what = what;
    }

    public void ensureEnabled(@Nullable ClientState state) {
        this.ensureEnabled(this.what, state);
    }

    public void ensureEnabled(String what, @Nullable ClientState state) {
        if (this.enabled(state) && this.disabled.test(state)) {
            this.fail(what + " is not allowed", state);
        }
    }
}

