/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ShortSerializer
extends TypeSerializer<Short> {
    public static final ShortSerializer instance = new ShortSerializer();

    @Override
    public <V> Short deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : Short.valueOf(accessor.toShort(value));
    }

    @Override
    public ByteBuffer serialize(Short value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 2) {
            throw new MarshalException(String.format("Expected 2 bytes for a smallint (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Short value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }
}

